/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg.datatypes;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGValueType;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.p11.z27;
import com.aspose.html.internal.p15.z2;
import com.aspose.html.internal.p15.z5;
import com.aspose.html.internal.p98.z4;
import com.aspose.html.z10;

public class SVGTransform
extends SVGValueType {
    public static final int SVG_TRANSFORM_MATRIX = 1;
    public static final int SVG_TRANSFORM_ROTATE = 4;
    public static final int SVG_TRANSFORM_SCALE = 3;
    public static final int SVG_TRANSFORM_SKEWX = 5;
    public static final int SVG_TRANSFORM_SKEWY = 6;
    public static final int SVG_TRANSFORM_TRANSLATE = 2;
    public static final int SVG_TRANSFORM_UNKNOWN = 0;
    private IGenericList<Float> arguments;
    private z5 drFactory;
    private final SVGMatrix transformMatrix;
    private int type;

    public final float getAngle() {
        if (this.type == 4 || this.type == 5 || this.type == 6) {
            return this.arguments.get_Item(0).floatValue();
        }
        return 0.0f;
    }

    public final IGenericList<Float> getArguments() {
        return this.arguments;
    }

    private void setArguments(IGenericList<Float> iGenericList) {
        this.arguments = iGenericList;
    }

    public final SVGMatrix getMatrix() {
        return this.transformMatrix;
    }

    public final int getType() {
        return this.type;
    }

    public SVGTransform(z5 z5100) {
        this.drFactory = z5100;
        this.transformMatrix = new SVGMatrix();
    }

    @Override
    public Object deepClone() {
        SVGTransform sVGTransform = new SVGTransform(this.drFactory);
        switch (this.getType()) {
            case 4: {
                sVGTransform.setRotate(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue(), this.getArguments().get_Item(2).floatValue());
                break;
            }
            case 1: {
                sVGTransform.setMatrix((SVGMatrix)this.getMatrix().deepClone());
                break;
            }
            case 2: {
                sVGTransform.setTranslate(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue());
                break;
            }
            case 3: {
                sVGTransform.setScale(this.getArguments().get_Item(0).floatValue(), this.getArguments().get_Item(1).floatValue());
                break;
            }
            case 5: {
                sVGTransform.setSkewX(this.getArguments().get_Item(0).floatValue());
                break;
            }
            case 6: {
                sVGTransform.setSkewY(this.getArguments().get_Item(0).floatValue());
                break;
            }
            default: {
                return StringExtensions.Empty;
            }
        }
        return sVGTransform;
    }

    public final void setMatrix(SVGMatrix sVGMatrix) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 1;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF()})));
        SVGMatrix.z1.m1(this.transformMatrix, SVGMatrix.z1.m3(sVGMatrix).m188());
        DOMObject.z1.m1(this, "Matrix");
    }

    public final void setRotate(float f2, float f3, float f4) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 4;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{f2, f3, f4})));
        z2 z2100 = this.drFactory.m1(1.0f, 0.0f, 0.0f, 1.0f, f3, f4);
        z2100.rotate(f2);
        z2100.translate(-f3, -f4);
        SVGMatrix.z1.m1(this.getMatrix(), z2100);
        DOMObject.z1.m1(this, "Matrix");
    }

    public final void setScale(float f2, float f3) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 3;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{f2, f3})));
        SVGMatrix.z1.m1(this.getMatrix(), this.drFactory.m1(f2, 0.0f, 0.0f, f3, 0.0f, 0.0f));
        DOMObject.z1.m1(this, "Matrix");
    }

    public final void setSkewX(float f2) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 5;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{f2})));
        z2 z2100 = this.drFactory.m1(1.0f, 0.0f, (float)msMath.tan(z27.degreesToRadians(f2)), 1.0f, 0.0f, 0.0f);
        SVGMatrix.z1.m1(this.getMatrix(), z2100);
        DOMObject.z1.m1(this, "Matrix");
    }

    public final void setSkewY(float f2) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 6;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{f2})));
        z2 z2100 = this.drFactory.m1(1.0f, (float)msMath.tan(z27.degreesToRadians(f2)), 0.0f, 1.0f, 0.0f, 0.0f);
        SVGMatrix.z1.m1(this.getMatrix(), z2100);
        DOMObject.z1.m1(this, "Matrix");
    }

    public final void setTranslate(float f2, float f3) {
        if (this.isReadOnly()) {
            z10.m39();
        }
        this.type = 2;
        this.setArguments(Array.toGenericList(Array.boxing(new float[]{f2, f3})));
        SVGMatrix.z1.m1(this.getMatrix(), this.drFactory.m1(1.0f, 0.0f, 0.0f, 1.0f, f2, f3));
        DOMObject.z1.m1(this, "Matrix");
    }

    public String toString() {
        return z4.m2(SVGTransform.class.getName(), this);
    }
}

