/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.svg.ISVGTests;
import com.aspose.html.dom.svg.SVGElement;
import com.aspose.html.dom.svg.SVGForeignObjectElement;
import com.aspose.html.dom.svg.SVGGeometryElement;
import com.aspose.html.dom.svg.SVGImageElement;
import com.aspose.html.dom.svg.SVGSVGElement;
import com.aspose.html.dom.svg.SVGUseElement;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedTransformList;
import com.aspose.html.dom.svg.datatypes.SVGLength;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGRect;
import com.aspose.html.dom.svg.datatypes.SVGStringList;
import com.aspose.html.dom.svg.datatypes.SVGTransform;
import com.aspose.html.dom.z1;
import com.aspose.html.dom.z7;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p100.z5;
import com.aspose.html.internal.p102.z4;
import com.aspose.html.internal.p292.z3;
import com.aspose.html.internal.p75.z14;
import com.aspose.html.internal.p75.z17;
import com.aspose.html.internal.p88.z2;

public class SVGGraphicsElement
extends SVGElement
implements ISVGTests {
    private final z17 requiredExtensions;
    private final z17 requiredFeatures;
    private final z17 systemLanguage;
    private final z14 transform = new z14(this, "transform", 1);

    public final SVGElement getFarthestViewportElement() {
        Element element = null;
        for (Element element2 = this.getParentElement(); element2 != null; element2 = element2.getParentElement()) {
            if (!"svg".equals(element2.getTagName())) continue;
            element = element2;
        }
        return (SVGElement)element;
    }

    public final SVGElement getNearestViewportElement() {
        return this.getViewportElement();
    }

    @Override
    public final SVGStringList getRequiredExtensions() {
        return (SVGStringList)this.requiredExtensions.getValue();
    }

    @Override
    public final SVGStringList getRequiredFeatures() {
        return (SVGStringList)this.requiredFeatures.getValue();
    }

    @Override
    public final SVGStringList getSystemLanguage() {
        return (SVGStringList)this.systemLanguage.getValue();
    }

    public final SVGAnimatedTransformList getTransform() {
        return (SVGAnimatedTransformList)this.transform.getValue();
    }

    public SVGGraphicsElement(z7 z710, Document document) {
        super(z710, document);
        this.requiredFeatures = new z17(this, "requiredFeatures");
        this.requiredExtensions = new z17(this, "requiredExtensions");
        this.systemLanguage = new z17((SVGElement)this, "systemLanguage", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SVGRect getBBox() {
        Node.z2 z2100 = Node.z4.m20(this);
        if (z2100.get(Node.z2.m2578) || z2100.get(Node.z2.m2579) || "a".equals(this.getTagName()) && Node.z4.m20(this.getParentNode()).get(Node.z2.m2579)) {
            SVGGeometryElement sVGGeometryElement = Operators.as(this, SVGGeometryElement.class);
            if (sVGGeometryElement == null) {
                return new SVGRect(this.getOwnerDocument().getContext().getService(z5.class).m6(this).Clone());
            }
            z2 z2101 = new z2();
            z2101.m8(com.aspose.html.internal.p102.z3.m3(sVGGeometryElement));
            return new SVGRect(z2101.m91().getX(), z2101.m91().getY(), z2101.m91().getWidth(), z2101.m91().getHeight());
        }
        if (z2100.get(Node.z2.m2575) || "use".equals(this.getTagName())) {
            Object object;
            final SVGRect[] sVGRectArray = new SVGRect[]{null};
            SVGGraphicsElement sVGGraphicsElement = z2100.get(Node.z2.m2575) ? this : ((SVGUseElement)this).getAnimatedInstanceRoot();
            Action<Node> action = new Action<Node>(){

                public void m4(Node node) {
                    SVGGraphicsElement sVGGraphicsElement = Operators.as(node, SVGGraphicsElement.class);
                    if (sVGGraphicsElement != null) {
                        com.aspose.html.internal.p15.z2 z2100 = SVGMatrix.z1.m3(z3.m1((IGenericEnumerable)sVGGraphicsElement.getTransform().getAnimVal(), new SVGMatrix(), new com.aspose.html.internal.p283.z17<SVGMatrix, SVGTransform, SVGMatrix>(){

                            @Override
                            public SVGMatrix m1(SVGMatrix sVGMatrix, SVGTransform sVGTransform) {
                                return sVGMatrix.multiply(sVGTransform.getMatrix());
                            }
                        }));
                        sVGRectArray[0] = z4.m1(sVGRectArray[0], new SVGRect(z2100.m1(sVGGraphicsElement.getBBox().getRectangleF().Clone()).Clone()));
                    }
                }

                @Override
                public /* synthetic */ void invoke(Object object) {
                    this.m4((Node)object);
                }
            };
            if (Node.z4.m20(sVGGraphicsElement).get(Node.z2.m2575)) {
                object = Node.z4.m19(sVGGraphicsElement).iterator();
                try {
                    while (object.hasNext()) {
                        SVGGraphicsElement sVGGraphicsElement2;
                        Node node = (Node)object.next();
                        if (Node.z4.m20(node).get(Node.z2.m2575)) {
                            action.invoke(node);
                            continue;
                        }
                        if (!Node.z4.m20(node).get(Node.z2.m2577) || (sVGGraphicsElement2 = Operators.as(node, SVGGraphicsElement.class)) == null || !sVGGraphicsElement2.isRendered()) continue;
                        action.invoke(node);
                    }
                }
                finally {
                    if (Operators.is(object, IDisposable.class)) {
                        ((IDisposable)object).dispose();
                    }
                }
            } else {
                sVGRectArray[0] = sVGGraphicsElement.getBBox();
                sVGRectArray[0].setX(sVGRectArray[0].getX() + ((SVGLength)((SVGUseElement)this).getX().getAnimVal()).getValue());
                sVGRectArray[0].setY(sVGRectArray[0].getY() + ((SVGLength)((SVGUseElement)this).getY().getAnimVal()).getValue());
            }
            object = sVGRectArray[0];
            if (object == null) {
                object = new SVGRect(0.0f, 0.0f, 0.0f, 0.0f);
            }
            return object;
        }
        if ("foreignObject".equals(this.getTagName())) {
            SVGForeignObjectElement sVGForeignObjectElement = (SVGForeignObjectElement)this;
            return new SVGRect(((SVGLength)sVGForeignObjectElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getHeight().getAnimVal()).getValue());
        }
        if ("image".equals(this.getTagName())) {
            SVGImageElement sVGImageElement = (SVGImageElement)this;
            return new SVGRect(((SVGLength)sVGImageElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getHeight().getAnimVal()).getValue());
        }
        return new SVGRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public final SVGMatrix getCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (z1.z5.m2256.m2(this) && this.getOwnerSVGElement() == null) {
            return ((SVGSVGElement)this).rootSVGTransform();
        }
        Element element = this.getParentElement();
        while (!Operators.is(element, SVGGraphicsElement.class)) {
            element = element.getParentElement();
        }
        SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
        if (z1.z5.m2256.m2(sVGGraphicsElement)) {
            sVGMatrix = new SVGMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            for (SVGTransform sVGTransform : (Iterable)sVGGraphicsElement.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        } else {
            sVGMatrix = sVGGraphicsElement.getCTM();
        }
        for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
        }
        return sVGMatrix;
    }

    public final SVGMatrix getScreenCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (z1.z5.m2256.m2(this) && this.getOwnerSVGElement() == null) {
            sVGMatrix = ((SVGSVGElement)this).rootSVGTransform();
        } else {
            Element element = this.getParentElement();
            while (!Operators.is(element, SVGGraphicsElement.class)) {
                element = element.getParentElement();
            }
            SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
            sVGMatrix = sVGGraphicsElement.getScreenCTM();
            for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        }
        return sVGMatrix;
    }
}

