/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.events;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.EventTarget;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.events.CustomEvent;
import com.aspose.html.dom.events.ErrorEvent;
import com.aspose.html.dom.events.KeyboardEvent;
import com.aspose.html.dom.events.MouseEvent;
import com.aspose.html.dom.events.UIEvent;
import com.aspose.html.dom.events.z3;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.LinkedList;
import com.aspose.html.internal.ms.System.Collections.Generic.LinkedListNode;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p11.z30;
import com.aspose.html.window.z6;
import com.aspose.html.z10;
import java.util.concurrent.atomic.AtomicReference;

public class Event
extends DOMObject {
    public static final int AT_TARGET_PHASE = 2;
    public static final int BUBBLING_PHASE = 3;
    public static final int CAPTURING_PHASE = 1;
    public static final int NONE_PHASE = 0;
    private z2 flags = new z2();
    private boolean auto_Bubbles;
    private boolean auto_Cancelable;
    private EventTarget auto_CurrentTarget;
    private int auto_EventPhase;
    private boolean auto_IsTrusted;
    private EventTarget auto_Target;
    private long auto_TimeStamp;
    private String auto_Type;
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("CUSTOMEVENT", "EVENT", "EVENTS", "HTMLEVENTS", "KEYBOARDEVENT", "KEYEVENTS", "MOUSEEVENT", "MOUSEEVENTS", "UIEVENT", "UIEVENTS");

    public final boolean getBubbles() {
        return this.auto_Bubbles;
    }

    private void setBubbles(boolean bl2) {
        this.auto_Bubbles = bl2;
    }

    public final boolean getCancelable() {
        return this.auto_Cancelable;
    }

    private void setCancelable(boolean bl2) {
        this.auto_Cancelable = bl2;
    }

    public final EventTarget getCurrentTarget() {
        return this.auto_CurrentTarget;
    }

    final void setCurrentTarget(EventTarget eventTarget) {
        this.auto_CurrentTarget = eventTarget;
    }

    public final boolean getDefaultPrevented() {
        return this.flags.get(z2.m4173);
    }

    public final int getEventPhase() {
        return this.auto_EventPhase;
    }

    final void setEventPhase(int n2) {
        this.auto_EventPhase = n2;
    }

    public final boolean isTrusted() {
        return this.auto_IsTrusted;
    }

    private void setTrusted(boolean bl2) {
        this.auto_IsTrusted = bl2;
    }

    public final EventTarget getTarget() {
        return this.auto_Target;
    }

    final void setTarget(EventTarget eventTarget) {
        this.auto_Target = eventTarget;
    }

    public final long getTimeStamp() {
        return this.auto_TimeStamp;
    }

    private void setTimeStamp(long l2) {
        this.auto_TimeStamp = l2;
    }

    public final String getType() {
        return this.auto_Type;
    }

    private void setType(String string) {
        this.auto_Type = string;
    }

    public Event(String string) {
        this(string, new z1());
    }

    Event(String string, z1 z1100) {
        this.setEventPhase(0);
        this.flags.set(z2.m4176);
        this.setType(string);
        this.setBubbles(z1100.getBubbles());
        this.setCancelable(z1100.getCancelable());
        this.setTrusted(z1100.isTrusted());
        this.setTimeStamp(Convert.toUInt64(DateTime.getNow().getTicks()));
    }

    public Event(String string, IGenericDictionary<String, Object> iGenericDictionary) {
        this(string, new z1(iGenericDictionary));
    }

    public static Event createDOMContentLoadedEvent(z1 z1100) {
        return Event.createEvent("DOMContentLoaded", z1100);
    }

    public static Event createError(Exception exception) {
        return new ErrorEvent(exception);
    }

    public static Event createError(RuntimeException runtimeException) {
        return new ErrorEvent(runtimeException);
    }

    public static Event createEvent(String string) {
        return Event.createEvent(string, new z1());
    }

    static Event createEvent(String string, z1 z1100) {
        z1100.setTrusted(true);
        return new Event(string, z1100);
    }

    public static Event createEventByType(String string) {
        Event event;
        switch (gStringSwitchMap.of(StringExtensions.toUpperInvariant(string))) {
            case 0: {
                event = new CustomEvent(StringExtensions.Empty);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                event = new Event(StringExtensions.Empty);
                break;
            }
            case 4: 
            case 5: {
                event = new KeyboardEvent(StringExtensions.Empty);
                break;
            }
            case 6: 
            case 7: {
                event = new MouseEvent(StringExtensions.Empty);
                break;
            }
            case 8: 
            case 9: {
                event = new UIEvent(StringExtensions.Empty);
                break;
            }
            default: {
                event = z10.m2(Event.class);
            }
        }
        event.flags.m10(z2.m4176);
        return event;
    }

    public final boolean dispatch(EventTarget eventTarget) {
        LinkedListNode<EventTarget> linkedListNode;
        if (this.flags.get(z2.m4175) || !this.flags.get(z2.m4176)) {
            z10.m35();
        }
        this.flags.set(z2.m4175);
        this.setTarget(eventTarget);
        LinkedList<EventTarget> linkedList = this.getPath(this.getTarget());
        this.setEventPhase(1);
        for (linkedListNode = linkedList.getFirst(); linkedListNode != null && !this.flags.get(z2.m4179); linkedListNode = linkedListNode.getNext()) {
            this.invoke(linkedListNode.getValue());
        }
        this.setEventPhase(2);
        if (!this.flags.get(z2.m4179)) {
            this.invoke(this.getTarget());
        }
        if (this.getBubbles()) {
            this.setEventPhase(3);
            for (linkedListNode = linkedList.getLast(); linkedListNode != null && !this.flags.get(z2.m4179); linkedListNode = linkedListNode.getPrevious()) {
                this.invoke(linkedListNode.getValue());
            }
        }
        this.flags.m10(z2.m4175);
        this.setEventPhase(0);
        this.setCurrentTarget(null);
        return !this.flags.get(z2.m4173);
    }

    private LinkedList<EventTarget> getPath(EventTarget eventTarget) {
        Node node;
        LinkedList<EventTarget> linkedList = new LinkedList<EventTarget>();
        while (eventTarget != null && (node = Operators.as(eventTarget, Node.class)) != null) {
            eventTarget = (node.getNodeType() & 0xFFFF) != 9 ? node.getParentNode() : Operators.as(((Document)node).getContext().getWindow(), EventTarget.class);
            if (eventTarget == null) continue;
            linkedList.addFirst(eventTarget);
        }
        return linkedList;
    }

    public final void initEvent(String string, boolean bl2, boolean bl3) {
        if (this.flags.get(z2.m4175)) {
            return;
        }
        this.flags.set(z2.m4176);
        this.flags.m10(z2.m4179);
        this.flags.m10(z2.m4178);
        this.flags.m10(z2.m4173);
        this.setTrusted(false);
        this.setTarget(null);
        this.setType(string);
        this.setBubbles(bl2);
        this.setCancelable(bl3);
        this.setTimeStamp(Convert.toUInt64(DateTime.getNow().getTicks()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(EventTarget eventTarget) {
        List<z3.z2> list = new List<z3.z2>(eventTarget.EventMap.m132(this.getType()));
        this.setCurrentTarget(eventTarget);
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z3.z2 z2100 = (z3.z2)iGenericEnumerator.next();
                if (this.flags.get(z2.m4179)) {
                    return;
                }
                if (this.getEventPhase() == 1 && !z2100.m610() || this.getEventPhase() == 3 && z2100.m610()) continue;
                try {
                    z2100.m612().handleEvent(this);
                }
                catch (Exception exception) {
                    Node node = Operators.as(eventTarget, Node.class);
                    Document document = node != null ? node.nodeDocument : ((z6)eventTarget).m359().getActiveDocument();
                    document.dispatchEvent(new ErrorEvent(exception));
                }
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public final void preventDefault() {
        if (this.getCancelable() && !this.flags.get(z2.m4177)) {
            this.flags.set(z2.m4173);
        }
    }

    public final void stopImmediatePropagation() {
        this.flags.set(z2.m4179);
        this.flags.set(z2.m4178);
    }

    public final void stopPropagation() {
        this.flags.set(z2.m4179);
    }

    private static class z2
    extends z30 {
        public static final int m4173;
        public static final int m4174;
        public static final int m4175;
        public static final int m4176;
        public static final int m4177;
        public static final int m4178;
        public static final int m4179;
        private static AtomicReference<z30.z1> m40;

        public z2() {
            super(m40.get());
        }

        static {
            m40 = new AtomicReference<Object>(null);
            z30.z1 z1100 = new z30.z1();
            m4179 = z1100.m52("STOP_PROPAGATION");
            m4178 = z1100.m52("STOP_IMMEDIATE_PROPAGATION");
            m4173 = z1100.m52("CANCELED");
            m4177 = z1100.m52("IN_PASSIVE_LISTENER");
            m4174 = z1100.m52("COMPOSED");
            m4176 = z1100.m52("INITIALIZED");
            m4175 = z1100.m52("DISPATCH");
            m40.set(z1100);
        }
    }

    public static class z1
    extends Dictionary<String, Object> {
        private boolean auto_IsTrusted;

        public final boolean getBubbles() {
            return com.aspose.html.internal.p14.z1.m1(String.class, Object.class, Boolean.class, this, "bubbles", false);
        }

        public final void setBubbles(boolean bl2) {
            this.set_Item("bubbles", bl2);
        }

        public final boolean getCancelable() {
            return com.aspose.html.internal.p14.z1.m1(String.class, Object.class, Boolean.class, this, "cancelable", false);
        }

        public final void setCancelable(boolean bl2) {
            this.set_Item("cancelable", bl2);
        }

        final boolean isTrusted() {
            return this.auto_IsTrusted;
        }

        final void setTrusted(boolean bl2) {
            this.auto_IsTrusted = bl2;
        }

        public z1() {
        }

        public z1(IGenericDictionary<String, Object> iGenericDictionary) {
            super(iGenericDictionary);
        }
    }
}

