/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.canvas;

import com.aspose.html.ArrayBuffer;
import com.aspose.html.HTMLCanvasElement;
import com.aspose.html.HTMLImageElement;
import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.canvas.ICanvasGradient;
import com.aspose.html.dom.canvas.ICanvasPattern;
import com.aspose.html.dom.canvas.ICanvasRenderingContext2D;
import com.aspose.html.dom.canvas.IImageData;
import com.aspose.html.dom.canvas.ITextMetrics;
import com.aspose.html.dom.canvas.Path2D;
import com.aspose.html.dom.canvas.z1;
import com.aspose.html.dom.canvas.z11;
import com.aspose.html.dom.canvas.z14;
import com.aspose.html.dom.canvas.z16;
import com.aspose.html.dom.canvas.z2;
import com.aspose.html.dom.canvas.z3;
import com.aspose.html.dom.canvas.z4;
import com.aspose.html.dom.canvas.z5;
import com.aspose.html.dom.canvas.z7;
import com.aspose.html.dom.css.CSSPrimitiveValue;
import com.aspose.html.dom.css.CSSValue;
import com.aspose.html.dom.css.z1;
import com.aspose.html.dom.css.z6;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.drawing.ITrueTypeFont;
import com.aspose.html.drawing.Unit;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Converter;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p140.z28;
import com.aspose.html.internal.p17.z8;
import com.aspose.html.internal.p283.z27;
import com.aspose.html.internal.p47.z18;
import com.aspose.html.internal.p47.z26;
import com.aspose.html.z10;

public class z9
extends DOMObject
implements ICanvasRenderingContext2D {
    private HTMLCanvasElement m2629;
    private z2 m2620;
    private MemoryStream m2630;
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("copy", "destination-atop", "destination-in", "destination-out", "destination-over", "lighter", "source-atop", "source-in", "source-out", "source-over", "xor", "butt", "round", "square", "miter", "bevel", "left", "start", "end", "right", "center", "alphabetic", "bottom", "hanging", "ideographic", "middle", "top", "evenodd", "nonzero");

    @Override
    public final HTMLCanvasElement getCanvas() {
        return this.m2629;
    }

    @Override
    public final Object getFillStyle() {
        if (Operators.is(((z4)this.m2620.getGraphicContext()).getFillBrush(), z11.class)) {
            return ((z11)((z4)this.m2620.getGraphicContext()).getFillBrush()).m438();
        }
        if (Operators.is(((z4)this.m2620.getGraphicContext()).getFillBrush(), ICanvasGradient.class) || Operators.is(((z4)this.m2620.getGraphicContext()).getFillBrush(), ICanvasPattern.class)) {
            return ((z4)this.m2620.getGraphicContext()).getFillBrush();
        }
        return null;
    }

    @Override
    public final void setFillStyle(Object object) {
        if (Operators.is(object, String.class)) {
            try {
                ((z4)this.m2620.getGraphicContext()).setFillBrush(new z11(this.getCanvas(), (String)object));
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
            return;
        }
        if (Operators.is(object, ICanvasGradient.class) || Operators.is(object, ICanvasPattern.class)) {
            ((z4)this.m2620.getGraphicContext()).setFillBrush((IBrush)object);
            return;
        }
    }

    @Override
    public final String getFont() {
        return ((z4)this.m2620.getGraphicContext()).m423();
    }

    @Override
    public final void setFont(String string) {
        com.aspose.html.z1 z1100 = (com.aspose.html.z1)this.getCanvas().getOwnerDocument().getContext();
        z18 z1810 = (z18)((z26)z1100.m3()).m2(StringExtensions.format("font:{0}", string), this.getCanvas());
        com.aspose.html.internal.p9.z1 z1101 = new com.aspose.html.internal.p9.z1(z1810);
        com.aspose.html.internal.p17.z2 z2100 = this.getCanvas().getOwnerDocument().getContext().getService(com.aspose.html.internal.p172.z2.class).m1(z1101);
        ((z4)this.m2620.getGraphicContext()).setFont(new com.aspose.html.internal.p153.z1(z2100.m212()));
        ((z4)this.m2620.getGraphicContext()).setFontSize((float)Unit.fromPoints(z2100.m209()).getValue(UnitType.Px));
        ((z4)this.m2620.getGraphicContext()).setFontStyle(z2100.getStyle());
        ((z4)this.m2620.getGraphicContext()).m89(string);
    }

    @Override
    public final double getGlobalAlpha() {
        return ((z4)this.m2620.getGraphicContext()).m424();
    }

    @Override
    public final void setGlobalAlpha(double d2) {
        ((z4)this.m2620.getGraphicContext()).m12((float)d2);
    }

    @Override
    public final String getGlobalCompositeOperation() {
        switch (((z4)this.m2620.getGraphicContext()).m425()) {
            case 9: {
                return "copy";
            }
            case 4: {
                return "destination-atop";
            }
            case 5: {
                return "destination-in";
            }
            case 6: {
                return "destination-out";
            }
            case 7: {
                return "destination-over";
            }
            case 8: {
                return "lighter";
            }
            case 0: {
                return "source-atop";
            }
            case 1: {
                return "source-in";
            }
            case 2: {
                return "source-out";
            }
            case 3: {
                return "source-over";
            }
            case 10: {
                return "xor";
            }
        }
        return "source-over";
    }

    @Override
    public final void setGlobalCompositeOperation(String string) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(string)))) {
            case 0: {
                ((z4)this.m2620.getGraphicContext()).m63(9);
                break;
            }
            case 1: {
                ((z4)this.m2620.getGraphicContext()).m63(4);
                break;
            }
            case 2: {
                ((z4)this.m2620.getGraphicContext()).m63(5);
                break;
            }
            case 3: {
                ((z4)this.m2620.getGraphicContext()).m63(6);
                break;
            }
            case 4: {
                ((z4)this.m2620.getGraphicContext()).m63(7);
                break;
            }
            case 5: {
                ((z4)this.m2620.getGraphicContext()).m63(8);
                break;
            }
            case 6: {
                ((z4)this.m2620.getGraphicContext()).m63(0);
                break;
            }
            case 7: {
                ((z4)this.m2620.getGraphicContext()).m63(1);
                break;
            }
            case 8: {
                ((z4)this.m2620.getGraphicContext()).m63(2);
                break;
            }
            case 9: {
                ((z4)this.m2620.getGraphicContext()).m63(3);
                break;
            }
            case 10: {
                ((z4)this.m2620.getGraphicContext()).m63(10);
                break;
            }
            default: {
                ((z4)this.m2620.getGraphicContext()).m63(3);
            }
        }
    }

    @Override
    public final boolean getImageSmoothingEnabled() {
        return ((z4)this.m2620.getGraphicContext()).getImageSmoothingEnabled();
    }

    @Override
    public final void setImageSmoothingEnabled(boolean bl2) {
        ((z4)this.m2620.getGraphicContext()).setImageSmoothingEnabled(bl2);
    }

    @Override
    public final String getLineCap() {
        switch (((z4)this.m2620.getGraphicContext()).getLineCap()) {
            case 0: {
                return "butt";
            }
            case 2: {
                return "round";
            }
            case 1: {
                return "square";
            }
        }
        return "butt";
    }

    @Override
    public final void setLineCap(String string) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(string)))) {
            case 11: {
                ((z4)this.m2620.getGraphicContext()).setLineCap(0);
                break;
            }
            case 12: {
                ((z4)this.m2620.getGraphicContext()).setLineCap(2);
                break;
            }
            case 13: {
                ((z4)this.m2620.getGraphicContext()).setLineCap(1);
            }
        }
    }

    @Override
    public final double getLineDashOffset() {
        return ((z4)this.m2620.getGraphicContext()).getLineDashOffset();
    }

    @Override
    public final void setLineDashOffset(double d2) {
        ((z4)this.m2620.getGraphicContext()).setLineDashOffset((float)d2);
    }

    @Override
    public final String getLineJoin() {
        switch (((z4)this.m2620.getGraphicContext()).getLineJoin()) {
            case 1: {
                return "bevel";
            }
            case 2: {
                return "round";
            }
            case 3: {
                return "miter";
            }
        }
        return "miter";
    }

    @Override
    public final void setLineJoin(String string) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(string)))) {
            case 14: {
                ((z4)this.m2620.getGraphicContext()).setLineJoin(3);
                break;
            }
            case 12: {
                ((z4)this.m2620.getGraphicContext()).setLineJoin(2);
                break;
            }
            case 15: {
                ((z4)this.m2620.getGraphicContext()).setLineJoin(1);
            }
        }
    }

    @Override
    public final double getLineWidth() {
        return ((z4)this.m2620.getGraphicContext()).getLineWidth();
    }

    @Override
    public final void setLineWidth(double d2) {
        ((z4)this.m2620.getGraphicContext()).setLineWidth((float)d2);
    }

    @Override
    public final double getMiterLimit() {
        return ((z4)this.m2620.getGraphicContext()).getMiterLimit();
    }

    @Override
    public final void setMiterLimit(double d2) {
        ((z4)this.m2620.getGraphicContext()).setMiterLimit((float)d2);
    }

    @Override
    public final double getShadowBlur() {
        return ((z4)this.m2620.getGraphicContext()).m428();
    }

    @Override
    public final void setShadowBlur(double d2) {
        ((z4)this.m2620.getGraphicContext()).m14((float)d2);
    }

    @Override
    public final String getShadowColor() {
        return ((z4)this.m2620.getGraphicContext()).m430();
    }

    @Override
    public final void setShadowColor(String string) {
        ((z4)this.m2620.getGraphicContext()).m90(string);
        try {
            ((z4)this.m2620.getGraphicContext()).m1(z1.m1(string, this.getCanvas()).Clone());
        }
        catch (RuntimeException runtimeException) {
            com.aspose.html.internal.p23.z4.m300().error("ShadowColor");
        }
    }

    @Override
    public final double getShadowOffsetX() {
        return ((z4)this.m2620.getGraphicContext()).m431();
    }

    @Override
    public final void setShadowOffsetX(double d2) {
        ((z4)this.m2620.getGraphicContext()).m15((float)d2);
    }

    @Override
    public final double getShadowOffsetY() {
        return ((z4)this.m2620.getGraphicContext()).m432();
    }

    @Override
    public final void setShadowOffsetY(double d2) {
        ((z4)this.m2620.getGraphicContext()).m16((float)d2);
    }

    @Override
    public final Object getStrokeStyle() {
        if (Operators.is(((z4)this.m2620.getGraphicContext()).getStrokeBrush(), z11.class)) {
            return ((z11)((z4)this.m2620.getGraphicContext()).getStrokeBrush()).m438();
        }
        if (Operators.is(((z4)this.m2620.getGraphicContext()).getStrokeBrush(), ICanvasGradient.class) || Operators.is(((z4)this.m2620.getGraphicContext()).getStrokeBrush(), ICanvasPattern.class)) {
            return ((z4)this.m2620.getGraphicContext()).getStrokeBrush();
        }
        return null;
    }

    @Override
    public final void setStrokeStyle(Object object) {
        if (Operators.is(object, String.class)) {
            ((z4)this.m2620.getGraphicContext()).setStrokeBrush(new z11(this.getCanvas(), (String)object));
            return;
        }
        if (Operators.is(object, ICanvasGradient.class) || Operators.is(object, ICanvasPattern.class)) {
            ((z4)this.m2620.getGraphicContext()).setStrokeBrush((IBrush)object);
            return;
        }
    }

    @Override
    public final String getTextAlign() {
        switch (((z4)this.m2620.getGraphicContext()).m433()) {
            case 2: {
                return "left";
            }
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
            case 3: {
                return "right";
            }
            case 4: {
                return "center";
            }
        }
        return "start";
    }

    @Override
    public final void setTextAlign(String string) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(string)))) {
            case 16: {
                ((z4)this.m2620.getGraphicContext()).m64(2);
                break;
            }
            case 17: {
                ((z4)this.m2620.getGraphicContext()).m64(0);
                break;
            }
            case 18: {
                ((z4)this.m2620.getGraphicContext()).m64(1);
                break;
            }
            case 19: {
                ((z4)this.m2620.getGraphicContext()).m64(3);
                break;
            }
            case 20: {
                ((z4)this.m2620.getGraphicContext()).m64(4);
            }
        }
    }

    @Override
    public final String getTextBaseline() {
        switch (((z4)this.m2620.getGraphicContext()).m434()) {
            case 3: {
                return "alphabetic";
            }
            case 5: {
                return "bottom";
            }
            case 1: {
                return "hanging";
            }
            case 4: {
                return "ideographic";
            }
            case 2: {
                return "middle";
            }
            case 0: {
                return "top";
            }
        }
        return "alphabetic";
    }

    @Override
    public final void setTextBaseline(String string) {
        switch (gStringSwitchMap.of(StringExtensions.toLower(StringExtensions.trim(string)))) {
            case 21: {
                ((z4)this.m2620.getGraphicContext()).m65(3);
                break;
            }
            case 22: {
                ((z4)this.m2620.getGraphicContext()).m65(5);
                break;
            }
            case 23: {
                ((z4)this.m2620.getGraphicContext()).m65(1);
                break;
            }
            case 24: {
                ((z4)this.m2620.getGraphicContext()).m65(4);
                break;
            }
            case 25: {
                ((z4)this.m2620.getGraphicContext()).m65(2);
                break;
            }
            case 26: {
                ((z4)this.m2620.getGraphicContext()).m65(0);
            }
        }
    }

    public z9(HTMLCanvasElement hTMLCanvasElement) {
        Document document = hTMLCanvasElement.getOwnerDocument();
        this.m2629 = hTMLCanvasElement;
        this.m2630 = new MemoryStream();
        this.m2620 = new z2(document.getContext().getService(com.aspose.html.internal.p15.z5.class), document.getContext().getService(z8.class), this.m2630);
        document.getContext().getService(com.aspose.html.internal.p172.z2.class).m2(document);
        this.m2620.beginDocument(document);
        this.m2620.beginPage(new SizeF(Operators.castToFloat(this.m2629.getWidth(), 12), Operators.castToFloat(hTMLCanvasElement.getHeight(), 12)));
        this.m437();
    }

    @Override
    public final void addHitRegion(Dictionary<String, String> dictionary) {
        throw new NotImplementedException();
    }

    @Override
    public final void arc(double d2, double d3, double d4, double d5, double d6) {
        this.m2620.arc(d2, d3, d4, d5, d6, false);
    }

    @Override
    public final void arc(double d2, double d3, double d4, double d5, double d6, boolean bl2) {
        this.m2620.arc(d2, d3, d4, d5, d6, bl2);
    }

    @Override
    public final void arcTo(double d2, double d3, double d4, double d5, double d6) {
        this.m2620.m1((float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    @Override
    public final void beginPath() {
        this.m2620.beginPath();
    }

    @Override
    public final void bezierCurveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.m2620.cubicBezierTo(new PointF((float)d2, (float)d3), new PointF((float)d4, (float)d5), new PointF((float)d6, (float)d7));
    }

    @Override
    public final void clearHitRegions() {
    }

    @Override
    public final void clearRect(double d2, double d3, double d4, double d5) {
        this.m2620.clearRect(d2, d3, d4, d5);
    }

    @Override
    public final void clip() {
        this.m2620.clip(1);
    }

    @Override
    public final void clip(int n2) {
        this.m2620.clip(this.m66(n2));
    }

    @Override
    public final void clip(Path2D path2D, int n2) {
        this.m2620.m1(path2D.getPath(), this.m66(n2));
    }

    @Override
    public final void closePath() {
        this.m2620.closePath();
    }

    @Override
    public final IImageData createImageData(IImageData iImageData) {
        return new z14(iImageData.getWidth(), iImageData.getHeight(), ArrayBuffer.to_(iImageData.getData().getBuffer()));
    }

    @Override
    public final IImageData createImageData(double d2, double d3) {
        long l2 = Operators.castToUInt64(d2, 14);
        long l3 = Operators.castToUInt64(d3, 14);
        return new z14(l2, l3, new byte[(int)(l2 * l3 * 4L)]);
    }

    @Override
    public final ICanvasGradient createLinearGradient(double d2, double d3, double d4, double d5) {
        return new z3(d2, d3, d4, d5, this.getCanvas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICanvasPattern createPattern(HTMLCanvasElement hTMLCanvasElement, String string) {
        z5 z5100 = new z5(hTMLCanvasElement);
        try {
            z7 z710 = new z7(this.m2620, z5100.m2(new z27<RectangleF>(RectangleF.class)), string);
            return z710;
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICanvasPattern createPattern(HTMLImageElement hTMLImageElement, String string) {
        z5 z5100 = new z5(hTMLImageElement);
        try {
            z7 z710 = new z7(this.m2620, z5100.m2(new z27<RectangleF>(RectangleF.class)), string);
            return z710;
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    @Override
    public final ICanvasGradient createRadialGradient(double d2, double d3, double d4, double d5, double d6, double d7) {
        return new z3(d2, d3, d4, d5, d6, d7, this.getCanvas());
    }

    @Override
    public final void drawFocusIfNeeded(Element element) {
        throw new NotImplementedException();
    }

    private void m1(z5 z5100, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        RectangleF rectangleF = new RectangleF((float)d2, (float)d3, (float)d4, (float)d5);
        if (rectangleF.isEmpty()) {
            return;
        }
        RectangleF rectangleF2 = RectangleF.intersect(rectangleF.Clone(), new RectangleF(0.0f, 0.0f, z5100.getWidth(), z5100.getHeight())).Clone();
        if (rectangleF2.isEmpty()) {
            return;
        }
        RectangleF rectangleF3 = new RectangleF((float)d6, (float)d7, (float)d8 * rectangleF2.getWidth() / rectangleF.getWidth(), (float)d9 * rectangleF2.getHeight() / rectangleF.getHeight());
        if (rectangleF3.isEmpty()) {
            return;
        }
        this.m2620.drawImage(z5100.m2(new z27<RectangleF>(RectangleF.class, rectangleF2.Clone())), 6, rectangleF3.Clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLCanvasElement hTMLCanvasElement, double d2, double d3) {
        z5 z5100 = new z5(hTMLCanvasElement);
        try {
            this.m1(z5100, 0.0, 0.0, z5100.getWidth(), z5100.getHeight(), d2, d3, z5100.getWidth(), z5100.getHeight());
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLCanvasElement hTMLCanvasElement, double d2, double d3, double d4, double d5) {
        z5 z5100 = new z5(hTMLCanvasElement);
        try {
            this.m1(z5100, 0.0, 0.0, z5100.getWidth(), z5100.getHeight(), d2, d3, d4, d5);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLCanvasElement hTMLCanvasElement, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        z5 z5100 = new z5(hTMLCanvasElement);
        try {
            this.m1(z5100, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLImageElement hTMLImageElement, double d2, double d3) {
        z5 z5100 = new z5(hTMLImageElement);
        try {
            this.m1(z5100, 0.0, 0.0, z5100.getWidth(), z5100.getHeight(), d2, d3, z5100.getWidth(), z5100.getHeight());
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLImageElement hTMLImageElement, double d2, double d3, double d4, double d5) {
        z5 z5100 = new z5(hTMLImageElement);
        try {
            this.m1(z5100, 0.0, 0.0, z5100.getWidth(), z5100.getHeight(), d2, d3, d4, d5);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawImage(HTMLImageElement hTMLImageElement, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        z5 z5100 = new z5(hTMLImageElement);
        try {
            this.m1(z5100, d2, d3, d4, d5, d6, d7, d8, d9);
        }
        finally {
            if (z5100 != null) {
                z5100.dispose();
            }
        }
    }

    @Override
    public final void ellipse(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.m2620.m1((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, (float)d8, false);
    }

    @Override
    public final void ellipse(double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl2) {
        this.m2620.m1((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, (float)d8, bl2);
    }

    @Override
    public final void fill() {
        this.fill(0);
    }

    @Override
    public final void fill(int n2) {
        this.m2620.fill(this.m66(n2));
    }

    @Override
    public final void fill(Path2D path2D) {
        this.fill(path2D, 0);
    }

    @Override
    public final void fill(Path2D path2D, int n2) {
        int n3 = this.m66(n2);
        this.m2620.m2(path2D.getPath(), n3);
    }

    public final void m91(String string) {
        switch (gStringSwitchMap.of(string)) {
            case 27: {
                this.fill(1);
                break;
            }
            case 28: {
                this.fill(0);
                break;
            }
            default: {
                z10.m42();
            }
        }
    }

    @Override
    public final void fillRect(double d2, double d3, double d4, double d5) {
        this.m2620.m1((float)d2, (float)d3, (float)d4, (float)d5);
    }

    @Override
    public final void fillText(String string, double d2, double d3) {
        this.m1(string, d2, d3, null);
    }

    @Override
    public final void fillText(String string, double d2, double d3, double d4) {
        this.m1(string, d2, d3, d4);
    }

    public final void m1(String string, double d2, double d3, Double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = new double[]{0.0};
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        boolean bl2 = !this.m1(string, d2, d3, d4, dArray, dArray2, dArray3);
        d5 = dArray[0];
        d6 = dArray2[0];
        d7 = dArray3[0];
        if (bl2) {
            return;
        }
        this.m2620.fillText(string, new PointF((float)d6, (float)d7));
        if (d4 != null && d5 > d4) {
            this.restore();
        }
    }

    private int m66(int n2) {
        return n2 == 0 ? 1 : 0;
    }

    @Override
    public final IImageData getImageData(double d2, double d3, double d4, double d5) {
        return this.m2620.m1(d2, d3, d4, d5);
    }

    @Override
    public final double[] getLineDash() {
        Converter<Float, Double> converter = new Converter<Float, Double>(){

            public Double m1(Float f2) {
                return f2.floatValue();
            }

            @Override
            public /* synthetic */ Object invoke(Object object) {
                return this.m1((Float)object);
            }
        };
        return com.aspose.html.internal.p1.z1.m1(com.aspose.html.internal.p283.z11.m1(Double.class, com.aspose.html.internal.p1.z1.m1(((z4)this.m2620.getGraphicContext()).getLineDashPattern()), converter));
    }

    private void m437() {
        this.setFont("10px sans-serif");
        this.setTextAlign("start");
        this.setTextBaseline("alphabetic");
        this.setShadowColor("transparent");
        this.setStrokeStyle("black");
        this.setFillStyle("black");
        this.setGlobalAlpha(1.0);
        this.setGlobalCompositeOperation("source-over");
        this.setLineWidth(1.0);
        this.setLineCap("butt");
        this.setLineJoin("miter");
        this.setMiterLimit(10.0);
        this.setImageSmoothingEnabled(true);
    }

    @Override
    public final boolean isPointInPath(Path2D path2D, double d2, double d3) {
        return this.isPointInPath(path2D, d2, d3, 0);
    }

    @Override
    public final boolean isPointInPath(Path2D path2D, double d2, double d3, int n2) {
        return this.m2620.m1(path2D.getPath(), d2, d3, this.m66(n2));
    }

    @Override
    public final boolean isPointInPath(double d2, double d3) {
        return this.isPointInPath(d2, d3, 0);
    }

    @Override
    public final boolean isPointInPath(double d2, double d3, int n2) {
        return this.m2620.isPointInPath(d2, d3, this.m66(n2));
    }

    @Override
    public final boolean isPointInStroke(Path2D path2D, double d2, double d3) {
        return this.m2620.m1(path2D.getPath(), d2, d3);
    }

    @Override
    public final boolean isPointInStroke(double d2, double d3) {
        return this.m2620.isPointInStroke(d2, d3);
    }

    @Override
    public final void lineTo(double d2, double d3) {
        this.m2620.lineTo(new PointF((float)d2, (float)d3));
    }

    @Override
    public final ITextMetrics measureText(String string) {
        return new z16(this.m2620.m88(string).getWidth());
    }

    @Override
    public final void moveTo(double d2, double d3) {
        this.m2620.moveTo(new PointF((float)d2, (float)d3));
    }

    private boolean m1(String string, double d2, double d3, Double d4, double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        if (StringExtensions.isNullOrEmpty(string)) {
            return false;
        }
        if (d4 != null && d4 <= 0.0) {
            return false;
        }
        z18 z1810 = ((z6)Element.z1.m15(this.getCanvas())).m476();
        CSSValue cSSValue = z1810.getPropertyCSSValue("direction");
        float f2 = ((CSSPrimitiveValue)z1810.getPropertyCSSValue("letter-spacing")).getFloatValue(9);
        ((z4)this.m2620.getGraphicContext()).m13(f2);
        SizeF sizeF = this.m2620.m88(string).Clone();
        dArray[0] = sizeF.getWidth() + f2 * (float)(string.length() - 1);
        if (d4 != null && dArray[0] > d4) {
            this.save();
            this.transform(d4 / dArray[0], 0.0, 0.0, 1.0, 0.0, 0.0);
            dArray[0] = d4;
        }
        dArray2[0] = d2;
        if (((z4)this.m2620.getGraphicContext()).m433() == 2 || ((z4)this.m2620.getGraphicContext()).m433() == 0 && cSSValue.equals((Object)z1.z1.m3215) || ((z4)this.m2620.getGraphicContext()).m433() == 1 && cSSValue.equals((Object)z1.z1.m3302)) {
            dArray2[0] = d2;
        }
        if (((z4)this.m2620.getGraphicContext()).m433() == 3 || ((z4)this.m2620.getGraphicContext()).m433() == 1 && cSSValue.equals((Object)z1.z1.m3215) || ((z4)this.m2620.getGraphicContext()).m433() == 0 && cSSValue.equals((Object)z1.z1.m3302)) {
            dArray2[0] = d2 - Operators.castToDouble(this.m2629.getWidth(), 12);
        }
        if (((z4)this.m2620.getGraphicContext()).m433() == 4) {
            dArray2[0] = d2 - (double)(Operators.castToFloat(this.m2629.getWidth(), 12) / 2.0f);
        }
        dArray3[0] = d3;
        ITrueTypeFont iTrueTypeFont = ((z4)this.m2620.getGraphicContext()).getFont();
        float f3 = ((z4)this.m2620.getGraphicContext()).getFontSize();
        float f4 = iTrueTypeFont.getAscent(f3);
        float f5 = iTrueTypeFont.getDescent(f3);
        if (((z4)this.m2620.getGraphicContext()).m434() == 0) {
            dArray3[0] = d3 + (double)f4 + (double)f5;
        }
        if (((z4)this.m2620.getGraphicContext()).m434() == 1) {
            dArray3[0] = d3 + msMath.round((f4 + f5) * 0.8f);
        }
        if (((z4)this.m2620.getGraphicContext()).m434() == 2) {
            dArray3[0] = d3 + (double)((f4 + f5) / 2.0f);
        }
        if (((z4)this.m2620.getGraphicContext()).m434() == 3) {
            dArray3[0] = d3 + (double)f5;
        }
        if (((z4)this.m2620.getGraphicContext()).m434() == 4) {
            dArray3[0] = d3 + (double)f5;
        }
        if (((z4)this.m2620.getGraphicContext()).m434() == 5) {
            dArray3[0] = d3;
        }
        dArray3[0] = dArray3[0] - (double)f5;
        return true;
    }

    @Override
    public final void putImageData(IImageData iImageData, double d2, double d3) {
        this.m2620.m1(iImageData, new Point(Operators.castToInt32(d2, 14), Operators.castToInt32(d3, 14)), new z28(), 1.0f, false);
    }

    @Override
    public final void putImageData(IImageData iImageData, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d6 < 0.0) {
            d4 += d6;
            d6 = msMath.abs(d6);
        }
        if (d7 < 0.0) {
            d5 += d7;
            d7 = msMath.abs(d7);
        }
        if (d4 < 0.0) {
            d6 += d4;
            d4 = 0.0;
        }
        if (d5 < 0.0) {
            d7 += d5;
            d5 = 0.0;
        }
        if (d4 + d6 > (double)iImageData.getWidth()) {
            d6 = Operators.castToDouble(iImageData.getWidth(), 12) - d4;
        }
        if (d5 + d7 > (double)iImageData.getHeight()) {
            d7 = Operators.castToDouble(iImageData.getHeight(), 12) - d5;
        }
        if (d6 <= 0.0 || d7 <= 0.0) {
            return;
        }
        int n2 = 4;
        z14 z1410 = new z14(Operators.castToUInt64(d6, 14), Operators.castToUInt64(d7, 14), new byte[Operators.castToInt32(d6 * (double)n2 * d7, 14)]);
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        int n3 = (int)iImageData.getWidth() * n2;
        int n4 = (int)z1410.getWidth() * n2;
        int n5 = Operators.castToInt32(d4, 14);
        int n6 = 0;
        while ((double)n5 < d8) {
            int n7 = Operators.castToInt32(d5, 14);
            int n8 = 0;
            while ((double)n7 < d9) {
                z1410.getData().set_Item(n6 * n2 + n8 * n4, iImageData.getData().get_Item(n5 * n2 + n7 * n3));
                z1410.getData().set_Item(n6 * n2 + n8 * n4 + 1, iImageData.getData().get_Item(n5 * n2 + n7 * n3 + 1));
                z1410.getData().set_Item(n6 * n2 + n8 * n4 + 2, iImageData.getData().get_Item(n5 * n2 + n7 * n3 + 2));
                z1410.getData().set_Item(n6 * n2 + n8 * n4 + 3, iImageData.getData().get_Item(n5 * n2 + n7 * n3 + 3));
                ++n7;
                ++n8;
            }
            ++n5;
            ++n6;
        }
        this.putImageData(z1410, d2 + d4, d3 + d5);
    }

    @Override
    public final void quadraticCurveTo(double d2, double d3, double d4, double d5) {
        PointF pointF = new PointF((float)d2, (float)d3);
        PointF pointF2 = new PointF((float)d4, (float)d5);
        PointF[] pointFArray = com.aspose.html.internal.p29.z3.m1(this.m2620.getLastPoint().Clone(), pointF.Clone(), pointF2.Clone());
        this.m2620.cubicBezierTo(pointFArray[0].Clone(), pointFArray[1].Clone(), pointF2.Clone());
    }

    @Override
    public final void rect(double d2, double d3, double d4, double d5) {
        this.m2620.addRect(new RectangleF((float)d2, (float)d3, (float)d4, (float)d5));
    }

    @Override
    public final void removeHitRegion(String string) {
    }

    @Override
    public final void resetTransform() {
        this.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    @Override
    public final void restore() {
        this.m2620.restoreGraphicContext();
    }

    @Override
    public final void rotate(double d2) {
        try {
            Matrix matrix = new Matrix();
            matrix.rotate((float)(d2 * 57.29577951308232));
            ((z4)this.m2620.getGraphicContext()).transform(matrix);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public final void save() {
        this.m2620.saveGraphicContext();
    }

    @Override
    public final void scale(double d2, double d3) {
        try {
            if (DoubleExtensions.equals(d2, 0.0)) {
                d2 = 1.0E-9f;
            }
            if (DoubleExtensions.equals(d3, 0.0)) {
                d3 = 1.0E-9f;
            }
            ((z4)this.m2620.getGraphicContext()).transform(new Matrix((float)d2, 0.0f, 0.0f, (float)d3, 0.0f, 0.0f));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public final void setLineDash(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            ((z4)this.m2620.getGraphicContext()).setLineDashPattern(null);
        } else {
            Converter<Double, Float> converter = new Converter<Double, Float>(){

                public Float m1(Double d2) {
                    return Float.valueOf(d2.floatValue());
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m1((Double)object);
                }
            };
            ((z4)this.m2620.getGraphicContext()).setLineDashPattern(com.aspose.html.internal.p1.z1.m1(com.aspose.html.internal.p283.z11.m1(Float.class, com.aspose.html.internal.p1.z1.m1(dArray), converter)));
        }
    }

    @Override
    public final void setTransform(double d2, double d3, double d4, double d5, double d6, double d7) {
        try {
            ((z4)this.m2620.getGraphicContext()).setTransformationMatrix(new Matrix((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public final void stroke() {
        this.m2620.stroke();
    }

    @Override
    public final void stroke(Path2D path2D) {
        this.m2620.m1(path2D.getPath());
    }

    @Override
    public final void strokeRect(double d2, double d3, double d4, double d5) {
        this.m2620.m3((float)d2, (float)d3, (float)d4, (float)d5);
    }

    @Override
    public final void strokeText(String string, double d2, double d3) {
        this.strokeText(string, d2, d3, (Double)Operators.defaultValue(Double.class));
    }

    @Override
    public final void strokeText(String string, double d2, double d3, Double d4) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = new double[]{0.0};
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        boolean bl2 = !this.m1(string, d2, d3, d4, dArray, dArray2, dArray3);
        d5 = dArray[0];
        d6 = dArray2[0];
        d7 = dArray3[0];
        if (bl2) {
            return;
        }
        this.m2620.strokeText(string, new PointF((float)d6, (float)d7));
        if (d4 != null && d5 > d4) {
            this.restore();
        }
    }

    @Override
    public final void transform(double d2, double d3, double d4, double d5, double d6, double d7) {
        try {
            ((z4)this.m2620.getGraphicContext()).transform(new Matrix((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    @Override
    public final void translate(double d2, double d3) {
        try {
            ((z4)this.m2620.getGraphicContext()).transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, (float)d2, (float)d3));
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }
}

