/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.collections;

import com.aspose.html.collections.NamedNodeMap;
import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Element;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p28.z1;
import com.aspose.html.internal.p283.z27;
import com.aspose.html.z10;

public class DOMTokenList
extends DOMObject
implements IGenericEnumerable<String> {
    private final String associatedAttribute;
    private final Element associatedElement;
    private final List<String> tokenSet = new List();

    public final long getLength() {
        return Operators.castToUInt64(this.tokenSet.size(), 9);
    }

    public final String getValue() {
        return NamedNodeMap.getAttributeValue(this.associatedElement, this.associatedAttribute);
    }

    public final void setValue(String string) {
        NamedNodeMap.setAttributeValue(this.associatedElement, this.associatedAttribute, string);
    }

    public final String get_Item(long l2) {
        int n2 = (int)l2;
        return n2 >= this.tokenSet.size() ? null : this.tokenSet.get_Item(n2);
    }

    public DOMTokenList(Element element, String string) {
        this.associatedElement = element;
        this.associatedAttribute = string;
        String string2 = NamedNodeMap.getAttributeValue(element, string);
        this.update(string, string2, null);
    }

    public final void add(String ... stringArray) {
        if (stringArray == null) {
            z10.m42();
        }
        for (String string : stringArray) {
            if (StringExtensions.isNullOrEmpty(string)) {
                z10.m42();
            }
            this.checkNoWhitespaces(string);
        }
        for (String string : stringArray) {
            this.tokenSet.addItem(string);
        }
        this.updateSteps();
    }

    private void checkNoWhitespaces(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!z1.isWhitespace(c2)) continue;
            z10.m33();
        }
    }

    public final boolean contains(String string) {
        return this.tokenSet.containsItem(string);
    }

    @Override
    public final IGenericEnumerator<String> iterator() {
        return this.tokenSet.iterator();
    }

    public final void remove(String ... stringArray) {
        if (stringArray == null) {
            z10.m42();
        }
        for (String string : stringArray) {
            if (StringExtensions.isNullOrEmpty(string)) {
                z10.m42();
            }
            this.checkNoWhitespaces(string);
        }
        for (String string : stringArray) {
            if (!this.tokenSet.containsItem(string)) continue;
            this.tokenSet.removeItem(string);
        }
        this.updateSteps();
    }

    public final boolean replace(String string, String string2) {
        if (StringExtensions.isNullOrEmpty(string) || StringExtensions.isNullOrEmpty(string2)) {
            z10.m42();
        }
        this.checkNoWhitespaces(string);
        this.checkNoWhitespaces(string2);
        if (!this.tokenSet.containsItem(string)) {
            return false;
        }
        int n2 = this.tokenSet.indexOf(string);
        this.tokenSet.set_Item(n2, string2);
        this.updateSteps();
        return true;
    }

    public final boolean supports(String string) {
        return this.validationSteps(string);
    }

    public final boolean toggle(String string) {
        return this.toggle(string, new z27<Boolean>(Boolean.class));
    }

    public final boolean toggle(String string, z27<Boolean> z2710) {
        if (StringExtensions.isNullOrEmpty(string)) {
            z10.m42();
        }
        this.checkNoWhitespaces(string);
        if (this.tokenSet.containsItem(string)) {
            if (!z2710.m2868().booleanValue() || !z2710.getValue().booleanValue()) {
                this.tokenSet.removeItem(string);
                this.updateSteps();
                return false;
            }
            return true;
        }
        if (!z2710.m2868().booleanValue() || z2710.getValue().booleanValue()) {
            this.tokenSet.addItem(string);
            this.updateSteps();
            return true;
        }
        return false;
    }

    public final void update(String string, String string2, String string3) {
        if (!StringExtensions.equals(string, this.associatedAttribute) || string3 != null) {
            return;
        }
        this.tokenSet.clear();
        if (string2 != null) {
            this.tokenSet.addRange(Array.toGenericList(StringExtensions.split(string2, new char[]{' '}, (short)1)));
        }
    }

    private void updateSteps() {
        if (!this.associatedElement.hasAttribute(this.associatedAttribute) && this.tokenSet.size() == 0) {
            return;
        }
        NamedNodeMap.setAttributeValue(this.associatedElement, this.associatedAttribute, StringExtensions.join(" ", this.tokenSet.toArray((String[])new String[0])));
    }

    private boolean validationSteps(String string) {
        return z10.m3(Boolean.class);
    }
}

