/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.dom.Document;
import com.aspose.html.dom.css.CSSPrimitiveValue;
import com.aspose.html.dom.css.CSSValue;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.svg.SVGDocument;
import com.aspose.html.dom.svg.SVGSVGElement;
import com.aspose.html.drawing.LengthOrAuto;
import com.aspose.html.drawing.Page;
import com.aspose.html.drawing.Unit;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.p106.z7;
import com.aspose.html.internal.p146.z6;
import com.aspose.html.internal.p210.z4;
import com.aspose.html.internal.p225.z1;
import com.aspose.html.internal.p331.z31;
import com.aspose.html.internal.p4.z23;
import com.aspose.html.internal.p85.z9;
import com.aspose.html.internal.p88.z2;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.Renderer;
import com.aspose.html.rendering.RenderingOptions;
import com.aspose.html.z3;
import com.aspose.time.TimeSpan;

public class SvgRenderer
extends Renderer<SVGDocument> {
    @Override
    public void render(IDevice device, TimeSpan timeout, SVGDocument[] documents) {
        this.render(device, true, timeout.Clone(), documents);
    }

    @Override
    public void render(IDevice device, TimeSpan timeout, SVGDocument document) {
        SVGDocument[] sVGDocumentArray = new SVGDocument[]{document};
        this.render(device, true, timeout.Clone(), sVGDocumentArray);
    }

    private void render(IDevice device, boolean needFlush, TimeSpan timeout, SVGDocument[] documents) {
        com.aspose.html.internal.p161.z2[] z2Array = new com.aspose.html.internal.p161.z2[documents.length];
        for (int i2 = 0; i2 < documents.length; ++i2) {
            z2Array[i2] = new com.aspose.html.internal.p161.z6(documents[i2]);
        }
        this.render(device, needFlush, timeout.Clone(), z2Array);
    }

    @Override
    public void render(IDevice device, SVGSVGElement ... elements) {
        this.render(device, true, elements);
    }

    public void render(IDevice device, boolean needFlush, SVGSVGElement ... elements) {
        com.aspose.html.internal.p161.z2[] z2Array = new com.aspose.html.internal.p161.z2[elements.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            z2Array[i2] = new com.aspose.html.internal.p161.z6(elements[i2]);
        }
        this.render(device, needFlush, TimeSpan.Zero.Clone(), z2Array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void render(IDevice device, boolean needFlush, TimeSpan timeout, com.aspose.html.internal.p161.z2 ... sources) {
        if (sources.length == 0) {
            return;
        }
        IDisposable iDisposable = (IDisposable)((z31)z23.get("Func3<IDevice, RendererBase, IDisposable>")).m1(device, this);
        try {
            this.validatePageSetup(device.getOptions().getPageSetup());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
        try {
            com.aspose.html.collections.z3 z3100 = new com.aspose.html.collections.z3(this, sources[0].getDocument(), Array.toGenericList(sources), device);
            try {
                while (z3100.hasNext()) {
                    SVGSVGElement sVGSVGElement;
                    if (z3100.m149() == null || (sVGSVGElement = ((z4)z3100.m149()).getRootElement()) == null) continue;
                    Document document = sVGSVGElement.getOwnerDocument();
                    z1 z1100 = document.getContext().getService(z1.class);
                    try {
                        RenderingOptions renderingOptions = z6.m2(device.getOptions(), document);
                        com.aspose.html.internal.p278.z1 z1101 = new com.aspose.html.internal.p278.z1(document.getBrowsingContext(), renderingOptions);
                        try {
                            Object object;
                            Object object2;
                            document.getBrowsingContext().m12().m1(timeout.Clone());
                            document.getContext().getService(com.aspose.html.services.z3.class).m34(document);
                            if (renderingOptions.getPageSetup().getAdjustToWidestPage() && (((CSSPrimitiveValue)(object2 = (CSSPrimitiveValue)(object = ((IViewCSS)((Object)document.getContext().getWindow())).getComputedStyle(sVGSVGElement)).getPropertyCSSValue("width"))).getPrimitiveType() & 0xFFFF) != 2) {
                                renderingOptions = this.adjustPageSize(z7.m1((CSSValue)object2, null, null).getValue(UnitType.PT), renderingOptions.deepClone());
                            }
                            object = com.aspose.html.internal.p85.z4.m1(renderingOptions, document);
                            try {
                                object2 = new com.aspose.html.internal.p226.z1((z3)document.getContext());
                                document.getContext().addService(object2, z1.class);
                                object2.m1(document);
                                document.getContext().addService(new com.aspose.html.internal.p105.z2(), com.aspose.html.internal.p104.z1.class);
                                com.aspose.html.internal.p85.z7 z713 = new com.aspose.html.internal.p85.z7((com.aspose.html.internal.p85.z4)object);
                                z2 z2100 = z713.m11(sVGSVGElement);
                                z9 z910 = z9.m1(device, document);
                                try {
                                    z2100.m2(z910);
                                }
                                finally {
                                    if (z910 == null) continue;
                                    z910.dispose();
                                }
                            }
                            finally {
                                if (object == null) continue;
                                object.dispose();
                            }
                        }
                        finally {
                            if (z1101 == null) continue;
                            z1101.dispose();
                        }
                    }
                    finally {
                        document.getBrowsingContext().m12().m1807();
                        document.getContext().getService(com.aspose.html.services.z3.class).m34(document);
                        document.getContext().addService(z1100, z1.class);
                        document.getContext().addService(null, com.aspose.html.internal.p104.z1.class);
                    }
                }
                return;
            }
            finally {
                if (z3100 != null) {
                    z3100.dispose();
                }
            }
        }
        finally {
            if (needFlush) {
                device.flush();
            }
        }
    }

    private RenderingOptions adjustPageSize(double svgWidth, RenderingOptions renderingOptions) {
        boolean bl2 = false;
        if (renderingOptions.getPageSetup().getFirstPage() != null) {
            bl2 |= this.needsResize(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        if (renderingOptions.getPageSetup().getAnyPage() == null) {
            bl2 |= this.needsResize(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
            if (bl2 |= this.needsResize(renderingOptions.getPageSetup().getRightPage(), svgWidth)) {
                this.updatePageWidth(renderingOptions.getPageSetup().getLeftPage(), svgWidth);
                this.updatePageWidth(renderingOptions.getPageSetup().getRightPage(), svgWidth);
            }
        } else if (bl2 |= this.needsResize(renderingOptions.getPageSetup().getAnyPage(), svgWidth)) {
            this.updatePageWidth(renderingOptions.getPageSetup().getAnyPage(), svgWidth);
        }
        if (bl2 && renderingOptions.getPageSetup().getFirstPage() != null) {
            this.updatePageWidth(renderingOptions.getPageSetup().getFirstPage(), svgWidth);
        }
        return renderingOptions;
    }

    private void updatePageWidth(Page page, double widestBlock) {
        page.getSize().setWidth(Unit.fromPoints(widestBlock + this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight())));
    }

    private boolean needsResize(Page page, double widestBlock) {
        double d2 = this.getMarginWidth(page.getMargin().getLeft()) + this.getMarginWidth(page.getMargin().getRight());
        return widestBlock + d2 > page.getSize().getWidth().getValue(UnitType.PT);
    }

    private double getMarginWidth(LengthOrAuto lengthOrAuto) {
        return lengthOrAuto.isAuto() ? 0.0 : lengthOrAuto.getLength().getValue(UnitType.PT);
    }
}

