/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.messagehandlers;

import com.aspose.html.dom.z2;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Net.CookieContainer;
import com.aspose.html.internal.ms.System.Net.CredentialCache;
import com.aspose.html.internal.ms.System.Net.HttpWebRequest;
import com.aspose.html.internal.ms.System.Net.HttpWebResponse;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.Net.WebHeaderCollection;
import com.aspose.html.internal.ms.System.Net.WebRequest;
import com.aspose.html.internal.ms.System.Net.WebResponse;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p259.z4;
import com.aspose.html.internal.p4.z31;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.INetworkOperationContext;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.net.StreamContent;
import com.aspose.html.net.StringContent;
import com.aspose.html.net.messagefilters.ProtocolMessageFilter;

public class HttpProtocolMessageHandler
extends MessageHandler {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("Accept", "User-Agent", "Content-Type", "Expect");

    public HttpProtocolMessageHandler() {
        this.getFilters().addItem(new ProtocolMessageFilter(z4.m1(z2.z10.m4199), z4.m1(z2.z10.m4200)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyHeadersToResponse(WebResponse response, ResponseMessage responseMessage) {
        IEnumerator iEnumerator = response.getHeaders().getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (WebHeaderCollection.isRestricted(string, true)) continue;
                responseMessage.getHeaders().add(string, response.getHeaders().get(string));
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyHeadersToRequest(WebHeaderCollection requestHeaders, WebRequest request) {
        IEnumerator iEnumerator = requestHeaders.getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (!WebHeaderCollection.isRestricted(string)) {
                    request.getHeaders().set(string, requestHeaders.get_Item(string));
                    continue;
                }
                HttpWebRequest httpWebRequest = Operators.as(request, HttpWebRequest.class);
                if (httpWebRequest == null) continue;
                switch (gStringSwitchMap.of(string)) {
                    case 0: {
                        httpWebRequest.setAccept(requestHeaders.get_Item(string));
                        break;
                    }
                    case 1: {
                        httpWebRequest.setUserAgent(requestHeaders.get_Item(string));
                        break;
                    }
                    case 2: {
                        httpWebRequest.setContentType(requestHeaders.get_Item(string));
                        break;
                    }
                    case 3: {
                        httpWebRequest.setExpect(requestHeaders.get_Item(string));
                    }
                }
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(INetworkOperationContext context) {
        Object object;
        IDisposable iDisposable;
        HttpWebRequest httpWebRequest = (HttpWebRequest)WebRequest.create(context.getRequest().getRequestUri().getHref());
        httpWebRequest.setMethod(context.getRequest().getMethod() != null ? context.getRequest().getMethod().getName() : HttpMethod.getGet().getName());
        ICredentials iCredentials = context.getRequest().getCredentials();
        if (iCredentials == null) {
            iCredentials = CredentialCache.getDefaultCredentials();
        }
        httpWebRequest.setCredentials(iCredentials);
        httpWebRequest.setPreAuthenticate(context.getRequest().getPreAuthenticate());
        httpWebRequest.setTimeout(Operators.castToInt32(context.getRequest().getTimeout().getTotalMilliseconds(), 14));
        CookieContainer cookieContainer = context.getRequest().getCookieContainer();
        if (cookieContainer == null) {
            cookieContainer = new CookieContainer();
        }
        httpWebRequest.setCookieContainer(cookieContainer);
        HttpProtocolMessageHandler.copyHeadersToRequest(context.getRequest().getHeaders(), httpWebRequest);
        httpWebRequest.setAccept("*/*");
        httpWebRequest.setUserAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35 Safari/537.36");
        if ((HttpMethod.getPost().equals(context.getRequest().getMethod()) || HttpMethod.getPut().equals(context.getRequest().getMethod())) && context.getRequest().getContent() != null) {
            HttpProtocolMessageHandler.copyHeadersToRequest(context.getRequest().getContent().getHeaders(), httpWebRequest);
            iDisposable = httpWebRequest.getRequestStream();
            object = context.getRequest().getContent().readAsByteArray();
            ((Stream)iDisposable).write((byte[])object, 0, ((Object)object).length);
            ((Stream)iDisposable).close();
        }
        try {
            iDisposable = (HttpWebResponse)httpWebRequest.getResponse();
            try {
                object = ((HttpWebResponse)iDisposable).getResponseStream();
                try {
                    MemoryStream memoryStream = new MemoryStream();
                    z31.copyStream((Stream)object, memoryStream);
                    memoryStream.flush();
                    memoryStream.seek(0L, 0);
                    context.setResponse(new ResponseMessage(((HttpWebResponse)iDisposable).getStatusCode()));
                    context.getResponse().setRequest(context.getRequest());
                    context.getResponse().setContent(new StreamContent(memoryStream));
                    context.getResponse().setCookies(((HttpWebResponse)iDisposable).getCookies());
                    HttpProtocolMessageHandler.copyHeadersToResponse((WebResponse)iDisposable, context.getResponse());
                }
                finally {
                    if (object != null) {
                        object.dispose();
                    }
                }
            }
            finally {
                if (iDisposable != null) {
                    iDisposable.dispose();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            context.setResponse(new ResponseMessage(400));
            context.getResponse().setContent(new StringContent(runtimeException.getMessage()));
        }
        this.next(context);
    }
}

