/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.net.Content;
import com.aspose.html.net.MultipartContent;
import com.aspose.html.net.headers.ContentDispositionHeaderValue;

public class MultipartFormDataContent
extends MultipartContent {
    private static final String FormData = "form-data";

    public MultipartFormDataContent() {
        super(FormData);
    }

    public MultipartFormDataContent(String boundary) {
        super(FormData, boundary);
    }

    @Override
    public void add(Content content) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        if (content.getHeaders().get_Item("Content-Disposition") == null) {
            content.getHeaders().set_Item("Content-Disposition", new ContentDispositionHeaderValue(FormData).toString());
        }
        super.add(content);
    }

    public void add(Content content, String name) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        if (StringExtensions.isNullOrEmpty(name)) {
            throw new ArgumentException("Name is empty argument");
        }
        this.addInternal(content, name, null);
    }

    public void add(Content content, String name, String fileName) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        if (StringExtensions.isNullOrEmpty(name)) {
            throw new ArgumentException("Name is empty");
        }
        if (StringExtensions.isNullOrEmpty(fileName)) {
            throw new ArgumentException("File name is empty");
        }
        this.addInternal(content, name, fileName);
    }

    private void addInternal(Content content, String name, String fileName) {
        if (content.getHeaders().get_Item("Content-Disposition") == null) {
            ContentDispositionHeaderValue contentDispositionHeaderValue = new ContentDispositionHeaderValue(FormData);
            if (!StringExtensions.isNullOrEmpty(name) && !StringExtensions.startsWith(name, "\"", (short)4)) {
                name = StringExtensions.concat("\"", name, "\"");
            }
            contentDispositionHeaderValue.setName(name);
            if (!StringExtensions.isNullOrEmpty(fileName) && !StringExtensions.startsWith(fileName, "\"", (short)4)) {
                fileName = StringExtensions.concat("\"", fileName, "\"");
            }
            contentDispositionHeaderValue.setFileName(fileName);
            content.getHeaders().set_Item("Content-Disposition", contentDispositionHeaderValue.toString());
        }
        super.add(content);
    }
}

