/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.net.Content;
import com.aspose.html.net.headers.NameValueHeaderValue;

public class MultipartContent
extends Content
implements IGenericEnumerable<Content> {
    private static final String CrLf = "\r\n";
    private final List<Content> _nestedContent;
    private final String _boundary;

    public MultipartContent() {
        this("mixed", MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String subtype) {
        this(subtype, MultipartContent.getDefaultBoundary());
    }

    public MultipartContent(String subtype, String boundary) {
        if (StringExtensions.isNullOrEmpty(subtype)) {
            throw new ArgumentException("The argument cannot be null or empty string.", subtype);
        }
        MultipartContent.validateBoundary(boundary);
        this._boundary = boundary;
        String string = boundary;
        if (!StringExtensions.startsWith(string, "\"", (short)4)) {
            string = StringExtensions.concat("\"", string, "\"");
        }
        this.getHeaders().setByHttpRequestHeader(12, StringExtensions.concat("multipart/", subtype));
        this.getHeaders().setByHttpRequestHeader(12, StringExtensions.concat(this.getHeaders().getByHttpRequestHeader(12), ";") + new NameValueHeaderValue("boundary", string));
        this._nestedContent = new List();
    }

    private static void validateBoundary(String boundary) {
        if (StringExtensions.isNullOrEmpty(boundary)) {
            throw new ArgumentException("The argument cannot be null or empty string.", "boundary");
        }
        if (boundary.length() > 70) {
            throw new ArgumentOutOfRangeException("boundary", (Object)boundary, "Http content field too long");
        }
        if (StringExtensions.endsWith(boundary, " ", (short)4)) {
            throw new ArgumentException(StringExtensions.format("Invalid value for {0}.", boundary), "boundary");
        }
        String string = "'()+_,-./:=? ";
        for (int i2 = 0; i2 < boundary.length(); ++i2) {
            char c2 = boundary.charAt(i2);
            if ('0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || StringExtensions.indexOf("'()+_,-./:=? ", c2) >= 0) continue;
            throw new ArgumentException(StringExtensions.format(CultureInfo.getInvariantCulture(), "Invalid value for {0}", boundary), "boundary");
        }
    }

    private static String getDefaultBoundary() {
        return Guid.newGuid().toString();
    }

    private static void encodeStringToStream(Stream stream, String input) {
        byte[] byArray = DEFAULT_HTTP_ENCODING.getBytes(input);
        stream.write(byArray, 0, byArray.length);
    }

    public void add(Content content) {
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        this._nestedContent.addItem(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean disposing) {
        if (disposing) {
            IGenericEnumerator iGenericEnumerator = this._nestedContent.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    Content content = (Content)iGenericEnumerator.next();
                    content.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this._nestedContent.clear();
        }
        super.dispose(disposing);
    }

    @Override
    public IGenericEnumerator<Content> iterator() {
        return this._nestedContent.iterator();
    }

    public IEnumerator iterator_Rename_Namesake() {
        return this._nestedContent.iterator();
    }

    @Override
    protected void serializeToStream(Stream stream) {
        MultipartContent.encodeStringToStream(stream, StringExtensions.concat("--", this._boundary, CrLf));
        for (int i2 = 0; i2 < this._nestedContent.size(); ++i2) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            Content content = this._nestedContent.get_Item(i2);
            MultipartContent.encodeStringToStream(stream, this.serializeHeadersToString(msStringBuilder2, i2, content));
            byte[] byArray = content.readAsByteArray();
            stream.write(byArray, 0, byArray.length);
        }
        MultipartContent.encodeStringToStream(stream, StringExtensions.concat(CrLf, "--", this._boundary, "--", CrLf));
    }

    private String serializeHeadersToString(msStringBuilder scratch, int contentIndex, Content content) {
        if (contentIndex != 0) {
            scratch.append(StringExtensions.concat(CrLf, "--"));
            scratch.append(this._boundary);
            scratch.append(CrLf);
        }
        for (String string : content.getHeaders()) {
            scratch.append(string);
            scratch.append(": ");
            scratch.append(content.getHeaders().get_Item(string));
            scratch.append(CrLf);
        }
        scratch.append(CrLf);
        return scratch.toString();
    }
}

