/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.helpers.info.formatters;

import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.helpers.info.formatters.IMembersFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;

public class TextMembersFormatter
implements IMembersFormatter {
    private boolean a = false;

    public boolean isWriteFullName() {
        return this.a;
    }

    public void setWriteFullName(boolean writeFullName) {
        this.a = writeFullName;
    }

    @Override
    public String formatClass(Class clz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.formatClassName(clz.getName()));
        stringBuilder.append(this.a(clz.getTypeParameters()));
        return stringBuilder.toString();
    }

    private String a(TypeVariable[] typeVariableArray) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TypeVariable typeVariable : typeVariableArray) {
            arrayList.add(this.formatParam(typeVariable));
        }
        if (arrayList.size() > 0) {
            stringBuilder.append("<");
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            stringBuilder.append(StringExtensions.join(this.formatSymbol(",") + " ", (String[])objectArray));
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    @Override
    public String formatMethod(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        Type[] typeArray = new Type[]{method.getGenericReturnType()};
        stringBuilder.append(this.formatParams(typeArray));
        stringBuilder.append(" ");
        stringBuilder.append(this.formatName(method.getName(), MemberType.Method));
        stringBuilder.append(this.formatSymbol("("));
        stringBuilder.append(this.formatParams(method.getGenericParameterTypes()));
        stringBuilder.append(this.formatSymbol(")"));
        return stringBuilder.toString();
    }

    @Override
    public String formatCtor(Constructor constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.formatName("ctor", MemberType.Ctor));
        stringBuilder.append(this.formatSymbol("("));
        stringBuilder.append(this.formatParams(constructor.getGenericParameterTypes()));
        stringBuilder.append(this.formatSymbol(")"));
        return stringBuilder.toString();
    }

    @Override
    public String formatField(Field field) {
        StringBuilder stringBuilder = new StringBuilder();
        Type[] typeArray = new Type[]{field.getGenericType()};
        stringBuilder.append(this.formatParams(typeArray));
        stringBuilder.append(" ");
        stringBuilder.append(this.formatName(field.getName(), MemberType.Field));
        return stringBuilder.toString();
    }

    @Override
    public String formatParams(Type[] parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Type type : parameters) {
            arrayList.add(this.formatParam(type));
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        stringBuilder.append(StringExtensions.join(this.formatSymbol(",") + " ", (String[])objectArray));
        return stringBuilder.toString();
    }

    @Override
    public String formatParam(Type type) {
        if (type instanceof ParameterizedType) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            stringBuilder.append(this.formatType(this.formatParam(parameterizedType.getRawType())));
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            for (Type type2 : typeArray) {
                arrayList.add(this.formatParam(type2));
            }
            stringBuilder.append("<");
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            stringBuilder.append(StringExtensions.join(this.formatSymbol(",") + " ", (String[])objectArray));
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
        if (type instanceof TypeVariable) {
            return this.formatType(((TypeVariable)type).getName());
        }
        if (type instanceof GenericArrayType) {
            return this.formatType(((GenericArrayType)type).toString());
        }
        if (type instanceof WildcardType) {
            return this.formatType(((WildcardType)type).toString());
        }
        if (type instanceof Class) {
            return this.formatType(((Class)type).getName());
        }
        throw new NotImplementedException();
    }

    public String formatClassName(String className) {
        return className;
    }

    public String formatType(String typeName) {
        return typeName;
    }

    public String formatName(String name, MemberType memberType) {
        return name;
    }

    public String formatSymbol(String symbol) {
        return symbol;
    }

    public static enum MemberType {
        Ctor,
        Field,
        Method;

    }
}

