/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.SafeBag;
import com.aspose.html.internal.ms.core.bc.cms.CMSEncryptedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptorProvider;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12SafeBag;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(ContentInfo info) {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(info.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(ContentInfo info, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData cMSEncryptedData = new CMSEncryptedData(com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfo.getInstance(info));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(cMSEncryptedData.getContent(inputDecryptorProvider));
            }
            catch (CMSException cMSException) {
                throw new PKCSException("unable to extract data: " + cMSException.getMessage(), cMSException);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] pKCS12SafeBagArray = new PKCS12SafeBag[this.safeBagSeq.size()];
        for (int i2 = 0; i2 != this.safeBagSeq.size(); ++i2) {
            pKCS12SafeBagArray[i2] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i2)));
        }
        return pKCS12SafeBagArray;
    }
}

