/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.openssl.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateConverter;
import com.aspose.html.internal.ms.core.bc.openssl.PEMKeyPair;
import com.aspose.html.internal.ms.core.bc.openssl.PEMParser;
import com.aspose.html.internal.ms.core.bc.openssl.jcajce.JcaPEMKeyConverter;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.JcaPKIXIdentity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class JcaPKIXIdentityBuilder {
    private JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter();
    private JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();

    public JcaPKIXIdentityBuilder setProvider(Provider provider) {
        this.keyConverter = this.keyConverter.setProvider(provider);
        this.certConverter = this.certConverter.setProvider(provider);
        return this;
    }

    public JcaPKIXIdentityBuilder setProvider(String providerName) {
        this.keyConverter = this.keyConverter.setProvider(providerName);
        this.certConverter = this.certConverter.setProvider(providerName);
        return this;
    }

    public JcaPKIXIdentity build(File keyFile, File certificateFile) throws IOException, CertificateException {
        this.checkFile(keyFile);
        this.checkFile(certificateFile);
        FileInputStream fileInputStream = new FileInputStream(keyFile);
        FileInputStream fileInputStream2 = new FileInputStream(certificateFile);
        JcaPKIXIdentity jcaPKIXIdentity = this.build(fileInputStream, fileInputStream2);
        fileInputStream.close();
        fileInputStream2.close();
        return jcaPKIXIdentity;
    }

    public JcaPKIXIdentity build(InputStream keyStream, InputStream certificateStream) throws IOException, CertificateException {
        Object object;
        PrivateKey privateKey;
        Object object2;
        PEMParser pEMParser = new PEMParser(new InputStreamReader(keyStream));
        Object object3 = pEMParser.readObject();
        if (object3 instanceof PEMKeyPair) {
            object2 = (PEMKeyPair)object3;
            privateKey = this.keyConverter.getPrivateKey(((PEMKeyPair)object2).getPrivateKeyInfo());
        } else if (object3 instanceof PrivateKeyInfo) {
            privateKey = this.keyConverter.getPrivateKey((PrivateKeyInfo)object3);
        } else {
            throw new IOException("unrecognised private key file");
        }
        object2 = new PEMParser(new InputStreamReader(certificateStream));
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        while ((object = ((PEMParser)object2).readObject()) != null) {
            arrayList.add(this.certConverter.getCertificate((X509CertificateHolder)object));
        }
        return new JcaPKIXIdentity(privateKey, arrayList.toArray(new X509Certificate[arrayList.size()]));
    }

    private void checkFile(File file) throws IOException {
        if (file.canRead()) {
            if (file.exists()) {
                throw new IOException("Unable to open file " + file.getPath() + " for reading.");
            }
            throw new FileNotFoundException("Unable to open " + file.getPath() + ": it does not exist.");
        }
    }
}

