/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mozilla.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.mozilla.SignedPublicKeyAndChallenge;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class JcaSignedPublicKeyAndChallenge
extends SignedPublicKeyAndChallenge {
    JcaJceHelper helper = new DefaultJcaJceHelper();

    private JcaSignedPublicKeyAndChallenge(com.aspose.html.internal.ms.core.bc.asn1.mozilla.SignedPublicKeyAndChallenge struct, JcaJceHelper helper) {
        super(struct);
        this.helper = helper;
    }

    public JcaSignedPublicKeyAndChallenge(byte[] bytes) {
        super(bytes);
    }

    public JcaSignedPublicKeyAndChallenge setProvider(String providerName) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new NamedJcaJceHelper(providerName));
    }

    public JcaSignedPublicKeyAndChallenge setProvider(Provider provider) {
        return new JcaSignedPublicKeyAndChallenge(this.spkacSeq, new ProviderJcaJceHelper(provider));
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = this.spkacSeq.getPublicKeyAndChallenge().getSubjectPublicKeyInfo();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            KeyFactory keyFactory = this.helper.createKeyFactory(algorithmIdentifier.getAlgorithm().getId());
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

