/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mime.encoding;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final byte[] decodingTable;
    InputStream in;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    boolean isEndOfStream;

    private int decode(int in0, int in1, int in2, int in3, int[] out) throws EOFException {
        if (in3 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (in2 == 61) {
            int n2 = decodingTable[in0] & 0xFF;
            int n3 = decodingTable[in1] & 0xFF;
            out[2] = (n2 << 2 | n3 >> 4) & 0xFF;
            return 2;
        }
        if (in3 == 61) {
            byte by2 = decodingTable[in0];
            byte by3 = decodingTable[in1];
            byte by4 = decodingTable[in2];
            out[1] = (by2 << 2 | by3 >> 4) & 0xFF;
            out[2] = (by3 << 4 | by4 >> 2) & 0xFF;
            return 1;
        }
        byte by5 = decodingTable[in0];
        byte by6 = decodingTable[in1];
        byte by7 = decodingTable[in2];
        byte by8 = decodingTable[in3];
        out[0] = (by5 << 2 | by6 >> 4) & 0xFF;
        out[1] = (by6 << 4 | by7 >> 2) & 0xFF;
        out[2] = (by7 << 6 | by8) & 0xFF;
        return 0;
    }

    public Base64InputStream(InputStream in2) {
        this.in = in2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private int readIgnoreSpace() throws IOException {
        int n2 = this.in.read();
        while (n2 == 32 || n2 == 9) {
            n2 = this.in.read();
        }
        return n2;
    }

    public int read() throws IOException {
        int n2;
        if (this.bufPtr > 2) {
            n2 = this.readIgnoreSpace();
            if (n2 == 13 || n2 == 10) {
                n2 = this.readIgnoreSpace();
                while (n2 == 10 || n2 == 13) {
                    n2 = this.readIgnoreSpace();
                }
                if (n2 < 0) {
                    this.isEndOfStream = true;
                    return -1;
                }
                this.bufPtr = this.decode(n2, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else if (n2 >= 0) {
                this.bufPtr = this.decode(n2, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else {
                this.isEndOfStream = true;
                return -1;
            }
        }
        n2 = this.outBuf[this.bufPtr++];
        return n2;
    }

    public void close() throws IOException {
        this.in.close();
    }

    static {
        int n2;
        decodingTable = new byte[128];
        for (n2 = 65; n2 <= 90; ++n2) {
            Base64InputStream.decodingTable[n2] = (byte)(n2 - 65);
        }
        for (n2 = 97; n2 <= 122; ++n2) {
            Base64InputStream.decodingTable[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            Base64InputStream.decodingTable[n2] = (byte)(n2 - 48 + 52);
        }
        Base64InputStream.decodingTable[43] = 62;
        Base64InputStream.decodingTable[47] = 63;
    }
}

