/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.spec;

import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.PrfUtils;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2KeySpec
extends PBEKeySpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private AlgorithmIdentifier prf;

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n2, int n3) {
        this(cArray, byArray, n2, n3, defaultPRF);
    }

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n2, int n3, DigestAlgorithm digestAlgorithm) {
        this(cArray, byArray, n2, n3, PrfUtils.getAlgorithmIdentifier(digestAlgorithm));
    }

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        super(cArray, byArray, n2, n3);
        this.prf = algorithmIdentifier;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

