/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.interfaces.GOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GOST3410Util;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST3410DomainParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST3410ParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.GOST3410PrivateKeySpec;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvGOST3410PrivateKey
implements GOST3410PrivateKey,
ProvKey<AsymmetricGOST3410PrivateKey> {
    private static final long serialVersionUID = 8581661527592305464L;
    private transient AsymmetricGOST3410PrivateKey baseKey;

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKey gOST3410PrivateKey) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(gOST3410PrivateKey.getParams()), gOST3410PrivateKey.getX());
    }

    ProvGOST3410PrivateKey(Algorithm algorithm, GOST3410PrivateKeySpec gOST3410PrivateKeySpec) {
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, GOST3410Util.convertToParams(gOST3410PrivateKeySpec.getParams()), gOST3410PrivateKeySpec.getX());
    }

    ProvGOST3410PrivateKey(AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey) {
        this.baseKey = asymmetricGOST3410PrivateKey;
    }

    @Override
    public BigInteger getX() {
        return this.baseKey.getX();
    }

    @Override
    public GOST3410ParameterSpec<GOST3410DomainParameterSpec> getParams() {
        return GOST3410Util.convertToSpec(this.baseKey.getParameters());
    }

    @Override
    public AsymmetricGOST3410PrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvGOST3410PrivateKey)) {
            return false;
        }
        ProvGOST3410PrivateKey provGOST3410PrivateKey = (ProvGOST3410PrivateKey)object;
        return this.baseKey.equals(provGOST3410PrivateKey.baseKey);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("GOST3410 Private Key").append(string);
        try {
            stringBuilder.append("    X: ").append(this.getX().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricGOST3410PrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

