/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.nist.NISTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DSAParameter;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.OutputSignerUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.SignatureOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DSADomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDSA;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsDigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSA;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AsymmetricAlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSignature;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PrivateKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvDSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvDSAPublicKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.PublicKeyConverter;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.X509AlgorithmParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.DSADomainParameterSpec;
import com.aspose.html.internal.ms.core.bc.jcajce.spec.DSADomainParametersGenerationParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;

class ProvDSA
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalDsaAttributes = new HashMap<String, String>();
    private static final ASN1ObjectIdentifier[] dsaOids;
    private static final SignatureOperatorFactory fipsDsaFactory;
    private static SignatureOperatorFactory genDsaFactory;
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.";
    private static final PublicKeyConverter<AsymmetricDSAPublicKey> publicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricDSAPrivateKey> privateKeyConverter;

    ProvDSA() {
    }

    private static SignatureOperatorFactory getGeneralDSAFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (genDsaFactory == null) {
            genDsaFactory = new DSA.OperatorFactory();
        }
        return genDsaFactory;
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.AlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new DSAAlgorithmParameters();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.AlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new DSAAlgorithmParameterGenerator(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.KeyPairGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.KeyFactorySpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA1WITHDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$stdDSA", generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA);
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHDSA", "DSA", "SHA1/DSA");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.NONEWITHDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$noneDSA", generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(null));
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "NONEWITHDSA", "RAWDSA");
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA224", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa224", NISTObjectIdentifiers.dsa_with_sha224, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA256", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA384", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa384", NISTObjectIdentifiers.dsa_with_sha384, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa512", NISTObjectIdentifiers.dsa_with_sha512, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa512_224", null, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", "DSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.DSASigner$dsa512_256", null, generalDsaAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, FipsDSA.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.DDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$ecDetDSA", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA1WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA224WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA224", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA256WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA256", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA384WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA384", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA512", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(224)WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA512_224", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(256)WITHDDSA", "com.aspose.html.internal.ms.core.bc.jcajce.provider.asymmetric.dsa.SignatureSpi$DetDSA512_256", generalDsaAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvDSA.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, DSA.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
                }
            }));
            bouncyCastleFipsProvider.addAlias("Signature", "DDSA", "DETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHDDSA", "SHA1WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA224WITHDDSA", "SHA224WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA256WITHDDSA", "SHA256WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA384WITHDDSA", "SHA384WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA512WITHDDSA", "SHA512WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA512(224)WITHDDSA", "SHA512(224)WITHDETDSA");
            bouncyCastleFipsProvider.addAlias("Signature", "SHA512(256)WITHDDSA", "SHA512(256)WITHDETDSA");
        }
        KeyFactorySpi keyFactorySpi = new KeyFactorySpi();
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHDSA", dsaOids);
        for (int i2 = 0; i2 != dsaOids.length; ++i2) {
            this.registerOid(bouncyCastleFipsProvider, dsaOids[i2], "DSA", keyFactorySpi);
            this.registerOidAlgorithmParameters(bouncyCastleFipsProvider, dsaOids[i2], "DSA");
        }
    }

    static {
        generalDsaAttributes.put("SupportedKeyClasses", "java.security.interfaces.DSAPublicKey|java.security.interfaces.DSAPrivateKey");
        generalDsaAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, X9ObjectIdentifiers.id_dsa_with_sha1, OIWObjectIdentifiers.dsaWithSHA1};
        fipsDsaFactory = new FipsDSA.OperatorFactory();
        publicKeyConverter = new PublicKeyConverter<AsymmetricDSAPublicKey>(){

            @Override
            public AsymmetricDSAPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof DSAPublicKey) {
                    if (publicKey instanceof ProvDSAPublicKey) {
                        return ((ProvDSAPublicKey)publicKey).getBaseKey();
                    }
                    return new ProvDSAPublicKey(algorithm, (DSAPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricDSAPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("cannot identify DSA public key: " + exception.toString(), exception);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricDSAPrivateKey>(){

            @Override
            public AsymmetricDSAPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof DSAPrivateKey) {
                    if (privateKey instanceof ProvDSAPrivateKey) {
                        return ((ProvDSAPrivateKey)privateKey).getBaseKey();
                    }
                    return new ProvDSAPrivateKey(algorithm, (DSAPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricDSAPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("cannot identify DSA private key: " + exception.toString(), exception);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdaptiveSignatureOperatorFactory<T extends Parameters>
    implements SignatureOperatorFactory<FipsDSA.Parameters> {
        private AdaptiveSignatureOperatorFactory() {
        }

        public final OutputSignerUsingSecureRandom createSigner(AsymmetricPrivateKey asymmetricPrivateKey, FipsDSA.Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return (OutputSignerUsingSecureRandom)fipsDsaFactory.createSigner(asymmetricPrivateKey, parameters);
            }
            AsymmetricDSAPrivateKey asymmetricDSAPrivateKey = (AsymmetricDSAPrivateKey)asymmetricPrivateKey;
            int n2 = asymmetricDSAPrivateKey.getDomainParameters().getP().bitLength();
            if (n2 < 2048 || n2 > 3072) {
                DSA.Parameters parameters2 = DSA.DSA.withDigestAlgorithm(parameters.getDigestAlgorithm());
                return (OutputSignerUsingSecureRandom)ProvDSA.getGeneralDSAFactory().createSigner(asymmetricPrivateKey, parameters2);
            }
            return (OutputSignerUsingSecureRandom)fipsDsaFactory.createSigner(asymmetricPrivateKey, parameters);
        }

        @Override
        public final OutputVerifier createVerifier(AsymmetricPublicKey asymmetricPublicKey, FipsDSA.Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return fipsDsaFactory.createVerifier(asymmetricPublicKey, parameters);
            }
            AsymmetricDSAPublicKey asymmetricDSAPublicKey = (AsymmetricDSAPublicKey)asymmetricPublicKey;
            int n2 = asymmetricDSAPublicKey.getDomainParameters().getP().bitLength();
            if (n2 < 2048 || n2 > 3072) {
                DSA.Parameters parameters2 = DSA.DSA.withDigestAlgorithm(parameters.getDigestAlgorithm());
                return ProvDSA.getGeneralDSAFactory().createVerifier(asymmetricPublicKey, parameters2);
            }
            return fipsDsaFactory.createVerifier(asymmetricPublicKey, parameters);
        }
    }

    static class DSAAlgorithmParameterGenerator
    extends AlgorithmParameterGeneratorSpi {
        protected SecureRandom random;
        protected int strength = 1024;
        private final BouncyCastleFipsProvider fipsProvider;
        private DSA.DomainParametersGenerator genGen;
        private FipsDSA.DomainParametersGenerator fipsGen;

        DSAAlgorithmParameterGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        protected void engineInit(int n2, SecureRandom secureRandom) {
            if (n2 < 512 || n2 > 3072) {
                throw new InvalidParameterException("strength must be from 512 - 3072");
            }
            if (n2 <= 1024 && n2 % 64 != 0) {
                throw new InvalidParameterException("strength must be a multiple of 64 below 1024 bits.");
            }
            if (n2 > 1024 && n2 % 1024 != 0) {
                throw new InvalidParameterException("strength must be a multiple of 1024 above 1024 bits.");
            }
            this.strength = n2;
            this.random = secureRandom;
            if (n2 < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new InvalidParameterException("Attempt to create unapproved parameters in approved only mode");
                }
                this.genGen = new DSA.DomainParametersGenerator(new DSA.DomainGenParameters(n2), secureRandom);
                this.fipsGen = null;
            } else {
                this.fipsGen = new FipsDSA.DomainParametersGenerator(new FipsDSA.DomainGenParameters(n2), secureRandom);
                this.genGen = null;
            }
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            DSADomainParametersGenerationParameterSpec dSADomainParametersGenerationParameterSpec;
            if (algorithmParameterSpec instanceof DSADomainParametersGenerationParameterSpec) {
                dSADomainParametersGenerationParameterSpec = (DSADomainParametersGenerationParameterSpec)algorithmParameterSpec;
                if (!(dSADomainParametersGenerationParameterSpec.getDigestAlgorithm() instanceof FipsAlgorithm)) {
                    throw new InvalidAlgorithmParameterException("Digest algorithm must be a FIPS algorithm");
                }
            } else {
                if (algorithmParameterSpec != null) {
                    throw new InvalidAlgorithmParameterException("Unknown AlgorithmParameterSpec passed to DSA parameters generator: " + algorithmParameterSpec.getClass().getName());
                }
                throw new InvalidAlgorithmParameterException("null AlgorithmParameterSpec passed to DSA parameters generator");
            }
            this.fipsGen = dSADomainParametersGenerationParameterSpec.getP() != null ? new FipsDSA.DomainParametersGenerator((FipsDigestAlgorithm)dSADomainParametersGenerationParameterSpec.getDigestAlgorithm(), new FipsDSA.DomainGenParameters(dSADomainParametersGenerationParameterSpec.getP(), dSADomainParametersGenerationParameterSpec.getQ(), dSADomainParametersGenerationParameterSpec.getSeed(), dSADomainParametersGenerationParameterSpec.getUsageIndex()), secureRandom) : new FipsDSA.DomainParametersGenerator((FipsDigestAlgorithm)dSADomainParametersGenerationParameterSpec.getDigestAlgorithm(), new FipsDSA.DomainGenParameters(dSADomainParametersGenerationParameterSpec.getL(), dSADomainParametersGenerationParameterSpec.getN(), dSADomainParametersGenerationParameterSpec.getCertainty(), dSADomainParametersGenerationParameterSpec.getUsageIndex()), secureRandom);
            this.genGen = null;
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            DSADomainParameters dSADomainParameters;
            if (this.random == null) {
                this.random = this.fipsProvider.getDefaultSecureRandom();
            }
            if (this.fipsGen != null) {
                dSADomainParameters = this.fipsGen.generateDomainParameters();
            } else if (this.genGen != null) {
                dSADomainParameters = this.genGen.generateDomainParameters();
            } else {
                this.fipsGen = new FipsDSA.DomainParametersGenerator(new FipsDSA.DomainGenParameters(this.strength), this.random);
                dSADomainParameters = this.fipsGen.generateDomainParameters();
            }
            try {
                algorithmParameters = AlgorithmParameters.getInstance("DSA", this.fipsProvider);
                algorithmParameters.init(new DSADomainParameterSpec(dSADomainParameters.getP(), dSADomainParameters.getQ(), dSADomainParameters.getG(), dSADomainParameters.getValidationParameters()));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    static class DSAAlgorithmParameters
    extends X509AlgorithmParameters {
        DSADomainParameterSpec currentSpec;

        DSAAlgorithmParameters() {
        }

        protected boolean isASN1FormatString(String string) {
            return string == null || string.equals("ASN.1");
        }

        protected byte[] localGetEncoded() throws IOException {
            DSAParameter dSAParameter = new DSAParameter(this.currentSpec.getP(), this.currentSpec.getQ(), this.currentSpec.getG());
            return dSAParameter.getEncoded("DER");
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == DSAParameterSpec.class || clazz == DSADomainParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidParameterSpecException("DSAParameterSpec required to initialise a DSA algorithm parameters object");
            }
            if (algorithmParameterSpec instanceof DSADomainParameterSpec) {
                this.currentSpec = (DSADomainParameterSpec)algorithmParameterSpec;
            } else {
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
                this.currentSpec = new DSADomainParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG());
            }
        }

        protected void localInit(byte[] byArray) throws IOException {
            DSAParameter dSAParameter = DSAParameter.getInstance(ASN1Primitive.fromByteArray(byArray));
            this.currentSpec = new DSADomainParameterSpec(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
        }

        protected String engineToString() {
            return "DSA Parameters";
        }
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(DSAPublicKeySpec.class) && key instanceof DSAPublicKey) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
                return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
            }
            if (clazz.isAssignableFrom(DSAPrivateKeySpec.class) && key instanceof DSAPrivateKey) {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
                return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvDSAPublicKey((AsymmetricDSAPublicKey)publicKeyConverter.convertKey(FipsDSA.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvDSAPrivateKey((AsymmetricDSAPrivateKey)privateKeyConverter.convertKey(FipsDSA.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvDSAPrivateKey(new AsymmetricDSAPrivateKey((Algorithm)FipsDSA.ALGORITHM, privateKeyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvDSAPublicKey(new AsymmetricDSAPublicKey((Algorithm)FipsDSA.ALGORITHM, subjectPublicKeyInfo));
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSAPrivateKeySpec) {
                return new ProvDSAPrivateKey((Algorithm)FipsDSA.ALGORITHM, (DSAPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSAPublicKeySpec) {
                try {
                    return new ProvDSAPublicKey((Algorithm)FipsDSA.ALGORITHM, (DSAPublicKeySpec)keySpec);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException("invalid KeySpec: " + exception.getMessage(), exception);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        AsymmetricKeyPairGenerator engine;
        int strength = 2048;
        private SecureRandom random;
        boolean initialised = false;

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("DSA");
            this.fipsProvider = bouncyCastleFipsProvider;
            this.random = bouncyCastleFipsProvider.getDefaultSecureRandom();
        }

        public void initialize(int n2) {
            this.initialize(n2, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int n2, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (n2 != 2048 && n2 != 3072) {
                    throw new InvalidParameterException("strength must be 2048 or 3072");
                }
            } else if (n2 < 512 || n2 > 4096 || n2 % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 64");
            }
            this.strength = n2;
            this.random = secureRandom;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            try {
                this.engine = dSAParameterSpec.getP().bitLength() < 2048 ? new DSA.KeyPairGenerator(new DSA.KeyGenParameters(new DSADomainParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG())), secureRandom) : new FipsDSA.KeyPairGenerator(new FipsDSA.KeyGenParameters(new DSADomainParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG())), secureRandom);
            }
            catch (FipsUnapprovedOperationError fipsUnapprovedOperationError) {
                throw new InvalidAlgorithmParameterException(fipsUnapprovedOperationError.getMessage(), (Throwable)((Object)fipsUnapprovedOperationError));
            }
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            Object object;
            if (!this.initialised) {
                if (this.strength < 2048) {
                    object = (DSADomainParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DSA_DEFAULT_PARAMS, this.strength);
                    if (object == null) {
                        DSA.DomainParametersGenerator domainParametersGenerator = new DSA.DomainParametersGenerator(new DSA.DomainGenParameters(this.strength), this.random);
                        object = domainParametersGenerator.generateDomainParameters();
                    }
                    this.engine = new DSA.KeyPairGenerator(new DSA.KeyGenParameters((DSADomainParameters)object), this.random);
                } else {
                    object = (DSADomainParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DSA_DEFAULT_PARAMS, this.strength);
                    if (object == null) {
                        FipsDSA.DomainParametersGenerator domainParametersGenerator = new FipsDSA.DomainParametersGenerator(new FipsDSA.DomainGenParameters(this.strength), this.random);
                        object = domainParametersGenerator.generateDomainParameters();
                    }
                    this.engine = new FipsDSA.KeyPairGenerator(new FipsDSA.KeyGenParameters((DSADomainParameters)object), this.random);
                }
                this.initialised = true;
            }
            object = this.engine.generateKeyPair();
            return new KeyPair(new ProvDSAPublicKey((AsymmetricDSAPublicKey)((AsymmetricKeyPair)object).getPublicKey()), new ProvDSAPrivateKey((AsymmetricDSAPrivateKey)((AsymmetricKeyPair)object).getPrivateKey()));
        }
    }
}

