/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ESTException
extends IOException {
    private Throwable cause;
    private InputStream body;
    private int statusCode;
    private static final long MAX_ERROR_BODY = 8192L;

    public ESTException(String msg) {
        this(msg, null);
    }

    public ESTException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
        this.body = null;
        this.statusCode = 0;
    }

    public ESTException(String message, Throwable cause, int statusCode, InputStream body) {
        super(message);
        this.cause = cause;
        this.statusCode = statusCode;
        if (body != null) {
            byte[] byArray = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n2 = body.read(byArray);
                while (n2 >= 0) {
                    if ((long)(byteArrayOutputStream.size() + n2) > 8192L) {
                        n2 = 8192 - byteArrayOutputStream.size();
                        byteArrayOutputStream.write(byArray, 0, n2);
                        break;
                    }
                    byteArrayOutputStream.write(byArray, 0, n2);
                    n2 = body.read(byArray);
                }
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
                this.body = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                body.close();
            }
            catch (Exception exception) {}
        } else {
            this.body = null;
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getMessage() {
        return super.getMessage() + " HTTP Status Code: " + this.statusCode;
    }

    public InputStream getBody() {
        return this.body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

