/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.eac;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ParsingException;
import com.aspose.html.internal.ms.core.bc.asn1.eac.CVCertificateRequest;
import com.aspose.html.internal.ms.core.bc.asn1.eac.PublicKeyDataObject;
import com.aspose.html.internal.ms.core.bc.eac.EACException;
import com.aspose.html.internal.ms.core.bc.eac.EACIOException;
import com.aspose.html.internal.ms.core.bc.eac.operator.EACSignatureVerifier;
import java.io.IOException;
import java.io.OutputStream;

public class EACCertificateRequestHolder {
    private CVCertificateRequest request;

    private static CVCertificateRequest parseBytes(byte[] requestEncoding) throws IOException {
        try {
            return CVCertificateRequest.getInstance(requestEncoding);
        }
        catch (ClassCastException classCastException) {
            throw new EACIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EACIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            if (aSN1ParsingException.getCause() instanceof IOException) {
                throw (IOException)aSN1ParsingException.getCause();
            }
            throw new EACIOException("malformed data: " + aSN1ParsingException.getMessage(), aSN1ParsingException);
        }
    }

    public EACCertificateRequestHolder(byte[] certEncoding) throws IOException {
        this(EACCertificateRequestHolder.parseBytes(certEncoding));
    }

    public EACCertificateRequestHolder(CVCertificateRequest request) {
        this.request = request;
    }

    public CVCertificateRequest toASN1Structure() {
        return this.request;
    }

    public PublicKeyDataObject getPublicKeyDataObject() {
        return this.request.getPublicKey();
    }

    public boolean isInnerSignatureValid(EACSignatureVerifier verifier) throws EACException {
        try {
            OutputStream outputStream = verifier.getOutputStream();
            outputStream.write(this.request.getCertificateBody().getEncoded("DER"));
            outputStream.close();
            return verifier.verify(this.request.getInnerSignature());
        }
        catch (Exception exception) {
            throw new EACException("unable to process signature: " + exception.getMessage(), exception);
        }
    }
}

