/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.EntropySource;
import com.aspose.html.internal.ms.core.bc.crypto.general.DRBG;
import com.aspose.html.internal.ms.core.bc.crypto.util.EntropyUtil;
import java.security.SecureRandom;

public final class GeneralSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final DRBG drbg;
    private final EntropySource entropySource;
    private final boolean predictionResistant;

    GeneralSecureRandom(SecureRandom secureRandom, DRBG dRBG, EntropySource entropySource, boolean bl2) {
        this.randomSource = secureRandom;
        this.drbg = dRBG;
        this.entropySource = entropySource;
        this.predictionResistant = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(byte[] byArray) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(long l2) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (this.randomSource != null) {
                this.randomSource.setSeed(l2);
            }
        }
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] byArray, byte[] byArray2) {
        GeneralSecureRandom generalSecureRandom = this;
        synchronized (generalSecureRandom) {
            if (byArray == null) {
                throw new NullPointerException("bytes cannot be null");
            }
            if (byArray.length != 0 && this.drbg.generate(byArray, byArray2, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(byArray, byArray2, this.predictionResistant);
            }
        }
    }

    public byte[] generateSeed(int n2) {
        return EntropyUtil.generateSeed(this.entropySource, n2);
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] byArray) {
        this.drbg.reseed(byArray);
    }
}

