/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.OutputSignerUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410PublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410DomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410KeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410PrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410PublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.Gost3410Signer;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedAsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSignatureOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.ConsistencyTest;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("GOST3410", (Enum)Variations.GOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private GOST3410() {
    }

    private static Gost3410Parameters getDomainParams(GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters) {
        GOST3410DomainParameters gOST3410DomainParameters = gOST3410Parameters.getDomainParameters();
        return new Gost3410Parameters(gOST3410DomainParameters.getP(), gOST3410DomainParameters.getQ(), gOST3410DomainParameters.getA());
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                Gost3410Signer gost3410Signer = new Gost3410Signer();
                gost3410Signer.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = gost3410Signer.generateSignature(byArray);
                gost3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
                gost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return gost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    private static Gost3410PrivateKeyParameters getLwKey(final AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<Gost3410PrivateKeyParameters>(){

            @Override
            public Gost3410PrivateKeyParameters run() {
                return new Gost3410PrivateKeyParameters(asymmetricGOST3410PrivateKey.getX(), com.aspose.html.internal.ms.core.bc.crypto.general.GOST3410.getDomainParams(asymmetricGOST3410PrivateKey.getParameters()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<GOST3410DomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<GOST3410DomainParameters> gOST3410Parameters) {
            super(ALGORITHM);
            this.domainParameters = gOST3410Parameters;
        }

        public GOST3410Parameters<GOST3410DomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> {
        private final Gost3410KeyPairGenerator engine = new Gost3410KeyPairGenerator();
        private final GOST3410Parameters<GOST3410DomainParameters> parameters;
        private final Gost3410KeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new Gost3410KeyGenerationParameters(secureRandom, com.aspose.html.internal.ms.core.bc.crypto.general.GOST3410.getDomainParams(this.parameters));
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            com.aspose.html.internal.ms.core.bc.crypto.general.GOST3410.validateKeyPair(asymmetricCipherKeyPair);
            Gost3410PublicKeyParameters gost3410PublicKeyParameters = (Gost3410PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            Gost3410PrivateKeyParameters gost3410PrivateKeyParameters = (Gost3410PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t2 = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricGOST3410PublicKey, AsymmetricGOST3410PrivateKey>(new AsymmetricGOST3410PublicKey((Algorithm)t2, this.parameters, gost3410PublicKeyParameters.getY()), new AsymmetricGOST3410PrivateKey((Algorithm)t2, this.parameters, gost3410PrivateKeyParameters.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricGOST3410PrivateKey asymmetricGOST3410PrivateKey = (AsymmetricGOST3410PrivateKey)asymmetricPrivateKey;
            final Gost3410PrivateKeyParameters gost3410PrivateKeyParameters = com.aspose.html.internal.ms.core.bc.crypto.general.GOST3410.getLwKey(asymmetricGOST3410PrivateKey);
            return new DSAOutputSigner<SignatureParameters>(gost3410Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(gost3410PrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            Gost3410Signer gost3410Signer = new Gost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricGOST3410PublicKey asymmetricGOST3410PublicKey = (AsymmetricGOST3410PublicKey)asymmetricPublicKey;
            Gost3410PublicKeyParameters gost3410PublicKeyParameters = new Gost3410PublicKeyParameters(asymmetricGOST3410PublicKey.getY(), com.aspose.html.internal.ms.core.bc.crypto.general.GOST3410.getDomainParams(asymmetricGOST3410PublicKey.getParameters()));
            gost3410Signer.init(false, gost3410PublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(gost3410Signer, digest, signatureParameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        GOST3410;

    }
}

