/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaParameterGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.DsaValidationParameters;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.BigIntegers;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

class DsaParametersGenerator {
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private boolean use186_3;
    private int usageIndex;

    public DsaParametersGenerator() {
        this(Register.createDigest(FipsSHS.Algorithm.SHA1));
    }

    public DsaParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.use186_3 = false;
        this.L = n2;
        this.N = DsaParametersGenerator.getDefaultN(n2);
        this.certainty = n3;
        this.random = secureRandom;
    }

    public void init(DsaParameterGenerationParameters dsaParameterGenerationParameters) {
        this.use186_3 = true;
        this.L = dsaParameterGenerationParameters.getL();
        this.N = dsaParameterGenerationParameters.getN();
        this.certainty = dsaParameterGenerationParameters.getCertainty();
        this.random = dsaParameterGenerationParameters.getRandom();
        this.usageIndex = dsaParameterGenerationParameters.getUsageIndex();
        if (this.L < 1024 || this.L > 3072 || this.L % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (this.L == 1024 && this.N != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (this.L == 2048 && this.N != 224 && this.N != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (this.L == 3072 && this.N != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < this.N) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
    }

    public DsaParameters generateParameters() {
        return this.use186_3 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_2() {
        var1_1 = new byte[20];
        var2_2 = new byte[20];
        var3_3 = new byte[20];
        var4_4 = new byte[20];
        var5_5 = (this.L - 1) / 160;
        var6_6 = new byte[this.L / 8];
        block0: while (true) {
            this.random.nextBytes(var1_1);
            DsaParametersGenerator.hash(this.digest, var1_1, var2_2);
            System.arraycopy(var1_1, 0, var3_3, 0, var1_1.length);
            DsaParametersGenerator.inc(var3_3);
            DsaParametersGenerator.hash(this.digest, var3_3, var3_3);
            for (var7_8 = 0; var7_8 != var4_4.length; ++var7_8) {
                var4_4[var7_8] = (byte)(var2_2[var7_8] ^ var3_3[var7_8]);
            }
            var4_4[0] = (byte)(var4_4[0] | -128);
            var4_4[19] = (byte)(var4_4[19] | 1);
            var7_7 = new BigInteger(1, var4_4);
            if (!var7_7.isProbablePrime(this.certainty)) continue;
            var8_9 = Arrays.clone(var1_1);
            DsaParametersGenerator.inc(var8_9);
            var9_10 = 0;
            while (true) {
                if (var9_10 < 4096) ** break;
                continue block0;
                for (var10_12 = 0; var10_12 < var5_5; ++var10_12) {
                    DsaParametersGenerator.inc(var8_9);
                    DsaParametersGenerator.hash(this.digest, var8_9, var2_2);
                    System.arraycopy(var2_2, 0, var6_6, var6_6.length - (var10_12 + 1) * var2_2.length, var2_2.length);
                }
                DsaParametersGenerator.inc(var8_9);
                DsaParametersGenerator.hash(this.digest, var8_9, var2_2);
                System.arraycopy(var2_2, var2_2.length - (var6_6.length - var5_5 * var2_2.length), var6_6, 0, var6_6.length - var5_5 * var2_2.length);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var10_11 = new BigInteger(1, var6_6);
                var11_13 = var10_11.mod(var7_7.shiftLeft(1));
                var12_14 = var10_11.subtract(var11_13.subtract(DsaParametersGenerator.ONE));
                if (var12_14.bitLength() == this.L && var12_14.isProbablePrime(this.certainty)) {
                    var13_15 = DsaParametersGenerator.calculateGenerator_FIPS186_2(var12_14, var7_7, this.random);
                    return new DsaParameters(var12_14, var7_7, var13_15, new DsaValidationParameters(var1_1, var9_10));
                }
                ++var9_10;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger6, secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_3() {
        var1_1 = this.digest;
        var2_2 = var1_1.getDigestSize() * 8;
        var3_3 = this.N;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.L - 1) / var2_2;
        var6_6 = (this.L - 1) % var2_2;
        var7_7 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(var4_4);
            DsaParametersGenerator.hash(var1_1, var4_4, var7_7);
            var8_8 = new BigInteger(1, var7_7).mod(DsaParametersGenerator.ONE.shiftLeft(this.N - 1));
            var9_9 = DsaParametersGenerator.ONE.shiftLeft(this.N - 1).add(var8_8).add(DsaParametersGenerator.ONE).subtract(var8_8.mod(DsaParametersGenerator.TWO));
            if (!var9_9.isProbablePrime(this.certainty)) continue;
            var10_10 = Arrays.clone(var4_4);
            var11_11 = 4 * this.L;
            var12_12 = 0;
            while (true) {
                if (var12_12 < var11_11) ** break;
                continue block0;
                var13_13 = DsaParametersGenerator.ZERO;
                var14_15 = 0;
                var15_17 = 0;
                while (var14_15 <= var5_5) {
                    DsaParametersGenerator.inc(var10_10);
                    DsaParametersGenerator.hash(var1_1, var10_10, var7_7);
                    var16_18 = new BigInteger(1, var7_7);
                    if (var14_15 == var5_5) {
                        var16_18 = var16_18.mod(DsaParametersGenerator.ONE.shiftLeft(var6_6));
                    }
                    var13_13 = var13_13.add(var16_18.shiftLeft(var15_17));
                    ++var14_15;
                    var15_17 += var2_2;
                }
                var14_14 = var13_13.add(DsaParametersGenerator.ONE.shiftLeft(this.L - 1));
                var16_18 = var14_14.subtract((var15_16 = var14_14.mod(var9_9.shiftLeft(1))).subtract(DsaParametersGenerator.ONE));
                if (var16_18.bitLength() == this.L && var16_18.isProbablePrime(this.certainty)) {
                    if (this.usageIndex >= 0 && (var17_19 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(var1_1, var16_18, var9_9, var4_4, this.usageIndex)) != null) {
                        return new DsaParameters(var16_18, var9_9, var17_19, new DsaValidationParameters(var4_4, var12_12, this.usageIndex));
                    }
                    var17_19 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(var16_18, var9_9, this.random);
                    return new DsaParameters(var16_18, var9_9, var17_19, new DsaValidationParameters(var4_4, var12_12));
                }
                ++var12_12;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DsaParametersGenerator.calculateGenerator_FIPS186_2(bigInteger, bigInteger2, secureRandom);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        BigInteger bigInteger3 = bigInteger.subtract(ONE).divide(bigInteger2);
        byte[] byArray2 = Hex.decode("6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n2;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i2 = 1; i2 < 65536; ++i2) {
            DsaParametersGenerator.inc(byArray3);
            DsaParametersGenerator.hash(digest, byArray3, byArray4);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(TWO) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, 0);
    }

    private static int getDefaultN(int n2) {
        return n2 > 1024 ? 256 : 160;
    }

    private static void inc(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byte by2;
            byArray[i2] = by2 = (byte)(byArray[i2] + 1 & 0xFF);
            if (by2 != 0) break;
        }
    }
}

