/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricGOST3410Key;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricECGOST3410PrivateKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPrivateKey {
    private final int hashCode;
    private BigInteger x;

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> gOST3410Parameters, BigInteger bigInteger) {
        super(algorithm, gOST3410Parameters);
        this.x = bigInteger;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_2001, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricECGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            if (aSN1Encodable instanceof ASN1Integer) {
                return ASN1Integer.getInstance(aSN1Encodable).getPositiveValue();
            }
            byte[] byArray = ASN1OctetString.getInstance(aSN1Encodable).getOctets();
            byte[] byArray2 = new byte[byArray.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray2[i2] = byArray[byArray.length - 1 - i2];
            }
            return new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse ECGOST3410 private key: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public final byte[] getEncoded() {
        byte[] byArray = new byte[32];
        this.extractBytes(byArray, 0, this.getS());
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(byArray));
    }

    private void extractBytes(byte[] byArray, int n2, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != 32; ++i2) {
            byArray[n2 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.x;
    }

    private void zeroize() {
        this.x = null;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.x.hashCode();
        n2 = 31 * n2 + this.getParameters().hashCode();
        return n2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zeroize();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)object;
        return this.x.equals(asymmetricECGOST3410PrivateKey.x) && this.getParameters().equals(asymmetricECGOST3410PrivateKey.getParameters());
    }
}

