/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.ElGamalParameter;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.DHParameter;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x9.DomainParameters;
import com.aspose.html.internal.ms.core.bc.asn1.x9.ValidationParams;
import com.aspose.html.internal.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricDHKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.DHValidationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import java.io.IOException;
import java.math.BigInteger;

public final class AsymmetricDHPublicKey
extends AsymmetricDHKey
implements AsymmetricPublicKey {
    private BigInteger y;
    private SubjectPublicKeyInfo publicKeyInfo;

    public AsymmetricDHPublicKey(Algorithm algorithm, DHDomainParameters dHDomainParameters, BigInteger bigInteger) {
        super(algorithm, dHDomainParameters);
        this.y = KeyUtils.validated(dHDomainParameters, bigInteger);
    }

    public AsymmetricDHPublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricDHPublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, subjectPublicKeyInfo.getAlgorithm());
        this.y = KeyUtils.validated(this.getDomainParameters(), AsymmetricDHPublicKey.parsePublicKey(subjectPublicKeyInfo));
        this.publicKeyInfo = subjectPublicKeyInfo;
    }

    private static BigInteger parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1Integer aSN1Integer;
        try {
            aSN1Integer = ASN1Integer.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid info structure in DH public key");
        }
        if (aSN1Integer == null) {
            throw new NullPointerException("keyData in SubjectPublicKeyInfo is empty");
        }
        return aSN1Integer.getValue();
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded() {
        DHDomainParameters dHDomainParameters = this.getDomainParameters();
        if (this.publicKeyInfo != null) {
            return KeyUtils.getEncodedInfo(this.publicKeyInfo);
        }
        if (dHDomainParameters.getQ() == null) {
            if (this.getAlgorithm().getName().startsWith("ELGAMAL")) {
                return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(dHDomainParameters.getP(), dHDomainParameters.getG())), new ASN1Integer(this.y));
            }
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getL())), new ASN1Integer(this.y));
        }
        DHValidationParameters dHValidationParameters = dHDomainParameters.getValidationParameters();
        if (dHValidationParameters != null) {
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), new ValidationParams(dHValidationParameters.getSeed(), dHValidationParameters.getCounter()))), new ASN1Integer(this.y));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters(dHDomainParameters.getP(), dHDomainParameters.getG(), dHDomainParameters.getQ(), dHDomainParameters.getJ(), null)), new ASN1Integer(this.y));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricDHPublicKey)) {
            return false;
        }
        AsymmetricDHPublicKey asymmetricDHPublicKey = (AsymmetricDHPublicKey)object;
        return this.y.equals(asymmetricDHPublicKey.y) && this.getDomainParameters().equals(asymmetricDHPublicKey.getDomainParameters());
    }

    public int hashCode() {
        int n2 = this.y.hashCode();
        n2 = 31 * n2 + this.getDomainParameters().hashCode();
        return n2;
    }
}

