/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.operator.InputExpander;
import com.aspose.html.internal.ms.core.bc.operator.InputExpanderProvider;
import com.aspose.html.internal.ms.core.bc.util.io.StreamOverflowException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class ZlibExpanderProvider
implements InputExpanderProvider {
    private final long limit;

    public ZlibExpanderProvider() {
        this.limit = -1L;
    }

    public ZlibExpanderProvider(long limit) {
        this.limit = limit;
    }

    public InputExpander get(final AlgorithmIdentifier algorithm) {
        return new InputExpander(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            public InputStream getInputStream(InputStream comIn) {
                FilterInputStream filterInputStream = new InflaterInputStream(comIn);
                if (ZlibExpanderProvider.this.limit >= 0L) {
                    filterInputStream = new LimitedInputStream(filterInputStream, ZlibExpanderProvider.this.limit);
                }
                return filterInputStream;
            }
        };
    }

    private static class LimitedInputStream
    extends FilterInputStream {
        private long remaining;

        public LimitedInputStream(InputStream input, long limit) {
            super(input);
            this.remaining = limit;
        }

        public int read() throws IOException {
            int n2;
            if (this.remaining >= 0L && ((n2 = this.in.read()) < 0 || --this.remaining >= 0L)) {
                return n2;
            }
            throw new StreamOverflowException("expanded byte limit exceeded");
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (len < 1) {
                return super.read(buf, off, len);
            }
            if (this.remaining < 1L) {
                this.read();
                return -1;
            }
            int n2 = this.remaining > (long)len ? len : (int)this.remaining;
            int n3 = this.in.read(buf, off, n2);
            if (n3 > 0) {
                this.remaining -= (long)n3;
            }
            return n3;
        }
    }
}

