/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.CMSAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignatureEncryptionAlgorithmFinder;
import com.aspose.html.internal.ms.core.bc.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGeneratorBuilder;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        this(digestProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder) {
        this.builder = new SignerInfoGeneratorBuilder(digestProvider, sigEncAlgFinder);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.builder.setDirectSignature(hasNoSignedAttributes);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.builder.setSignedAttributeGenerator(signedGen);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.builder.setUnsignedAttributeGenerator(unsignedGen);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder certHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, certHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] keyIdentifier) throws OperatorCreationException {
        return this.builder.build(contentSigner, keyIdentifier);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(certificate));
    }
}

