/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSTypedData;
import java.io.IOException;
import java.io.OutputStream;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier type, ASN1Encodable structure) {
        this.type = type;
        this.structure = structure;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    public void write(OutputStream cOut) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(this.structure);
            for (ASN1Encodable aSN1Encodable : aSN1Sequence) {
                cOut.write(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] byArray = this.structure.toASN1Primitive().getEncoded("DER");
            int n2 = 1;
            while ((byArray[n2] & 0xFF) > 127) {
                ++n2;
            }
            cOut.write(byArray, ++n2, byArray.length - n2);
        }
    }

    public Object getContent() {
        return this.structure;
    }
}

