/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.BERGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.BERSequenceGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.BERSet;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.DERTaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AuthenticatedData;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSAuthenticatedGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.DefaultAuthenticatedAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import com.aspose.html.internal.ms.core.bc.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CMSAuthenticatedDataStreamGenerator
extends CMSAuthenticatedGenerator {
    private int bufferSize;
    private boolean berEncodeRecipientSet;
    private MacCalculator macCalculator;

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBEREncodeRecipients(boolean useBerEncodingForRecipients) {
        this.berEncodeRecipientSet = useBerEncodingForRecipients;
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator);
    }

    public OutputStream open(OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        return this.open(CMSObjectIdentifiers.data, out, macCalculator, digestCalculator);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator) throws CMSException {
        return this.open(dataType, out, macCalculator, null);
    }

    public OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, MacCalculator macCalculator, DigestCalculator digestCalculator) throws CMSException {
        this.macCalculator = macCalculator;
        try {
            Object object2;
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (Object object2 : this.recipientInfoGenerators) {
                aSN1EncodableVector.add(object2.generate(macCalculator.getKey()));
            }
            BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(out);
            bERSequenceGenerator.addObject(CMSObjectIdentifiers.authenticatedData);
            object2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
            ((BERSequenceGenerator)object2).addObject(new ASN1Integer(AuthenticatedData.calculateVersion(this.originatorInfo)));
            if (this.originatorInfo != null) {
                ((BERSequenceGenerator)object2).addObject(new DERTaggedObject(false, 0, this.originatorInfo));
            }
            if (this.berEncodeRecipientSet) {
                ((BERGenerator)object2).getRawOutputStream().write(new BERSet(aSN1EncodableVector).getEncoded());
            } else {
                ((BERGenerator)object2).getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
            }
            AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
            ((BERGenerator)object2).getRawOutputStream().write(algorithmIdentifier.getEncoded());
            if (digestCalculator != null) {
                ((BERSequenceGenerator)object2).addObject(new DERTaggedObject(false, 1, digestCalculator.getAlgorithmIdentifier()));
            }
            BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(((BERGenerator)object2).getRawOutputStream());
            bERSequenceGenerator2.addObject(dataType);
            OutputStream outputStream = CMSUtils.createBEROctetOutputStream(bERSequenceGenerator2.getRawOutputStream(), 0, false, this.bufferSize);
            TeeOutputStream teeOutputStream = digestCalculator != null ? new TeeOutputStream(outputStream, digestCalculator.getOutputStream()) : new TeeOutputStream(outputStream, macCalculator.getOutputStream());
            return new CmsAuthenticatedDataOutputStream(macCalculator, digestCalculator, dataType, teeOutputStream, bERSequenceGenerator, (BERSequenceGenerator)object2, bERSequenceGenerator2);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
    }

    private class CmsAuthenticatedDataOutputStream
    extends OutputStream {
        private OutputStream dataStream;
        private BERSequenceGenerator cGen;
        private BERSequenceGenerator envGen;
        private BERSequenceGenerator eiGen;
        private MacCalculator macCalculator;
        private DigestCalculator digestCalculator;
        private ASN1ObjectIdentifier contentType;

        public CmsAuthenticatedDataOutputStream(MacCalculator macCalculator, DigestCalculator digestCalculator, ASN1ObjectIdentifier contentType, OutputStream dataStream, BERSequenceGenerator cGen, BERSequenceGenerator envGen, BERSequenceGenerator eiGen) {
            this.macCalculator = macCalculator;
            this.digestCalculator = digestCalculator;
            this.contentType = contentType;
            this.dataStream = dataStream;
            this.cGen = cGen;
            this.envGen = envGen;
            this.eiGen = eiGen;
        }

        public void write(int b2) throws IOException {
            this.dataStream.write(b2);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dataStream.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dataStream.write(bytes);
        }

        public void close() throws IOException {
            Map map;
            this.dataStream.close();
            this.eiGen.close();
            if (this.digestCalculator != null) {
                map = Collections.unmodifiableMap(CMSAuthenticatedDataStreamGenerator.this.getBaseParameters(this.contentType, this.digestCalculator.getAlgorithmIdentifier(), this.macCalculator.getAlgorithmIdentifier(), this.digestCalculator.getDigest()));
                if (CMSAuthenticatedDataStreamGenerator.this.authGen == null) {
                    CMSAuthenticatedDataStreamGenerator.this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
                }
                DERSet dERSet = new DERSet(CMSAuthenticatedDataStreamGenerator.this.authGen.getAttributes(map).toASN1EncodableVector());
                OutputStream outputStream = this.macCalculator.getOutputStream();
                outputStream.write(dERSet.getEncoded("DER"));
                outputStream.close();
                this.envGen.addObject(new DERTaggedObject(false, 2, dERSet));
            } else {
                map = Collections.unmodifiableMap(new HashMap());
            }
            this.envGen.addObject(new DEROctetString(this.macCalculator.getMac()));
            if (CMSAuthenticatedDataStreamGenerator.this.unauthGen != null) {
                this.envGen.addObject(new DERTaggedObject(false, 3, new BERSet(CMSAuthenticatedDataStreamGenerator.this.unauthGen.getAttributes(map).toASN1EncodableVector())));
            }
            this.envGen.close();
            this.cGen.close();
        }
    }
}

