/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.OCSPRequest;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.Request;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.Signature;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.TBSRequest;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.CertificateID;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPReq;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OCSPReqBuilder {
    private List list = new ArrayList();
    private GeneralName requestorName = null;
    private Extensions requestExtensions = null;

    public OCSPReqBuilder addRequest(CertificateID certId) {
        this.list.add(new RequestObject(certId, null));
        return this;
    }

    public OCSPReqBuilder addRequest(CertificateID certId, Extensions singleRequestExtensions) {
        this.list.add(new RequestObject(certId, singleRequestExtensions));
        return this;
    }

    public OCSPReqBuilder setRequestorName(X500Name requestorName) {
        this.requestorName = new GeneralName(4, requestorName);
        return this;
    }

    public OCSPReqBuilder setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
        return this;
    }

    public OCSPReqBuilder setRequestExtensions(Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
        return this;
    }

    private OCSPReq generateRequest(ContentSigner contentSigner, X509CertificateHolder[] chain) throws OCSPException {
        Iterator iterator = this.list.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            try {
                aSN1EncodableVector.add(((RequestObject)iterator.next()).toRequest());
            }
            catch (Exception exception) {
                throw new OCSPException("exception creating Request", exception);
            }
        }
        TBSRequest tBSRequest = new TBSRequest(this.requestorName, new DERSequence(aSN1EncodableVector), this.requestExtensions);
        Signature signature = null;
        if (contentSigner != null) {
            Object object;
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                object = contentSigner.getOutputStream();
                ((OutputStream)object).write(tBSRequest.getEncoded("DER"));
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                throw new OCSPException("exception processing TBSRequest: " + exception, exception);
            }
            object = new DERBitString(contentSigner.getSignature());
            AlgorithmIdentifier algorithmIdentifier = contentSigner.getAlgorithmIdentifier();
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
                for (int i2 = 0; i2 != chain.length; ++i2) {
                    aSN1EncodableVector2.add(chain[i2].toASN1Structure());
                }
                signature = new Signature(algorithmIdentifier, (DERBitString)object, new DERSequence(aSN1EncodableVector2));
            } else {
                signature = new Signature(algorithmIdentifier, (DERBitString)object);
            }
        }
        return new OCSPReq(new OCSPRequest(tBSRequest, signature));
    }

    public OCSPReq build() throws OCSPException {
        return this.generateRequest(null, null);
    }

    public OCSPReq build(ContentSigner signer, X509CertificateHolder[] chain) throws OCSPException, IllegalArgumentException {
        if (signer == null) {
            throw new IllegalArgumentException("no signer specified");
        }
        return this.generateRequest(signer, chain);
    }

    private class RequestObject {
        CertificateID certId;
        Extensions extensions;

        public RequestObject(CertificateID certId, Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() throws Exception {
            return new Request(this.certId.toASN1Primitive(), this.extensions);
        }
    }
}

