/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.ocsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERGeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.BasicOCSPResponse;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.CertStatus;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.ResponseData;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.RevokedInfo;
import com.aspose.html.internal.ms.core.bc.asn1.ocsp.SingleResponse;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CRLReason;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.BasicOCSPResp;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.CertificateID;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.CertificateStatus;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.OCSPException;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.RespID;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.RevokedStatus;
import com.aspose.html.internal.ms.core.bc.cert.ocsp.UnknownStatus;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespBuilder {
    private List list = new ArrayList();
    private Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespBuilder(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespBuilder(SubjectPublicKeyInfo key, DigestCalculator digCalc) throws OCSPException {
        this.responderID = new RespID(key, digCalc);
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.addResponse(certID, certStatus, new Date(), null, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Extensions singleExtensions) {
        this.addResponse(certID, certStatus, new Date(), null, singleExtensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, Extensions singleExtensions) {
        this.addResponse(certID, certStatus, new Date(), nextUpdate, singleExtensions);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate) {
        this.addResponse(certID, certStatus, thisUpdate, nextUpdate, null);
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new ResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder setResponseExtensions(Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
        return this;
    }

    public BasicOCSPResp build(ContentSigner signer, X509CertificateHolder[] chain, Date producedAt) throws OCSPException {
        DERBitString dERBitString;
        Object object;
        Iterator iterator = this.list.iterator();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while (iterator.hasNext()) {
            try {
                aSN1EncodableVector.add(((ResponseObject)iterator.next()).toResponse());
            }
            catch (Exception exception) {
                throw new OCSPException("exception creating Request", exception);
            }
        }
        ResponseData responseData = new ResponseData(this.responderID.toASN1Primitive(), new ASN1GeneralizedTime(producedAt), new DERSequence(aSN1EncodableVector), this.responseExtensions);
        try {
            object = signer.getOutputStream();
            ((OutputStream)object).write(responseData.getEncoded("DER"));
            ((OutputStream)object).close();
            dERBitString = new DERBitString(signer.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing TBSRequest: " + exception.getMessage(), exception);
        }
        object = signer.getAlgorithmIdentifier();
        DERSequence dERSequence = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            for (int i2 = 0; i2 != chain.length; ++i2) {
                aSN1EncodableVector2.add(chain[i2].toASN1Structure());
            }
            dERSequence = new DERSequence(aSN1EncodableVector2);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(responseData, (AlgorithmIdentifier)object, dERBitString, dERSequence));
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        ASN1GeneralizedTime thisUpdate;
        ASN1GeneralizedTime nextUpdate;
        Extensions extensions;

        public ResponseObject(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, Extensions extensions) {
            RevokedStatus revokedStatus;
            this.certId = certId;
            this.certStatus = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((revokedStatus = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), CRLReason.lookup(revokedStatus.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(revokedStatus.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(thisUpdate);
            this.nextUpdate = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Primitive(), this.certStatus, this.thisUpdate, this.nextUpdate, this.extensions);
        }
    }
}

