/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.ValueDecryptorGenerator;
import com.aspose.html.internal.ms.core.bc.cert.crmf.jcajce.CRMFHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.operator.InputDecryptor;
import com.aspose.html.internal.ms.core.bc.operator.OperatorException;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JceAsymmetricKeyUnwrapper;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricValueDecryptorGenerator
implements ValueDecryptorGenerator {
    private PrivateKey recipientKey;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());
    private Provider provider = null;
    private String providerName = null;

    public JceAsymmetricValueDecryptorGenerator(PrivateKey recipientKey) {
        this.recipientKey = recipientKey;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        this.provider = provider;
        this.providerName = null;
        return this;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        this.provider = null;
        this.providerName = providerName;
        return this;
    }

    private Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CRMFException {
        try {
            JceAsymmetricKeyUnwrapper jceAsymmetricKeyUnwrapper = new JceAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
            if (this.provider != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.provider);
            }
            if (this.providerName != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.providerName);
            }
            return new SecretKeySpec((byte[])jceAsymmetricKeyUnwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey).getRepresentation(), contentEncryptionAlgorithm.getAlgorithm().getId());
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("key invalid in message: " + operatorException.getMessage(), operatorException);
        }
    }

    public InputDecryptor getValueDecryptor(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CRMFException {
        Key key = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Cipher cipher = this.helper.createContentCipher(key, contentEncryptionAlgorithm);
        return new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataIn) {
                return new CipherInputStream(dataIn, cipher);
            }
        };
    }
}

