/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.CMPObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PBMParameter;
import com.aspose.html.internal.ms.core.bc.asn1.iana.IANAObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACValuesCalculator;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.MacCalculator;
import com.aspose.html.internal.ms.core.bc.operator.RuntimeOperatorException;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class PKMACBuilder {
    private AlgorithmIdentifier owf;
    private int iterationCount;
    private AlgorithmIdentifier mac;
    private int saltLength = 20;
    private SecureRandom random;
    private PKMACValuesCalculator calculator;
    private PBMParameter parameters;
    private int maxIterations;

    public PKMACBuilder(PKMACValuesCalculator calculator) {
        this(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), 1000, new AlgorithmIdentifier(IANAObjectIdentifiers.hmacSHA1, DERNull.INSTANCE), calculator);
    }

    public PKMACBuilder(PKMACValuesCalculator calculator, int maxIterations) {
        this.maxIterations = maxIterations;
        this.calculator = calculator;
    }

    private PKMACBuilder(AlgorithmIdentifier hashAlgorithm, int iterationCount, AlgorithmIdentifier macAlgorithm, PKMACValuesCalculator calculator) {
        this.owf = hashAlgorithm;
        this.iterationCount = iterationCount;
        this.mac = macAlgorithm;
        this.calculator = calculator;
    }

    public PKMACBuilder setSaltLength(int saltLength) {
        if (saltLength < 8) {
            throw new IllegalArgumentException("salt length must be at least 8 bytes");
        }
        this.saltLength = saltLength;
        return this;
    }

    public PKMACBuilder setIterationCount(int iterationCount) {
        if (iterationCount < 100) {
            throw new IllegalArgumentException("iteration count must be at least 100");
        }
        this.checkIterationCountCeiling(iterationCount);
        this.iterationCount = iterationCount;
        return this;
    }

    public PKMACBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PKMACBuilder setParameters(PBMParameter parameters) {
        this.checkIterationCountCeiling(parameters.getIterationCount().getValue().intValue());
        this.parameters = parameters;
        return this;
    }

    public MacCalculator build(char[] password) throws CRMFException {
        if (this.parameters != null) {
            return this.genCalculator(this.parameters, password);
        }
        byte[] byArray = new byte[this.saltLength];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        return this.genCalculator(new PBMParameter(byArray, this.owf, this.iterationCount, this.mac), password);
    }

    private void checkIterationCountCeiling(int iterationCount) {
        if (this.maxIterations > 0 && iterationCount > this.maxIterations) {
            throw new IllegalArgumentException("iteration count exceeds limit (" + iterationCount + " > " + this.maxIterations + ")");
        }
    }

    private MacCalculator genCalculator(final PBMParameter params, char[] password) throws CRMFException {
        byte[] byArray = Strings.toUTF8ByteArray(password);
        byte[] byArray2 = params.getSalt().getOctets();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        this.calculator.setup(params.getOwf(), params.getMac());
        int n2 = params.getIterationCount().getValue().intValue();
        do {
            byArray3 = this.calculator.calculateDigest(byArray3);
        } while (--n2 > 0);
        final byte[] byArray4 = byArray3;
        return new MacCalculator(){
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(CMPObjectIdentifiers.passwordBasedMac, params);
            }

            public GenericKey getKey() {
                return new GenericKey(this.getAlgorithmIdentifier(), byArray4);
            }

            public OutputStream getOutputStream() {
                return this.bOut;
            }

            public byte[] getMac() {
                try {
                    return PKMACBuilder.this.calculator.calculateMac(byArray4, this.bOut.toByteArray());
                }
                catch (CRMFException cRMFException) {
                    throw new RuntimeOperatorException("exception calculating mac: " + cRMFException.getMessage(), cRMFException);
                }
            }
        };
    }
}

