/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cert.crmf;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Null;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERTaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.AttributeTypeAndValue;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertReqMsg;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertRequest;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertTemplate;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.CertTemplateBuilder;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.OptionalValidity;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.PKMACValue;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.POPOPrivKey;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.ProofOfPossession;
import com.aspose.html.internal.ms.core.bc.asn1.crmf.SubsequentMessage;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.ExtensionsGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Time;
import com.aspose.html.internal.ms.core.bc.cert.CertIOException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFException;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CRMFUtil;
import com.aspose.html.internal.ms.core.bc.cert.crmf.CertificateRequestMessage;
import com.aspose.html.internal.ms.core.bc.cert.crmf.Control;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACBuilder;
import com.aspose.html.internal.ms.core.bc.cert.crmf.PKMACValueGenerator;
import com.aspose.html.internal.ms.core.bc.cert.crmf.ProofOfPossessionSigningKeyBuilder;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CertificateRequestMessageBuilder {
    private final BigInteger certReqId;
    private ExtensionsGenerator extGenerator;
    private CertTemplateBuilder templateBuilder;
    private List controls;
    private ContentSigner popSigner;
    private PKMACBuilder pkmacBuilder;
    private char[] password;
    private GeneralName sender;
    private int popoType = 2;
    private POPOPrivKey popoPrivKey;
    private ASN1Null popRaVerified;
    private PKMACValue agreeMAC;

    public CertificateRequestMessageBuilder(BigInteger certReqId) {
        this.certReqId = certReqId;
        this.extGenerator = new ExtensionsGenerator();
        this.templateBuilder = new CertTemplateBuilder();
        this.controls = new ArrayList();
    }

    public CertificateRequestMessageBuilder setPublicKey(SubjectPublicKeyInfo publicKey) {
        if (publicKey != null) {
            this.templateBuilder.setPublicKey(publicKey);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setIssuer(X500Name issuer) {
        if (issuer != null) {
            this.templateBuilder.setIssuer(issuer);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setSubject(X500Name subject) {
        if (subject != null) {
            this.templateBuilder.setSubject(subject);
        }
        return this;
    }

    public CertificateRequestMessageBuilder setSerialNumber(BigInteger serialNumber) {
        if (serialNumber != null) {
            this.templateBuilder.setSerialNumber(new ASN1Integer(serialNumber));
        }
        return this;
    }

    public CertificateRequestMessageBuilder setValidity(Date notBeforeDate, Date notAfterDate) {
        this.templateBuilder.setValidity(new OptionalValidity(this.createTime(notBeforeDate), this.createTime(notAfterDate)));
        return this;
    }

    private Time createTime(Date date) {
        if (date != null) {
            return new Time(date);
        }
        return null;
    }

    public CertificateRequestMessageBuilder addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) throws CertIOException {
        CRMFUtil.addExtension(this.extGenerator, oid, critical, value);
        return this;
    }

    public CertificateRequestMessageBuilder addExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        this.extGenerator.addExtension(oid, critical, value);
        return this;
    }

    public CertificateRequestMessageBuilder addControl(Control control) {
        this.controls.add(control);
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionSigningKeySigner(ContentSigner popSigner) {
        if (this.popoPrivKey != null || this.popRaVerified != null || this.agreeMAC != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.popSigner = popSigner;
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionSubsequentMessage(SubsequentMessage msg) {
        if (this.popSigner != null || this.popRaVerified != null || this.agreeMAC != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.popoType = 2;
        this.popoPrivKey = new POPOPrivKey(msg);
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionSubsequentMessage(int type, SubsequentMessage msg) {
        if (this.popSigner != null || this.popRaVerified != null || this.agreeMAC != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        if (type != 2 && type != 3) {
            throw new IllegalArgumentException("type must be ProofOfPossession.TYPE_KEY_ENCIPHERMENT || ProofOfPossession.TYPE_KEY_AGREEMENT");
        }
        this.popoType = type;
        this.popoPrivKey = new POPOPrivKey(msg);
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionAgreeMAC(PKMACValue macValue) {
        if (this.popSigner != null || this.popRaVerified != null || this.popoPrivKey != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.agreeMAC = macValue;
        return this;
    }

    public CertificateRequestMessageBuilder setProofOfPossessionRaVerified() {
        if (this.popSigner != null || this.popoPrivKey != null) {
            throw new IllegalStateException("only one proof of possession allowed");
        }
        this.popRaVerified = DERNull.INSTANCE;
        return this;
    }

    public CertificateRequestMessageBuilder setAuthInfoPKMAC(PKMACBuilder pkmacBuilder, char[] password) {
        this.pkmacBuilder = pkmacBuilder;
        this.password = password;
        return this;
    }

    public CertificateRequestMessageBuilder setAuthInfoSender(X500Name sender) {
        return this.setAuthInfoSender(new GeneralName(sender));
    }

    public CertificateRequestMessageBuilder setAuthInfoSender(GeneralName sender) {
        this.sender = sender;
        return this;
    }

    public CertificateRequestMessage build() throws CRMFException {
        Object object;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.certReqId));
        if (!this.extGenerator.isEmpty()) {
            this.templateBuilder.setExtensions(this.extGenerator.generate());
        }
        aSN1EncodableVector.add(this.templateBuilder.build());
        if (!this.controls.isEmpty()) {
            object = new ASN1EncodableVector();
            for (Object object2 : this.controls) {
                ((ASN1EncodableVector)object).add(new AttributeTypeAndValue(object2.getType(), object2.getValue()));
            }
            aSN1EncodableVector.add(new DERSequence((ASN1EncodableVector)object));
        }
        object = CertRequest.getInstance(new DERSequence(aSN1EncodableVector));
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)object);
        if (this.popSigner != null) {
            Object object2;
            CertTemplate certTemplate = ((CertRequest)object).getCertTemplate();
            if (certTemplate.getSubject() == null || certTemplate.getPublicKey() == null) {
                object2 = ((CertRequest)object).getCertTemplate().getPublicKey();
                ProofOfPossessionSigningKeyBuilder proofOfPossessionSigningKeyBuilder = new ProofOfPossessionSigningKeyBuilder((SubjectPublicKeyInfo)object2);
                if (this.sender != null) {
                    proofOfPossessionSigningKeyBuilder.setSender(this.sender);
                } else {
                    PKMACValueGenerator pKMACValueGenerator = new PKMACValueGenerator(this.pkmacBuilder);
                    proofOfPossessionSigningKeyBuilder.setPublicKeyMac(pKMACValueGenerator, this.password);
                }
                aSN1EncodableVector.add(new ProofOfPossession(proofOfPossessionSigningKeyBuilder.build(this.popSigner)));
            } else {
                object2 = new ProofOfPossessionSigningKeyBuilder((CertRequest)object);
                aSN1EncodableVector.add(new ProofOfPossession(((ProofOfPossessionSigningKeyBuilder)object2).build(this.popSigner)));
            }
        } else if (this.popoPrivKey != null) {
            aSN1EncodableVector.add(new ProofOfPossession(this.popoType, this.popoPrivKey));
        } else if (this.agreeMAC != null) {
            aSN1EncodableVector.add(new ProofOfPossession(3, POPOPrivKey.getInstance(new DERTaggedObject(false, 3, this.agreeMAC))));
        } else if (this.popRaVerified != null) {
            aSN1EncodableVector.add(new ProofOfPossession());
        }
        return new CertificateRequestMessage(CertReqMsg.getInstance(new DERSequence(aSN1EncodableVector)));
    }
}

