/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1SignatureDeformatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAPKCS1SignatureFormatter;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509CertificateCollection;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.h;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import java.util.Comparator;
import java.util.Iterator;

public final class PKCS7 {
    private static final StringSwitchMap c = new StringSwitchMap("1.3.14.3.2.26", "1.2.840.113549.2.2", "1.2.840.113549.2.5", "2.16.840.1.101.3.4.1", "2.16.840.1.101.3.4.2", "2.16.840.1.101.3.4.3");
    private static String d = StringExtensions.format("Input data cannot be coded as a valid certificate.", new Object[0]);
    static final int a = -2146889714;
    static final String b = "The original signer is not found.";

    private PKCS7() {
    }

    public static ASN1 attribute(String oid, ASN1 value) {
        ASN1 aSN1 = new ASN1(48);
        aSN1.add(ASN1Convert.fromOid(oid));
        ASN1 aSN12 = aSN1.add(new ASN1(49));
        aSN12.add(value);
        return aSN1;
    }

    public static ASN1 algorithmIdentifier(String oid) {
        ASN1 aSN1 = new ASN1(48);
        aSN1.add(ASN1Convert.fromOid(oid));
        aSN1.add(new ASN1(5));
        return aSN1;
    }

    public static ASN1 algorithmIdentifier(String oid, ASN1 parameters) {
        ASN1 aSN1 = new ASN1(48);
        aSN1.add(ASN1Convert.fromOid(oid));
        aSN1.add(parameters);
        return aSN1;
    }

    public static ASN1 issuerAndSerialNumber(X509Certificate x509) {
        ASN1 aSN1;
        ASN1 aSN12 = null;
        ASN1 aSN13 = null;
        ASN1 aSN14 = new ASN1(x509.getRawData());
        int n2 = 0;
        boolean bl2 = false;
        while (n2 < aSN14.get_Item(0).getCount()) {
            aSN1 = aSN14.get_Item(0).get_Item(n2++);
            if (aSN1.getTag() == 2) {
                aSN13 = aSN1;
                continue;
            }
            if (aSN1.getTag() != 48) continue;
            if (bl2) {
                aSN12 = aSN1;
                break;
            }
            bl2 = true;
        }
        aSN1 = new ASN1(48);
        aSN1.add(aSN12);
        aSN1.add(aSN13);
        return aSN1;
    }

    public static X509Certificate[] loadCertificates(byte[] data) {
        ContentInfo contentInfo = new ContentInfo(data);
        if (!contentInfo.getContentType().equals("1.2.840.113549.1.7.2")) {
            throw new CryptographicException(d);
        }
        SignedData signedData = new SignedData(contentInfo.getContent());
        SignerInfo signerInfo = signedData.getSignerInfo();
        if (signerInfo.getIssuerName() == null) {
            throw new CryptographicException(b);
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[signedData.getCertificates().size()];
        signedData.getCertificates().copyTo(x509CertificateArray, 0);
        return x509CertificateArray;
    }

    static class a
    implements Comparator {
        a() {
        }

        public int compare(Object x2, Object y2) {
            ASN1 aSN1;
            if (x2 == null) {
                return y2 == null ? 0 : -1;
            }
            if (y2 == null) {
                return 1;
            }
            ASN1 aSN12 = x2 instanceof ASN1 ? (ASN1)x2 : null;
            ASN1 aSN13 = aSN1 = y2 instanceof ASN1 ? (ASN1)y2 : null;
            if (aSN12 == null || aSN1 == null) {
                throw new ArgumentException(StringExtensions.format("Invalid objects.", new Object[0]));
            }
            byte[] byArray = aSN12.getBytes();
            byte[] byArray2 = aSN1.getBytes();
            for (int i2 = 0; i2 < byArray.length && i2 != byArray2.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF) ? -1 : 1;
            }
            if (byArray.length > byArray2.length) {
                return 1;
            }
            if (byArray.length < byArray2.length) {
                return -1;
            }
            return 0;
        }
    }

    public static class SignerInfo {
        private byte a = 1;
        private X509Certificate b;
        private String c;
        private AsymmetricAlgorithm d;
        private ArrayList e = new ArrayList();
        private ArrayList f = new ArrayList();
        private byte[] g;
        private String h;
        private byte[] i;
        private byte[] j;

        public SignerInfo() {
        }

        public SignerInfo(byte[] data) {
            this(new ASN1(data));
        }

        public SignerInfo(ASN1 asn1) {
            this();
            ASN1 aSN1;
            if (asn1.get_Item(0).getTag() != 48 || asn1.get_Item(0).getCount() < 5) {
                throw new ArgumentException("Invalid SignedData");
            }
            if (asn1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = asn1.get_Item(0).get_Item(0).getValue()[0];
            ASN1 aSN12 = asn1.get_Item(0).get_Item(1);
            if ((aSN12.getTag() & 0xFF) == 128 && this.a == 3) {
                this.j = aSN12.getValue();
            } else {
                this.h = com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.h.a(aSN12.get_Item(0));
                this.i = aSN12.get_Item(1).getValue();
            }
            ASN1 aSN13 = asn1.get_Item(0).get_Item(2);
            this.c = ASN1Convert.toOid(aSN13.get_Item(0));
            int n2 = 3;
            ASN1 aSN14 = asn1.get_Item(0).get_Item(n2);
            if ((aSN14.getTag() & 0xFF) == 160) {
                ++n2;
                for (int i2 = 0; i2 < aSN14.getCount(); ++i2) {
                    this.e.addItem(aSN14.get_Item(i2));
                }
            }
            int n3 = ++n2;
            ++n2;
            ASN1 aSN15 = asn1.get_Item(0).get_Item(n3);
            if (aSN15.getTag() == 4) {
                this.g = aSN15.getValue();
            }
            if ((aSN1 = asn1.get_Item(0).get_Item(n2)) != null && (aSN1.getTag() & 0xFF) == 161) {
                for (int i3 = 0; i3 < aSN1.getCount(); ++i3) {
                    this.f.addItem(aSN1.get_Item(i3));
                }
            }
        }

        public String getIssuerName() {
            return this.h;
        }

        public byte[] getSerialNumber() {
            if (this.i == null) {
                return null;
            }
            return (byte[])this.i.clone();
        }

        public byte[] getSubjectKeyIdentifier() {
            if (this.j == null) {
                return null;
            }
            return (byte[])this.j.clone();
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ArrayList getAuthenticatedAttributes() {
            return this.e;
        }

        public X509Certificate getCertificate() {
            return this.b;
        }

        public void setCertificate(X509Certificate value) {
            this.b = value;
        }

        public String getHashName() {
            return this.c;
        }

        public void setHashName(String value) {
            this.c = value;
        }

        public AsymmetricAlgorithm getKey() {
            return this.d;
        }

        public void setKey(AsymmetricAlgorithm value) {
            this.d = value;
        }

        public byte[] getSignature() {
            if (this.g == null) {
                return null;
            }
            return (byte[])this.g.clone();
        }

        public void setSignature(byte[] value) {
            if (value != null) {
                this.g = (byte[])value.clone();
            }
        }

        public ArrayList getUnauthenticatedAttributes() {
            return this.f;
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte value) {
            this.a = value;
        }

        ASN1 a() {
            Object object;
            if (this.d == null || this.c == null) {
                return null;
            }
            byte[] byArray = new byte[]{this.a};
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(new ASN1(2, byArray));
            aSN1.add(PKCS7.issuerAndSerialNumber(this.b));
            String string = CryptoConfig.mapNameToOID(this.c);
            aSN1.add(PKCS7.algorithmIdentifier(string));
            ASN1 aSN12 = null;
            if (this.e.size() > 0) {
                aSN12 = aSN1.add(new ASN1(-96));
                this.e.sort((Comparator)new a());
                for (Iterator iterator : this.e) {
                    aSN12.add((ASN1)((Object)iterator));
                }
            }
            if (this.d instanceof RSA) {
                aSN1.add(PKCS7.algorithmIdentifier("1.2.840.113549.1.1.1"));
                if (aSN12 != null) {
                    Iterator iterator;
                    object = new RSAPKCS1SignatureFormatter(this.d);
                    ((RSAPKCS1SignatureFormatter)object).setHashAlgorithm(this.c);
                    iterator = (Iterator)aSN12.getBytes();
                    iterator[0] = 49;
                    Object object2 = HashAlgorithm.create(this.c);
                    byte[] byArray2 = ((HashAlgorithm)object2).computeHash((byte[])iterator);
                    this.g = ((RSAPKCS1SignatureFormatter)object).createSignature(byArray2);
                }
            } else {
                if (this.d instanceof DSA) {
                    throw new NotImplementedException("not yet");
                }
                throw new CryptographicException("Unknown assymetric algorithm");
            }
            aSN1.add(new ASN1(4, this.g));
            if (this.f.size() > 0) {
                object = aSN1.add(new ASN1(-95));
                this.f.sort((Comparator)new a());
                for (Object object2 : this.f) {
                    ((ASN1)object).add((ASN1)object2);
                }
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class SignedData {
        private byte a;
        private String b;
        private ContentInfo c;
        private X509CertificateCollection d;
        private ArrayList e;
        private SignerInfo f;
        private boolean g;
        private boolean h;

        public SignedData() {
            this.a = 1;
            this.c = new ContentInfo();
            this.d = new X509CertificateCollection();
            this.e = new ArrayList();
            this.f = new SignerInfo();
            this.g = true;
            this.h = false;
        }

        public SignedData(byte[] data) {
            this(new ASN1(data));
        }

        public SignedData(ASN1 asn1) {
            int n2;
            if (asn1.get_Item(0).getTag() != 48 || asn1.get_Item(0).getCount() < 4) {
                throw new ArgumentException("Invalid SignedData");
            }
            if (asn1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = asn1.get_Item(0).get_Item(0).getValue()[0];
            this.c = new ContentInfo(asn1.get_Item(0).get_Item(2));
            int n3 = 3;
            this.d = new X509CertificateCollection();
            if ((asn1.get_Item(0).get_Item(n3).getTag() & 0xFF) == 160) {
                for (n2 = 0; n2 < asn1.get_Item(0).get_Item(n3).getCount(); ++n2) {
                    this.d.add(new X509Certificate(asn1.get_Item(0).get_Item(n3).get_Item(n2).getBytes()));
                }
                ++n3;
            }
            this.e = new ArrayList();
            if ((asn1.get_Item(0).get_Item(n3).getTag() & 0xFF) == 161) {
                for (n2 = 0; n2 < asn1.get_Item(0).get_Item(n3).getCount(); ++n2) {
                    this.e.addItem(asn1.get_Item(0).get_Item(n3).get_Item(n2).getBytes());
                }
                ++n3;
            }
            this.f = asn1.get_Item(0).get_Item(n3).getCount() > 0 ? new SignerInfo(asn1.get_Item(0).get_Item(n3)) : new SignerInfo();
            if (this.f.getHashName() != null) {
                this.setHashName(this.a(this.f.getHashName()));
            }
            this.g = this.f.getAuthenticatedAttributes().size() > 0;
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public X509CertificateCollection getCertificates() {
            return this.d;
        }

        public ContentInfo getContentInfo() {
            return this.c;
        }

        public ArrayList getCrls() {
            return this.e;
        }

        public String getHashName() {
            return this.b;
        }

        public void setHashName(String value) {
            this.b = value;
            this.f.setHashName(value);
        }

        public SignerInfo getSignerInfo() {
            return this.f;
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte value) {
            this.a = value;
        }

        public boolean getUseAuthenticatedAttributes() {
            return this.g;
        }

        public void setUseAuthenticatedAttributes(boolean value) {
            this.g = value;
        }

        public boolean verifySignature(AsymmetricAlgorithm aa2) {
            if (aa2 == null) {
                return false;
            }
            RSAPKCS1SignatureDeformatter rSAPKCS1SignatureDeformatter = new RSAPKCS1SignatureDeformatter(aa2);
            rSAPKCS1SignatureDeformatter.setHashAlgorithm(this.b);
            HashAlgorithm hashAlgorithm = HashAlgorithm.create(this.b);
            byte[] byArray = this.f.getSignature();
            byte[] byArray2 = null;
            if (this.g) {
                ASN1 aSN1 = new ASN1(49);
                for (ASN1 aSN12 : this.f.getAuthenticatedAttributes()) {
                    aSN1.add(aSN12);
                }
                byArray2 = hashAlgorithm.computeHash(aSN1.getBytes());
            } else {
                byArray2 = hashAlgorithm.computeHash(this.c.getContent().get_Item(0).getValue());
            }
            if (byArray2 != null && byArray != null) {
                return rSAPKCS1SignatureDeformatter.verifySignature(byArray2, byArray);
            }
            return false;
        }

        String a(String string) {
            switch (c.of(string)) {
                case 0: {
                    return "SHA1";
                }
                case 1: {
                    return "MD2";
                }
                case 2: {
                    return "MD5";
                }
                case 3: {
                    return "SHA256";
                }
                case 4: {
                    return "SHA384";
                }
                case 5: {
                    return "SHA512";
                }
            }
            return string;
        }

        ASN1 a() {
            Object object5;
            Object object2;
            Object object3;
            Object object4;
            ASN1 aSN1 = new ASN1(48);
            byte[] byArray = new byte[]{this.a};
            aSN1.add(new ASN1(2, byArray));
            ASN1 aSN12 = aSN1.add(new ASN1(49));
            if (this.b != null) {
                object4 = CryptoConfig.mapNameToOID(this.b);
                aSN12.add(PKCS7.algorithmIdentifier((String)object4));
            }
            object4 = this.c.get_ASN1();
            aSN1.add((ASN1)object4);
            if (!this.h && this.b != null) {
                if (this.g) {
                    object3 = PKCS7.attribute("1.2.840.113549.1.9.3", ((ASN1)object4).get_Item(0));
                    this.f.getAuthenticatedAttributes().addItem(object3);
                    object2 = HashAlgorithm.create(this.b);
                    object5 = ((HashAlgorithm)object2).computeHash(((ASN1)object4).get_Item(1).get_Item(0).getValue());
                    ASN1 aSN13 = new ASN1(48);
                    ASN1 aSN14 = PKCS7.attribute("1.2.840.113549.1.9.4", aSN13.add(new ASN1(4, (byte[])object5)));
                    this.f.getAuthenticatedAttributes().addItem(aSN14);
                } else {
                    object3 = new RSAPKCS1SignatureFormatter(this.f.getKey());
                    ((RSAPKCS1SignatureFormatter)object3).setHashAlgorithm(this.b);
                    object2 = HashAlgorithm.create(this.b);
                    object5 = ((HashAlgorithm)object2).computeHash(((ASN1)object4).get_Item(1).get_Item(0).getValue());
                    this.f.setSignature(((RSAPKCS1SignatureFormatter)object3).createSignature((byte[])object5));
                }
                this.h = true;
            }
            if (this.d.size() > 0) {
                object3 = aSN1.add(new ASN1(-96));
                for (Object object5 : this.d) {
                    ((ASN1)object3).add(new ASN1(((X509Certificate)object5).getRawData()));
                }
            }
            if (this.e.size() > 0) {
                object3 = aSN1.add(new ASN1(-95));
                object2 = this.e.iterator();
                while (object2.hasNext()) {
                    object5 = (byte[])object2.next();
                    ((ASN1)object3).add(new ASN1((byte[])object5));
                }
            }
            object3 = aSN1.add(new ASN1(49));
            if (this.f.getKey() != null) {
                ((ASN1)object3).add(this.f.getASN1_Rename_Namesake());
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class RecipientInfo {
        private int a;
        private String b;
        private byte[] c;
        private byte[] d;
        private String e;
        private byte[] f;

        public RecipientInfo() {
        }

        public RecipientInfo(ASN1 data) {
            if (data.getTag() != 48) {
                throw new ArgumentException("Invalid RecipientInfo");
            }
            ASN1 aSN1 = data.get_Item(0);
            if (aSN1.getTag() != 2) {
                throw new ArgumentException("missing Version");
            }
            this.a = aSN1.getValue()[0] & 0xFF;
            ASN1 aSN12 = data.get_Item(1);
            if ((aSN12.getTag() & 0xFF) == 128 && this.a == 3) {
                this.d = aSN12.getValue();
            } else {
                this.e = h.a(aSN12.get_Item(0));
                this.f = aSN12.get_Item(1).getValue();
            }
            ASN1 aSN13 = data.get_Item(2);
            this.b = ASN1Convert.toOid(aSN13.get_Item(0));
            ASN1 aSN14 = data.get_Item(3);
            this.c = aSN14.getValue();
        }

        public String getOid() {
            return this.b;
        }

        public byte[] getKey() {
            if (this.c == null) {
                return null;
            }
            return (byte[])this.c.clone();
        }

        public byte[] getSubjectKeyIdentifier() {
            if (this.d == null) {
                return null;
            }
            return (byte[])this.d.clone();
        }

        public String getIssuer() {
            return this.e;
        }

        public byte[] getSerial() {
            if (this.f == null) {
                return null;
            }
            return (byte[])this.f.clone();
        }

        public int getVersion() {
            return this.a;
        }
    }

    public static class EnvelopedData {
        private byte a = 0;
        private ContentInfo b = new ContentInfo();
        private ContentInfo c = new ContentInfo();
        private ArrayList d = new ArrayList();
        private byte[] e;

        public EnvelopedData() {
        }

        public EnvelopedData(byte[] data) {
            this(new ASN1(data));
        }

        public EnvelopedData(ASN1 asn1) {
            this();
            ASN1 aSN1;
            if (asn1.get_Item(0).getTag() != 48 || asn1.get_Item(0).getCount() < 3) {
                throw new ArgumentException("Invalid EnvelopedData");
            }
            if (asn1.get_Item(0).get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = asn1.get_Item(0).get_Item(0).getValue()[0];
            ASN1 aSN12 = asn1.get_Item(0).get_Item(1);
            if (aSN12.getTag() != 49) {
                throw new ArgumentException("missing RecipientInfos");
            }
            for (int i2 = 0; i2 < aSN12.getCount(); ++i2) {
                aSN1 = aSN12.get_Item(i2);
                this.d.addItem(new RecipientInfo(aSN1));
            }
            ASN1 aSN13 = asn1.get_Item(0).get_Item(2);
            if (aSN13.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo");
            }
            aSN1 = aSN13.get_Item(0);
            if (aSN1.getTag() != 6) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentType");
            }
            this.b = new ContentInfo(ASN1Convert.toOid(aSN1));
            ASN1 aSN14 = aSN13.get_Item(1);
            if (aSN14.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentEncryptionAlgorithmIdentifier");
            }
            this.c = new ContentInfo(ASN1Convert.toOid(aSN14.get_Item(0)));
            this.c.setContent(aSN14.get_Item(1));
            ASN1 aSN15 = aSN13.get_Item(2);
            if ((aSN15.getTag() & 0xFF) != 128) {
                throw new ArgumentException("missing EncryptedContentInfo.EncryptedContent");
            }
            this.e = aSN15.getValue();
        }

        public ArrayList getRecipientInfos() {
            return this.d;
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ContentInfo getContentInfo() {
            return this.b;
        }

        public ContentInfo getEncryptionAlgorithm() {
            return this.c;
        }

        public byte[] getEncryptedContent() {
            if (this.e == null) {
                return null;
            }
            return (byte[])this.e.clone();
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte value) {
            this.a = value;
        }

        ASN1 a() {
            ASN1 aSN1 = new ASN1(48);
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class EncryptedData {
        private byte a = 0;
        private ContentInfo b;
        private ContentInfo c;
        private byte[] d;

        public EncryptedData() {
        }

        public EncryptedData(byte[] data) {
            this(new ASN1(data));
        }

        public EncryptedData(ASN1 asn1) {
            this();
            if (asn1.getTag() != 48 || asn1.getCount() < 2) {
                throw new ArgumentException("Invalid EncryptedData");
            }
            if (asn1.get_Item(0).getTag() != 2) {
                throw new ArgumentException("Invalid version");
            }
            this.a = asn1.get_Item(0).getValue()[0];
            ASN1 aSN1 = asn1.get_Item(1);
            if (aSN1.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo");
            }
            ASN1 aSN12 = aSN1.get_Item(0);
            if (aSN12.getTag() != 6) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentType");
            }
            this.b = new ContentInfo(ASN1Convert.toOid(aSN12));
            ASN1 aSN13 = aSN1.get_Item(1);
            if (aSN13.getTag() != 48) {
                throw new ArgumentException("missing EncryptedContentInfo.ContentEncryptionAlgorithmIdentifier");
            }
            this.c = new ContentInfo(ASN1Convert.toOid(aSN13.get_Item(0)));
            this.c.setContent(aSN13.get_Item(1));
            ASN1 aSN14 = aSN1.get_Item(2);
            if ((aSN14.getTag() & 0xFF) != 128) {
                throw new ArgumentException("missing EncryptedContentInfo.EncryptedContent");
            }
            this.d = aSN14.getValue();
        }

        public ASN1 getASN1_Rename_Namesake() {
            return this.a();
        }

        public ContentInfo getContentInfo() {
            return this.b;
        }

        public ContentInfo getEncryptionAlgorithm() {
            return this.c;
        }

        public byte[] getEncryptedContent() {
            if (this.d == null) {
                return null;
            }
            return (byte[])this.d.clone();
        }

        public byte getVersion() {
            return this.a;
        }

        public void setVersion(byte value) {
            this.a = value;
        }

        ASN1 a() {
            return null;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class ContentInfo {
        private String a;
        private ASN1 b;

        public ContentInfo() {
            this.b = new ASN1(-96);
        }

        public ContentInfo(String oid) {
            this();
            this.a = oid;
        }

        public ContentInfo(byte[] data) {
            this(new ASN1(data));
        }

        public ContentInfo(ASN1 asn1) {
            if (asn1.getTag() != 48 || asn1.getCount() < 1 && asn1.getCount() > 2) {
                throw new ArgumentException("Invalid ASN1");
            }
            if (asn1.get_Item(0).getTag() != 6) {
                throw new ArgumentException("Invalid contentType");
            }
            this.a = ASN1Convert.toOid(asn1.get_Item(0));
            if (asn1.getCount() > 1) {
                if ((asn1.get_Item(1).getTag() & 0xFF) != 160) {
                    throw new ArgumentException("Invalid content");
                }
                this.b = asn1.get_Item(1);
            }
        }

        public ASN1 get_ASN1() {
            return this.a();
        }

        public ASN1 getContent() {
            return this.b;
        }

        public void setContent(ASN1 value) {
            this.b = value;
        }

        public String getContentType() {
            return this.a;
        }

        public void setContentType(String value) {
            this.a = value;
        }

        ASN1 a() {
            ASN1 aSN1 = new ASN1(48);
            aSN1.add(ASN1Convert.fromOid(this.a));
            if (this.b != null && this.b.getCount() > 0) {
                aSN1.add(this.b);
            }
            return aSN1;
        }

        public byte[] getBytes() {
            return this.a().getBytes();
        }
    }

    public static class Oid {
        public static final String RSA_ENCRYPTION = "1.2.840.113549.1.1.1";
        public static final String DATA = "1.2.840.113549.1.7.1";
        public static final String SIGNED_DATA = "1.2.840.113549.1.7.2";
        public static final String ENVELOPED_DATA = "1.2.840.113549.1.7.3";
        public static final String SIGNED_AND_ENVELOPED_DATA = "1.2.840.113549.1.7.4";
        public static final String DIGESTED_DATA = "1.2.840.113549.1.7.5";
        public static final String ENCRYPTED_DATA = "1.2.840.113549.1.7.6";
        public static final String CONTENT_TYPE = "1.2.840.113549.1.9.3";
        public static final String MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
        public static final String SIGNING_TIME = "1.2.840.113549.1.9.5";
        public static final String COUNTERSIGNATURE = "1.2.840.113549.1.9.6";
    }
}

