/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.MD5;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSASslSignatureDeformatter;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSASslSignatureFormatter;

public class MD5SHA1
extends HashAlgorithm {
    private HashAlgorithm a = MD5.create();
    private HashAlgorithm c = SHA1.create();
    private boolean d;

    public MD5SHA1() {
        this.HashSizeValue = this.a.getHashSize() + this.c.getHashSize();
    }

    @Override
    public void initialize() {
        this.a.initialize();
        this.c.initialize();
        this.d = false;
    }

    @Override
    protected byte[] hashFinal() {
        if (!this.d) {
            this.d = true;
        }
        this.a.transformFinalBlock(new byte[0], 0, 0);
        this.c.transformFinalBlock(new byte[0], 0, 0);
        byte[] byArray = new byte[36];
        Buffer.blockCopy(Array.boxing(this.a.getHash()), 0, Array.boxing(byArray), 0, 16);
        Buffer.blockCopy(Array.boxing(this.c.getHash()), 0, Array.boxing(byArray), 16, 20);
        return byArray;
    }

    @Override
    protected void hashCore(byte[] array, int ibStart, int cbSize) {
        if (!this.d) {
            this.d = true;
        }
        this.a.transformBlock(array, ibStart, cbSize, array, ibStart);
        this.c.transformBlock(array, ibStart, cbSize, array, ibStart);
    }

    public byte[] createSignature(RSA rsa) {
        if (rsa == null) {
            throw new CryptographicUnexpectedOperationException("missing key");
        }
        RSASslSignatureFormatter rSASslSignatureFormatter = new RSASslSignatureFormatter(rsa);
        rSASslSignatureFormatter.setHashAlgorithm("MD5SHA1");
        return rSASslSignatureFormatter.createSignature(this.getHash());
    }

    public boolean verifySignature(RSA rsa, byte[] rgbSignature) {
        if (rsa == null) {
            throw new CryptographicUnexpectedOperationException("missing key");
        }
        if (rgbSignature == null) {
            throw new ArgumentNullException("rgbSignature");
        }
        RSASslSignatureDeformatter rSASslSignatureDeformatter = new RSASslSignatureDeformatter(rsa);
        rSASslSignatureDeformatter.setHashAlgorithm("MD5SHA1");
        return rSASslSignatureDeformatter.verifySignature(this.getHash(), rgbSignature);
    }
}

