/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSingle;

public class PngChunkPHYS
extends PngChunkSingle {
    public static final String ID = "pHYs";
    private long a;
    private long b;
    private int c;

    public PngChunkPHYS(ImageInfo info) {
        super(ID, info);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(9, true);
        PngHelperInternal.writeInt4tobytes((int)this.a, chunkRaw.data, 0);
        PngHelperInternal.writeInt4tobytes((int)this.b, chunkRaw.data, 4);
        chunkRaw.data[8] = (byte)this.c;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunk) {
        if (chunk.len != 9) {
            throw new PngjException("bad chunk length " + chunk);
        }
        this.a = PngHelperInternal.readInt4fromBytes(chunk.data, 0);
        if (this.a < 0L) {
            this.a += 0x100000000L;
        }
        this.b = PngHelperInternal.readInt4fromBytes(chunk.data, 4);
        if (this.b < 0L) {
            this.b += 0x100000000L;
        }
        this.c = PngHelperInternal.readInt1fromByte(chunk.data, 8);
    }

    @Override
    public void cloneDataFromRead(PngChunk other) {
        PngChunkPHYS pngChunkPHYS = (PngChunkPHYS)other;
        this.a = pngChunkPHYS.a;
        this.b = pngChunkPHYS.b;
        this.c = pngChunkPHYS.c;
    }

    public long getPixelsxUnitX() {
        return this.a;
    }

    public void setPixelsxUnitX(long pixelsxUnitX) {
        this.a = pixelsxUnitX;
    }

    public long getPixelsxUnitY() {
        return this.b;
    }

    public void setPixelsxUnitY(long pixelsxUnitY) {
        this.b = pixelsxUnitY;
    }

    public int getUnits() {
        return this.c;
    }

    public void setUnits(int units) {
        this.c = units;
    }

    public double getAsDpi() {
        if (this.c != 1 || this.a != this.b) {
            return -1.0;
        }
        return (double)this.a * 0.0254;
    }

    public double[] getAsDpi2() {
        if (this.c != 1) {
            return new double[]{-1.0, -1.0};
        }
        return new double[]{(double)this.a * 0.0254, (double)this.b * 0.0254};
    }

    public void setAsDpi(double dpi) {
        this.c = 1;
        this.b = this.a = (long)(dpi / 0.0254 + 0.5);
    }

    public void setAsDpi2(double dpix, double dpiy) {
        this.c = 1;
        this.a = (long)(dpix / 0.0254 + 0.5);
        this.b = (long)(dpiy / 0.0254 + 0.5);
    }
}

