/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkRaw;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkBKGD;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkCHRM;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkFactoryMethod;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkGAMA;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkHIST;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkICCP;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIDAT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIEND;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIHDR;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkITXT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkOFFS;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPHYS;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkPLTE;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSBIT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSPLT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSRGB;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSTER;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTEXT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTIME;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTRNS;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkUNKNOWN;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkZTXT;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageOutputStream;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    private boolean a = false;
    protected int chunkGroup = -1;
    protected int length = -1;
    protected long offset = 0L;
    private static final Map<String, PngChunkFactoryMethod> b = new HashMap<String, PngChunkFactoryMethod>();

    static void factoryRegister(String chunkId, PngChunkFactoryMethod fm2) {
        b.put(chunkId, fm2);
    }

    public static boolean isKnown(String id2) {
        return b.containsKey(id2);
    }

    protected PngChunk(String id2, ImageInfo imgInfo) {
        this.id = id2;
        this.imgInfo = imgInfo;
        this.crit = ChunkHelper.isCritical(id2);
        this.pub = ChunkHelper.isPublic(id2);
        this.safe = ChunkHelper.isSafeToCopy(id2);
    }

    public static PngChunk factory(ChunkRaw chunk, ImageInfo info) {
        PngChunk pngChunk = PngChunk.factoryFromId(ChunkHelper.toString(chunk.idbytes), info);
        pngChunk.length = chunk.len;
        pngChunk.parseFromRaw(chunk);
        return pngChunk;
    }

    public static PngChunk factoryFromId(String cid, ImageInfo info) {
        PngChunk pngChunk = null;
        try {
            PngChunkFactoryMethod pngChunkFactoryMethod = b.get(cid);
            if (pngChunkFactoryMethod != null) {
                pngChunk = pngChunkFactoryMethod.create(info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pngChunk == null) {
            pngChunk = new PngChunkUNKNOWN(cid, info);
        }
        return pngChunk;
    }

    protected final ChunkRaw createEmptyChunk(int len, boolean alloc) {
        ChunkRaw chunkRaw = new ChunkRaw(len, ChunkHelper.toBytes(this.id), alloc);
        return chunkRaw;
    }

    public static <T extends PngChunk> T cloneChunk(T chunk, ImageInfo info) {
        PngChunk pngChunk = PngChunk.factoryFromId(chunk.id, info);
        if (pngChunk.getClass() != chunk.getClass()) {
            throw new PngjExceptionInternal("bad class cloning chunk: " + pngChunk.getClass() + " " + chunk.getClass());
        }
        pngChunk.cloneDataFromRead(chunk);
        return (T)pngChunk;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    public final void setChunkGroup(int chunkGroup) {
        this.chunkGroup = chunkGroup;
    }

    public boolean hasPriority() {
        return this.a;
    }

    public void setPriority(boolean priority) {
        this.a = priority;
    }

    final void write(ImageOutputStream os) {
        ChunkRaw chunkRaw = this.createRawChunk();
        if (chunkRaw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        chunkRaw.writeChunk(os);
    }

    public int getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public abstract ChunkRaw createRawChunk();

    public abstract void parseFromRaw(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public abstract boolean allowsMultiple();

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.length + " offset=" + this.offset + ") c=" + this.getClass().getSimpleName();
    }

    static {
        PngChunk.factoryRegister("IDAT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkIDAT(info);
            }
        });
        PngChunk.factoryRegister("IHDR", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkIHDR(info);
            }
        });
        PngChunk.factoryRegister("PLTE", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkPLTE(info);
            }
        });
        PngChunk.factoryRegister("IEND", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkIEND(info);
            }
        });
        PngChunk.factoryRegister("tEXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkTEXT(info);
            }
        });
        PngChunk.factoryRegister("iTXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkITXT(info);
            }
        });
        PngChunk.factoryRegister("zTXt", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkZTXT(info);
            }
        });
        PngChunk.factoryRegister("bKGD", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkBKGD(info);
            }
        });
        PngChunk.factoryRegister("gAMA", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkGAMA(info);
            }
        });
        PngChunk.factoryRegister("pHYs", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkPHYS(info);
            }
        });
        PngChunk.factoryRegister("iCCP", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkICCP(info);
            }
        });
        PngChunk.factoryRegister("tIME", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkTIME(info);
            }
        });
        PngChunk.factoryRegister("tRNS", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkTRNS(info);
            }
        });
        PngChunk.factoryRegister("cHRM", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkCHRM(info);
            }
        });
        PngChunk.factoryRegister("sBIT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkSBIT(info);
            }
        });
        PngChunk.factoryRegister("sRGB", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkSRGB(info);
            }
        });
        PngChunk.factoryRegister("hIST", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkHIST(info);
            }
        });
        PngChunk.factoryRegister("sPLT", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkSPLT(info);
            }
        });
        PngChunk.factoryRegister("oFFs", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkOFFS(info);
            }
        });
        PngChunk.factoryRegister("sTER", new PngChunkFactoryMethod(){

            @Override
            public PngChunk create(ImageInfo info) {
                return new PngChunkSTER(info);
            }
        });
    }

    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        BEFORE_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT;
        }
    }
}

