/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.FilterType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLineHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;

public class ImageLine {
    public final ImageInfo imgInfo;
    private int a = 0;
    public final int[] scanline;
    public final byte[] scanlineb;
    protected FilterType filterUsed;
    final int channels;
    final int bitDepth;
    final int elementsPerRow;
    public final SampleType sampleType;
    public final boolean samplesUnpacked;

    public ImageLine(ImageInfo imgInfo) {
        this(imgInfo, SampleType.INT, false);
    }

    public ImageLine(ImageInfo imgInfo, SampleType stype, boolean unpackedMode) {
        this(imgInfo, stype, unpackedMode, null, null);
    }

    ImageLine(ImageInfo imgInfo, SampleType stype, boolean unpackedMode, int[] sci, byte[] scb) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.bitDepth = imgInfo.bitDepth;
        this.filterUsed = FilterType.FILTER_UNKNOWN;
        this.sampleType = stype;
        this.samplesUnpacked = unpackedMode || !imgInfo.packed;
        int n2 = this.elementsPerRow = this.samplesUnpacked ? imgInfo.samplesPerRow : imgInfo.samplesPerRowPacked;
        if (stype == SampleType.INT) {
            this.scanline = sci != null ? sci : new int[this.elementsPerRow];
            this.scanlineb = null;
        } else if (stype == SampleType.BYTE) {
            this.scanlineb = scb != null ? scb : new byte[this.elementsPerRow];
            this.scanline = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
        this.a = -1;
    }

    public int getRown() {
        return this.a;
    }

    public void setRown(int n2) {
        this.a = n2;
    }

    static void unpackInplaceInt(ImageInfo iminfo, int[] src, int[] dst, boolean scale) {
        int n2;
        int n3;
        int n4 = iminfo.bitDepth;
        if (n4 >= 8) {
            return;
        }
        int n5 = ImageLineHelper.getMaskForPackedFormatsLs(n4);
        int n6 = 8 - n4;
        int n7 = 8 * iminfo.samplesPerRowPacked - n4 * iminfo.samplesPerRow;
        if (n7 != 8) {
            n3 = n5 << n7;
            n2 = n7;
        } else {
            n3 = n5;
            n2 = 0;
        }
        int n8 = iminfo.samplesPerRowPacked - 1;
        for (int i2 = iminfo.samplesPerRow - 1; i2 >= 0; --i2) {
            int n9 = (src[n8] & n3) >> n2;
            if (scale) {
                n9 <<= n6;
            }
            dst[i2] = n9;
            n3 <<= n4;
            if ((n2 += n4) != 8) continue;
            n3 = n5;
            n2 = 0;
            --n8;
        }
    }

    static void packInplaceInt(ImageInfo iminfo, int[] src, int[] dst, boolean scaled) {
        int n2 = iminfo.bitDepth;
        if (n2 >= 8) {
            return;
        }
        int n3 = ImageLineHelper.getMaskForPackedFormatsLs(n2);
        int n4 = 8 - n2;
        int n5 = 8 - n2;
        int n6 = 8 - n2;
        int n7 = src[0];
        dst[0] = 0;
        if (scaled) {
            n7 >>= n4;
        }
        n7 = (n7 & n3) << n6;
        int n8 = 0;
        for (int i2 = 0; i2 < iminfo.samplesPerRow; ++i2) {
            int n9 = src[i2];
            if (scaled) {
                n9 >>= n4;
            }
            int n10 = n8++;
            dst[n10] = dst[n10] | (n9 & n3) << n6;
            if ((n6 -= n2) >= 0) continue;
            n6 = n5;
            if (n8 >= dst.length) continue;
            dst[n8] = 0;
        }
        dst[0] = dst[0] | n7;
    }

    static void unpackInplaceByte(ImageInfo iminfo, byte[] src, byte[] dst, boolean scale) {
        int n2;
        int n3;
        int n4 = iminfo.bitDepth;
        if (n4 >= 8) {
            return;
        }
        int n5 = ImageLineHelper.getMaskForPackedFormatsLs(n4);
        int n6 = 8 - n4;
        int n7 = 8 * iminfo.samplesPerRowPacked - n4 * iminfo.samplesPerRow;
        if (n7 != 8) {
            n3 = n5 << n7;
            n2 = n7;
        } else {
            n3 = n5;
            n2 = 0;
        }
        int n8 = iminfo.samplesPerRowPacked - 1;
        for (int i2 = iminfo.samplesPerRow - 1; i2 >= 0; --i2) {
            int n9 = (src[n8] & n3) >> n2;
            if (scale) {
                n9 <<= n6;
            }
            dst[i2] = (byte)n9;
            n3 <<= n4;
            if ((n2 += n4) != 8) continue;
            n3 = n5;
            n2 = 0;
            --n8;
        }
    }

    static void packInplaceByte(ImageInfo iminfo, byte[] src, byte[] dst, boolean scaled) {
        int n2 = iminfo.bitDepth;
        if (n2 >= 8) {
            return;
        }
        int n3 = ImageLineHelper.getMaskForPackedFormatsLs(n2);
        int n4 = 8 - n2;
        int n5 = 8 - n2;
        int n6 = 8 - n2;
        int n7 = src[0];
        dst[0] = 0;
        if (scaled) {
            n7 >>= n4;
        }
        n7 = (n7 & n3) << n6;
        int n8 = 0;
        for (int i2 = 0; i2 < iminfo.samplesPerRow; ++i2) {
            int n9 = src[i2];
            if (scaled) {
                n9 >>= n4;
            }
            int n10 = n8++;
            dst[n10] = (byte)(dst[n10] | (n9 & n3) << n6);
            if ((n6 -= n2) >= 0) continue;
            n6 = n5;
            if (n8 >= dst.length) continue;
            dst[n8] = 0;
        }
        dst[0] = (byte)(dst[0] | n7);
    }

    public ImageLine unpackToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, true);
        if (this.sampleType == SampleType.INT) {
            ImageLine.unpackInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.unpackInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public ImageLine packToNewImageLine() {
        ImageLine imageLine = new ImageLine(this.imgInfo, this.sampleType, false);
        if (this.sampleType == SampleType.INT) {
            ImageLine.packInplaceInt(this.imgInfo, this.scanline, imageLine.scanline, false);
        } else {
            ImageLine.packInplaceByte(this.imgInfo, this.scanlineb, imageLine.scanlineb, false);
        }
        return imageLine;
    }

    public FilterType getFilterUsed() {
        return this.filterUsed;
    }

    public void setFilterUsed(FilterType ft2) {
        this.filterUsed = ft2;
    }

    public int[] getScanlineInt() {
        return this.scanline;
    }

    public byte[] getScanlineByte() {
        return this.scanlineb;
    }

    public String toString() {
        return "row=" + this.a + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + (this.scanline != null ? this.scanline.length : 0);
    }

    public static void showLineInfo(ImageLine line) {
    }

    public static enum SampleType {
        INT,
        BYTE;

    }
}

