/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjException;

public class ImageInfo {
    private static final int a = 1000000;
    public final int cols;
    public final int rows;
    public final int bitDepth;
    public final int channels;
    public final boolean alpha;
    public final boolean greyscale;
    public final boolean indexed;
    public final boolean packed;
    public final int bitspPixel;
    public final int bytesPixel;
    public final int bytesPerRow;
    public final int samplesPerRow;
    public final int samplesPerRowPacked;

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha) {
        this(cols, rows, bitdepth, alpha, false, false);
    }

    public ImageInfo(int cols, int rows, int bitdepth, boolean alpha, boolean grayscale, boolean indexed) {
        this.cols = cols;
        this.rows = rows;
        this.alpha = alpha;
        this.indexed = indexed;
        this.greyscale = grayscale;
        if (this.greyscale && indexed) {
            throw new PngjException("palette and greyscale are mutually exclusive");
        }
        this.channels = grayscale || indexed ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
        this.bitDepth = bitdepth;
        this.packed = bitdepth < 8;
        this.bitspPixel = this.channels * this.bitDepth;
        this.bytesPixel = (this.bitspPixel + 7) / 8;
        this.bytesPerRow = (this.bitspPixel * cols + 7) / 8;
        this.samplesPerRow = this.channels * this.cols;
        this.samplesPerRowPacked = this.packed ? this.bytesPerRow : this.samplesPerRow;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (cols < 1 || cols > 1000000) {
            throw new PngjException("invalid cols=" + cols + " ???");
        }
        if (rows < 1 || rows > 1000000) {
            throw new PngjException("invalid rows=" + rows + " ???");
        }
    }

    public String toString() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", bitspPixel=" + this.bitspPixel + ", bytesPixel=" + this.bytesPixel + ", bytesPerRow=" + this.bytesPerRow + ", samplesPerRow=" + this.samplesPerRow + ", samplesPerRowP=" + this.samplesPerRowPacked + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + ", packed=" + this.packed + "]";
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.alpha ? 1231 : 1237);
        n3 = 31 * n3 + this.bitDepth;
        n3 = 31 * n3 + this.channels;
        n3 = 31 * n3 + this.cols;
        n3 = 31 * n3 + (this.greyscale ? 1231 : 1237);
        n3 = 31 * n3 + (this.indexed ? 1231 : 1237);
        n3 = 31 * n3 + this.rows;
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)obj;
        if (this.alpha != imageInfo.alpha) {
            return false;
        }
        if (this.bitDepth != imageInfo.bitDepth) {
            return false;
        }
        if (this.channels != imageInfo.channels) {
            return false;
        }
        if (this.cols != imageInfo.cols) {
            return false;
        }
        if (this.greyscale != imageInfo.greyscale) {
            return false;
        }
        if (this.indexed != imageInfo.indexed) {
            return false;
        }
        return this.rows == imageInfo.rows;
    }
}

