/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png;

import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.c;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.AwtUtils;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ResolutionSetting;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.png.PngImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.PngOptions;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class AsposePngImageWriter
extends ImageWriter {
    private Stream a = null;
    private int b;
    private int c;
    private float d;
    private float e;

    public AsposePngImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setOutput(Object output) {
        if (output instanceof Stream) {
            this.a = (Stream)output;
        } else if (output != null) {
            throw new IllegalArgumentException("Illegal output type!");
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        Object object;
        if (this.a == null) {
            throw new InvalidOperationException("output == null!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        BufferedImage bufferedImage = (BufferedImage)image.getRenderedImage();
        this.c = (Integer)(bufferedImage.getProperty("bitspPixel").equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(bufferedImage.getColorModel().getPixelSize()) : bufferedImage.getProperty("bitspPixel"));
        this.b = (Integer)(bufferedImage.getProperty("pixelFormat").equals(BufferedImage.UndefinedProperty) ? Integer.valueOf(139273) : bufferedImage.getProperty("pixelFormat"));
        Object object2 = bufferedImage.getProperty("dpiX");
        if (object2 != BufferedImage.UndefinedProperty) {
            this.d = ((Float)object2).floatValue();
        }
        if ((object = bufferedImage.getProperty("dpiY")) != BufferedImage.UndefinedProperty) {
            this.e = ((Float)object).floatValue();
        }
        if (this.c == 48 || this.c == 64) {
            this.a(streamMetadata, image, param);
            return;
        }
        bufferedImage = this.a(bufferedImage);
        this.a(bufferedImage, image.getMetadata());
    }

    private void a(BufferedImage bufferedImage, IIOMetadata iIOMetadata) {
        PngImage pngImage = new PngImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        PngOptions pngOptions = this.b(bufferedImage, iIOMetadata);
        pngImage.setPalette(pngOptions.getPalette());
        pngImage.setTransparentColor(bufferedImage.getColorModel().hasAlpha());
        pngImage.saveArgb32Pixels(pngImage.getBounds(), AwtUtils.getColors(bufferedImage));
        PngImage.savePng(this.a, pngImage, pngOptions);
    }

    private PngOptions b(BufferedImage bufferedImage, IIOMetadata iIOMetadata) {
        Object object;
        PngOptions pngOptions = new PngOptions();
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            pngOptions.setColorType(3);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getPixelSize());
            object = (IndexColorModel)bufferedImage.getColorModel();
            int[] nArray = new int[((IndexColorModel)object).getMapSize()];
            ((IndexColorModel)object).getRGBs(nArray);
            pngOptions.setPalette(new ColorPalette(nArray));
        } else if (!bufferedImage.getColorModel().hasAlpha()) {
            pngOptions.setColorType(2);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getComponentSize(0));
        } else {
            pngOptions.setColorType(6);
            pngOptions.setBitDepth((byte)bufferedImage.getColorModel().getComponentSize(0));
        }
        object = new ResolutionSetting();
        ((ResolutionSetting)object).setHorizontalResolution(this.d);
        ((ResolutionSetting)object).setVerticalResolution(this.e);
        if (((ResolutionSetting)object).getHorizontalResolution() != 0.0 || ((ResolutionSetting)object).getVerticalResolution() != 0.0) {
            pngOptions.setResolutionSettings((ResolutionSetting)object);
        }
        return pngOptions;
    }

    private BufferedImage a(BufferedImage bufferedImage) {
        if (this.b(bufferedImage)) {
            return com.aspose.html.internal.ms.core.System.Drawing.Imaging.c.c(bufferedImage);
        }
        return bufferedImage;
    }

    private boolean b(BufferedImage bufferedImage) {
        return this.c == 16 || this.c == 32 && bufferedImage.getColorModel().getNumColorComponents() == 3 && this.b == 139273 || this.b == 8207;
    }

    private void a(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.a.toOutputStream());
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("PNG").next();
        imageWriter.setOutput(memoryCacheImageOutputStream);
        imageWriter.write(iIOMetadata, iIOImage, imageWriteParam);
        memoryCacheImageOutputStream.flush();
    }
}

