/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.html.internal.ms.lang.Operators;

public final class TiffFloatType
extends TiffCommonArrayType {
    private float[] a;

    public TiffFloatType(int tagId) {
        super(tagId);
    }

    public float[] getValues() {
        return this.a;
    }

    public void setValues(float[] value) {
        this.a = value;
    }

    @Override
    public long getElementSize() {
        return 4L;
    }

    @Override
    public Array getValuesContainer() {
        return Array.boxing(this.a);
    }

    @Override
    public int getTagType() {
        return 11;
    }

    @Override
    public Object getValue() {
        return this.a;
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !Operators.is(value, float[].class)) {
            throw new ArgumentException("Only float array is supported.");
        }
        this.a = Operators.as(value, float[].class);
    }

    @Override
    public long writeAdditionalData(TiffStream dataStream) {
        if (dataStream == null) {
            throw new ArgumentNullException("dataStream");
        }
        long l2 = 0L;
        if (this.a != null && this.a.length > 1) {
            dataStream.writeFloatArray(this.a);
            l2 = Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.a.length, 9), 10) * 4L, 10);
        }
        return l2;
    }

    @Override
    protected void readData(TiffStream dataStream, long count) {
        if (Operators.castToUInt32(count, 10) == 1L) {
            this.a = dataStream.readFloatArrayInt32(1);
        } else {
            long l2 = dataStream.readULong();
            dataStream.seek(Operators.castToInt64(l2, 10), 0);
            this.a = dataStream.readFloatArrayUInt32(count);
        }
    }

    @Override
    protected TiffDataType createInstance() {
        return new TiffFloatType(this.getTagId());
    }

    @Override
    protected void copyInstanceData(TiffDataType clonedType) {
        ((TiffFloatType)clonedType).a = ArrayHelper.copySingle(this.a);
        super.copyInstanceData(clonedType);
    }

    @Override
    protected void writeTagValue(TiffStream dataStream) {
        dataStream.writeFloatArray(this.a);
        dataStream.write(new byte[4 - this.a.length * 4]);
    }
}

