/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringMode;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.ExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffTagsSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class TiffImage
extends RasterImage {
    private final List<TiffFrame> a = new List();
    private int b = 18761;
    private TiffFrame c;

    public TiffImage(TiffFrame frame) {
        if (frame == null) {
            throw new ArgumentNullException("frame");
        }
        this.addFrame(frame);
        this.b = frame.getFrameOptions().getByteOrder();
        this.setActiveFrame(frame);
        this.setDataLoader(new TiffActiveFrameLoader(this));
    }

    public TiffImage(TiffFrame[] frames) {
        if (frames == null) {
            throw new ArgumentNullException("frames");
        }
        if (frames.length > 0) {
            this.addFrames(frames);
            this.setActiveFrame(frames[0]);
            this.b = this.getActiveFrame().getFrameOptions().getByteOrder();
        }
        this.setDataLoader(new TiffActiveFrameLoader(this));
    }

    public int getByteOrder() {
        this.verifyNotDisposed();
        return this.b;
    }

    public void setByteOrder(int value) {
        this.verifyNotDisposed();
        this.b = value;
    }

    @Override
    public double getHorizontalResolution() {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            return super.getHorizontalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getXresolution().getValue();
    }

    @Override
    public void setHorizontalResolution(double value) {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            this.setResolution(value, super.getVerticalResolution());
        } else {
            this.setResolution(value, this.getActiveFrame().getFrameOptions().getYresolution().getValue());
        }
    }

    @Override
    public DitheringMode getDitheringSettings() {
        return this.c.getDitheringSettings();
    }

    @Override
    public void setDitheringSettings(DitheringMode value) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.get_Item(i2).setDitheringSettings(value);
        }
    }

    @Override
    public double getVerticalResolution() {
        if (this.getActiveFrame().getFrameOptions().getYresolution() == null) {
            return super.getVerticalResolution();
        }
        return this.getActiveFrame().getFrameOptions().getYresolution().getValue();
    }

    @Override
    public void setVerticalResolution(double value) {
        if (this.getActiveFrame().getFrameOptions().getXresolution() == null) {
            this.setResolution(super.getHorizontalResolution(), value);
        } else {
            this.setResolution(this.getActiveFrame().getFrameOptions().getXresolution().getValue(), value);
        }
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getBitsPerPixel();
    }

    public TiffFrame getActiveFrame() {
        this.verifyNotDisposed();
        if (this.c == null) {
            throw new InvalidOperationException("TiffImageException: There is no active frame selected.");
        }
        return this.c;
    }

    public void setActiveFrame(TiffFrame value) {
        this.verifyNotDisposed();
        if (value != null && value.getContainer() != this) {
            throw new InvalidOperationException("TiffImageException: The active frame cannot be set as it belongs to another image.");
        }
        this.c = value;
    }

    public TiffFrame[] getFrames() {
        this.verifyNotDisposed();
        TiffFrame[] tiffFrameArray = new TiffFrame[this.a.size()];
        this.a.copyToTArray((TiffFrame[])tiffFrameArray, 0);
        return tiffFrameArray;
    }

    @Override
    public int getHeight() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getHeight();
    }

    @Override
    public int getWidth() {
        this.verifyNotDisposed();
        return this.getActiveFrame().getWidth();
    }

    @Override
    public final boolean isCached() {
        TiffFrame[] tiffFrameArray = this.getFrames();
        boolean bl2 = true;
        for (int i2 = 0; i2 < tiffFrameArray.length && (bl2 = tiffFrameArray[i2].isCached()); ++i2) {
        }
        return bl2;
    }

    public ExifData getExifData() {
        return this.c.getExifData();
    }

    public void setExifData(ExifData value) {
        this.c.setExifData(value);
    }

    @Override
    public void setResolution(double dpiX, double dpiY) {
        this.getActiveFrame().getFrameOptions().setXresolution(new TiffRational(Convert.toUInt32(dpiX)));
        this.getActiveFrame().getFrameOptions().setYresolution(new TiffRational(Convert.toUInt32(dpiY)));
    }

    @Override
    public final void cacheData() {
        TiffFrame[] tiffFrameArray = this.getFrames();
        for (int i2 = 0; i2 < tiffFrameArray.length; ++i2) {
            tiffFrameArray[i2].cacheData();
        }
    }

    @Override
    public void rotateFlip(int rotateFlipType) {
        this.getActiveFrame().rotateFlip(rotateFlipType);
    }

    public void rotateFlipAll(int rotateFlip) {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.rotateFlip(rotateFlip);
        }
    }

    @Override
    public void rotate(float angle, boolean resizeProportionally, int backgroundColor) {
        for (TiffFrame tiffFrame : this.getFrames()) {
            tiffFrame.rotate(angle, resizeProportionally, backgroundColor);
        }
    }

    public void addFrame(TiffFrame frame) {
        this.verifyNotDisposed();
        if (frame.getContainer() != null && frame.getContainer() != this) {
            throw new InvalidOperationException("TiffImageException: Frame belongs to other image");
        }
        frame.setContainer(this);
        this.a.addItem(frame);
    }

    public void add(TiffImage image) {
        int n2 = image.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TiffFrame tiffFrame = image.a.get_Item(i2);
            if (tiffFrame == null) continue;
            TiffFrame tiffFrame2 = TiffFrame.copyFrame(tiffFrame);
            this.addFrame(tiffFrame2);
        }
    }

    public void addFrames(TiffFrame[] frames) {
        this.verifyNotDisposed();
        if (frames == null) {
            throw new ArgumentNullException("TiffImageException: Frames parameter is null");
        }
        for (int i2 = 0; i2 < frames.length; ++i2) {
            if (frames[i2] == null) {
                throw new ArgumentNullException("TiffImageException: Frame is null or not TiffFrame type");
            }
            if (frames[i2].getContainer() == this || frames[i2].getContainer() == null) continue;
            throw new ArgumentException("TiffImageException: Frame belongs to other image");
        }
        for (TiffFrame tiffFrame : frames) {
            tiffFrame.setContainer(this);
        }
        this.a.addRange(Array.toGenericList(frames));
    }

    public void insertFrame(int index, TiffFrame frameToInsert) {
        this.verifyNotDisposed();
        if (frameToInsert == null) {
            throw new ArgumentNullException("TiffImageException: Frame Is NULL");
        }
        if (frameToInsert.getContainer() != this && frameToInsert.getContainer() != null) {
            throw new ArgumentException("TiffImageException: Frame belongs to other image");
        }
        if (this.a.size() <= index || index < 0) {
            throw new ArgumentException("TiffImageException: Invalid index or Frame is null");
        }
        this.a.insertItem(index, frameToInsert);
    }

    public TiffFrame removeFrame(int index) {
        TiffFrame tiffFrame;
        this.verifyNotDisposed();
        if (index >= 0 && index < this.a.size()) {
            tiffFrame = this.a.get_Item(index);
            if (this.getActiveFrame() == tiffFrame) {
                throw new InvalidOperationException("TiffImageException: Unable to remove current frame");
            }
            if (this.a.size() <= 1) {
                throw new InvalidOperationException("TiffImageException: Unable to remove last frame");
            }
        } else {
            throw new ArgumentException("TiffImageException: Invalid index");
        }
        this.a.removeAt(index);
        return tiffFrame;
    }

    public void removeFrame(TiffFrame frame) {
        this.verifyNotDisposed();
        if (frame == null) {
            throw new ArgumentNullException("frame");
        }
        if (frame.getContainer() != this) {
            throw new ArgumentOutOfRangeException("frame", "The frame does not belong to the current TIFF image.");
        }
        if (this.getActiveFrame() == frame) {
            throw new InvalidOperationException("TiffImageException: Unable to remove current frame");
        }
        if (this.a.size() <= 1) {
            throw new InvalidOperationException("TiffImageException: Unable to remove last frame");
        }
        this.a.removeItem(frame);
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
            tiffFrame.resize(newWidth, newHeight, resizeType);
        }
    }

    public void resizeWidthProportionally(int newWidth, int resizeType) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
        }
    }

    public void resizeHeightProportionally(int newHeight, int resizeType) {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
        }
    }

    public void resizeProportional(int newWidth, int newHeight, int resizeType) {
        double d2 = Operators.castToDouble(newWidth, 9) / (double)this.getWidth();
        double d3 = Operators.castToDouble(newHeight, 9) / (double)this.getHeight();
        for (TiffFrame tiffFrame : this.a) {
            int n2 = Operators.castToInt32(d2 * (double)tiffFrame.getWidth() + 0.5, 14);
            int n3 = Operators.castToInt32(d3 * (double)tiffFrame.getHeight() + 0.5, 14);
            tiffFrame.resize(n2, n3, resizeType);
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            try {
                this.a.get_Item(i2).crop(rectangle.Clone());
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidOperationException(StringExtensions.concat("ImageException: Can't crop image. Frame index: ", Int32Extensions.toString(i2)), runtimeException);
            }
        }
    }

    @Override
    public void crop(int leftShift, int rightShift, int topShift, int bottomShift) {
        this.verifyNotDisposed();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            try {
                this.a.get_Item(i2).crop(leftShift, rightShift, topShift, bottomShift);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidOperationException(StringExtensions.concat("ImageException: Can't crop image. Frame index: ", Int32Extensions.toString(i2)), runtimeException);
            }
        }
    }

    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        TiffStream tiffStream = TiffStreamFactory.getTiffStream(stream, this.b);
        this.a(tiffStream);
    }

    @Override
    protected void releaseManagedResources() {
        this.verifyNotDisposed();
        for (TiffFrame tiffFrame : this.a) {
            tiffFrame.dispose();
        }
        this.a.clear();
        this.c = null;
        super.releaseManagedResources();
    }

    @Override
    protected void savePixelsInternal(Rectangle rectangle, int[] pixels) {
        this.verifyNotDisposed();
        this.getActiveFrame().saveArgb32Pixels(rectangle.Clone(), pixels);
    }

    private void a(TiffStream tiffStream) {
        this.verifyNotDisposed();
        tiffStream.getStream().seek(0L, 0);
        TiffTagsSaver.writeTiffHeader(tiffStream);
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            TiffFrame tiffFrame = this.a.get_Item(i2);
            TiffFrame.save(tiffFrame, tiffStream, i2 == this.a.size() - 1, tiffFrame.getFrameOptions(), tiffFrame.getExifData());
        }
    }

    private static class TiffActiveFrameLoader
    implements IRasterImageArgb32PixelLoader {
        private final TiffImage a;

        public TiffActiveFrameLoader(TiffImage tiffImage) {
            this.a = tiffImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return this.a.c.isRawDataAvailable();
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            return this.a.c.getRawDataSettings();
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialLoader) {
            this.a.verifyNotDisposed();
            this.a.getActiveFrame().loadPartialArgb32Pixels(rectangle.Clone(), partialLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
            this.a.verifyNotDisposed();
            this.a.c.loadRawData(rectangle.Clone(), rawDataSettings, rawDataLoader);
        }
    }
}

