/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.DataBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegComponentInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegEncoderState;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegMCU;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegScan;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.QTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.DefaultCMYKTables;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.DefaultTables;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.DefaultYcckTables;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegConstants;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.constants.JpegUtils;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.dct.ForwardDCT;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.HuffmanEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.JpegEntropyEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.entropycoder.ProgressiveHuffmanEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.samplers.DownSampler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;

public class JpegEncodingController {
    private short[][] a;
    private Rectangle b = new Rectangle();
    private ForwardDCT c;
    private DownSampler d;
    private JpegEntropyEncoder e;
    private boolean f;
    private JpegOptions g;
    private JpegEncoderState h;
    private int i;

    public JpegEncodingController(Rectangle bounds, JpegOptions jpegOptions, JpegStream stream, PixelDataFormat pixelDataFormat) {
        this(bounds.Clone(), jpegOptions, pixelDataFormat);
        this.h.setRawDataWriter(new JpegRawDataWriter(stream));
    }

    public JpegEncodingController(Rectangle bounds, JpegOptions jpegOptions, PixelDataFormat pixelDataFormat) {
        bounds.CloneTo(this.b);
        this.initialize(jpegOptions);
        this.setPixels(new short[pixelDataFormat.getChannelsCount()][]);
        try {
            for (int i2 = 0; i2 < pixelDataFormat.getChannelsCount(); ++i2) {
                this.getPixels()[i2] = new short[this.getState().getHeightInBlocks() * this.getState().getWidthInBlocks() * JpegConstants.BlockSize2];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryException("FrameworkException: Not enough memory to process jpeg file.", outOfMemoryError);
        }
    }

    public JpegEncoderState getState() {
        return this.h;
    }

    public void setState(JpegEncoderState value) {
        this.h = value;
    }

    public short[][] getPixels() {
        return this.a;
    }

    public void setPixels(short[][] value) {
        this.a = value;
    }

    public Rectangle getRectangle() {
        return this.b;
    }

    public void setRectangle(Rectangle value) {
        value.CloneTo(this.b);
    }

    public void encode(JpegStream resultStream) {
        this.h.currentScanIdx = 0;
        while (this.h.currentScanIdx < this.h.getScans().size()) {
            this.s();
            this.c.initialize();
            this.e.initialize();
            boolean bl2 = this.h.getCurrentScan().Components.length != 1;
            JpegScan.write(resultStream, this.getState().getJpegFrame(), this.getState().getScans().get_Item(this.h.currentScanIdx));
            int n2 = bl2 ? this.i : JpegUtils.divRoundUp(this.h.getJpegFrame().getY() & 0xFFFF, JpegConstants.BlockSize);
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < this.h.getJpegFrame().getMcusInRow(); ++i3) {
                    JpegMCU jpegMCU = bl2 ? this.a(i3, i2) : this.b(i3, i2);
                    DataBlock[] dataBlockArray = this.c.forwardDCT(jpegMCU);
                    this.e.encodeMCU(dataBlockArray);
                }
            }
            this.e.finishPass();
            ++this.h.currentScanIdx;
        }
        this.d();
    }

    public void initialize(JpegOptions compressionOptions) {
        this.g = compressionOptions;
        this.setState(new JpegEncoderState());
        this.h.setJpegOptions(this.g);
        this.c = new ForwardDCT(this.getState());
        block0 : switch (compressionOptions.getColorType()) {
            case 0: {
                this.q();
                this.f = false;
                switch (this.g.getCompressionType()) {
                    case 0: {
                        this.e = new HuffmanEncoder(this.getState());
                        this.h.setJpegFrame(new JpegFrame(-64, new JpegComponentInfo[1]));
                        this.f = false;
                        this.h.getJpegFrame().getComponentInfos()[0] = new JpegComponentInfo(1, 2, 2, 0, 0, 0);
                        this.h.setScans(new List<JpegScan>());
                        this.h.getScans().addItem(new JpegScan());
                        this.h.getScans().get_Item((int)0).Components = new int[]{0};
                        this.k();
                        break block0;
                    }
                    case 1: {
                        throw new NotImplementedException();
                    }
                }
                throw new ArgumentOutOfRangeException("CompressionType");
            }
            case 1: {
                this.q();
                this.f = false;
                switch (this.g.getCompressionType()) {
                    case 0: {
                        this.e = new HuffmanEncoder(this.getState());
                        this.h.setJpegFrame(new JpegFrame(-64, JpegEncodingController.c()));
                        this.f = false;
                        this.h.setScans(this.l());
                        this.k();
                        break block0;
                    }
                    case 1: {
                        this.e = new ProgressiveHuffmanEncoder(this.getState());
                        this.h.setJpegFrame(new JpegFrame(-62, JpegEncodingController.c()));
                        this.h.setScans(new List<JpegScan>(Array.toGenericList(this.r())));
                        this.f = true;
                        break block0;
                    }
                }
                throw new ArgumentOutOfRangeException("CompressionType");
            }
            case 3: {
                if (this.g.getRGBColorProfile() == null || this.g.getCMYKColorProfile() == null) {
                    throw new ArgumentException("Icc profiles needed to perform saving in CMYK format.");
                }
                this.n();
                this.f = true;
                switch (this.g.getCompressionType()) {
                    case 0: {
                        this.e = new HuffmanEncoder(this.getState());
                        this.h.setJpegFrame(new JpegFrame(-64, JpegEncodingController.a()));
                        this.h.setScans(this.f());
                        break block0;
                    }
                    case 1: {
                        this.e = new ProgressiveHuffmanEncoder(this.h);
                        this.h.setJpegFrame(new JpegFrame(-62, JpegEncodingController.a()));
                        this.h.setScans(this.h());
                        break block0;
                    }
                }
                throw new ArgumentOutOfRangeException("CompressionType");
            }
            case 2: {
                this.m();
                this.f = true;
                switch (this.g.getCompressionType()) {
                    case 0: {
                        this.e = new HuffmanEncoder(this.getState());
                        this.h.setJpegFrame(new JpegFrame(-64, JpegEncodingController.a()));
                        this.h.setScans(this.f());
                        break block0;
                    }
                    case 1: {
                        this.e = new ProgressiveHuffmanEncoder(this.h);
                        this.h.setJpegFrame(new JpegFrame(-62, JpegEncodingController.a()));
                        this.h.setScans(this.h());
                        break block0;
                    }
                }
                throw new ArgumentOutOfRangeException("CompressionType");
            }
            case 4: {
                this.j();
                this.f = true;
                switch (this.g.getCompressionType()) {
                    case 0: {
                        this.e = new HuffmanEncoder(this.h);
                        this.h.setJpegFrame(new JpegFrame(-64, JpegEncodingController.b()));
                        this.h.setScans(this.g());
                        break block0;
                    }
                    case 1: {
                        this.e = new ProgressiveHuffmanEncoder(this.h);
                        this.h.setJpegFrame(new JpegFrame(-62, JpegEncodingController.b()));
                        this.h.setScans(this.i());
                        break block0;
                    }
                }
                throw new ArgumentOutOfRangeException("CompressionType");
            }
            default: {
                throw new ArgumentOutOfRangeException("ColorType");
            }
        }
        this.h.getJpegFrame().setX(this.getRectangle().getWidth() & 0xFFFF);
        this.h.getJpegFrame().setY(this.getRectangle().getHeight() & 0xFFFF);
        for (JpegComponentInfo jpegComponentInfo : this.h.getJpegFrame().getComponentInfos()) {
            this.h.getJpegFrame().setHmax(msMath.max(this.h.getJpegFrame().getHmax(), jpegComponentInfo.getH() & 0xFF));
            this.h.getJpegFrame().setVmax(msMath.max(this.h.getJpegFrame().getVmax(), jpegComponentInfo.getV() & 0xFF));
        }
        this.i = JpegUtils.divRoundUp(this.h.getJpegFrame().getY() & 0xFFFF, this.h.getJpegFrame().getVmax() * JpegConstants.BlockSize);
        int n2 = JpegUtils.roundUp(this.h.getJpegFrame().getY() & 0xFFFF, this.h.getJpegFrame().getVmax() * JpegConstants.BlockSize);
        int n3 = JpegUtils.roundUp(this.h.getJpegFrame().getX() & 0xFFFF, this.h.getJpegFrame().getHmax() * JpegConstants.BlockSize);
        this.h.setHeightInBlocks(JpegUtils.divRoundUp(n2, JpegConstants.BlockSize));
        this.h.setWidthInBlocks(JpegUtils.divRoundUp(n3, JpegConstants.BlockSize));
    }

    private static JpegComponentInfo[] a() {
        JpegComponentInfo[] jpegComponentInfoArray = new JpegComponentInfo[]{new JpegComponentInfo(1, 1, 1, 0, 0, 0), new JpegComponentInfo(2, 1, 1, 0, 1, 1), new JpegComponentInfo(3, 1, 1, 0, 1, 1), new JpegComponentInfo(4, 1, 1, 0, 0, 0)};
        return jpegComponentInfoArray;
    }

    private static JpegComponentInfo[] b() {
        JpegComponentInfo[] jpegComponentInfoArray = new JpegComponentInfo[]{new JpegComponentInfo(0, 1, 1, 0, 0, 0), new JpegComponentInfo(1, 1, 1, 0, 0, 0), new JpegComponentInfo(2, 1, 1, 0, 0, 0)};
        return jpegComponentInfoArray;
    }

    private static JpegComponentInfo[] c() {
        JpegComponentInfo[] jpegComponentInfoArray = new JpegComponentInfo[]{new JpegComponentInfo(1, 2, 2, 0, 0, 0), new JpegComponentInfo(2, 1, 1, 1, 1, 1), new JpegComponentInfo(3, 1, 1, 1, 1, 1)};
        return jpegComponentInfoArray;
    }

    private JpegMCU a(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        JpegScan jpegScan = this.h.getScans().get_Item(this.h.currentScanIdx);
        JpegMCU jpegMCU = new JpegMCU(this.h.getBlocksInMCU());
        short[][] sArrayArray = new short[JpegConstants.MaxComponents][];
        int n7 = 0;
        for (n6 = 0; n6 < jpegScan.Components.length; ++n6) {
            n5 = jpegScan.Components[n6];
            if (sArrayArray[n5] != null) continue;
            sArrayArray[n5] = new short[jpegScan.getMaxV() * jpegScan.getMaxH() * JpegConstants.BlockSize2];
        }
        for (n6 = n3 * JpegConstants.BlockSize * jpegScan.getMaxV(); n6 < (n3 + 1) * JpegConstants.BlockSize * jpegScan.getMaxV(); ++n6) {
            for (n5 = 0; n5 < jpegScan.Components.length; ++n5) {
                n4 = jpegScan.Components[n5];
                System.arraycopy(this.a[n4], (n6 * this.h.getWidthInBlocks() + n2 * jpegScan.getMaxH()) * JpegConstants.BlockSize, sArrayArray[jpegScan.Components[n5]], n7, JpegConstants.BlockSize * jpegScan.getMaxH());
            }
            n7 += JpegConstants.BlockSize * jpegScan.getMaxH();
        }
        n6 = 0;
        for (n5 = 0; n5 < jpegScan.Components.length; ++n5) {
            int n8;
            n4 = jpegScan.Components[n5];
            JpegComponentInfo jpegComponentInfo = this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[n5]];
            Object object = new short[jpegScan.getMaxV() * JpegConstants.BlockSize][];
            for (n8 = 0; n8 < jpegScan.getMaxV() * JpegConstants.BlockSize; ++n8) {
                object[n8] = new short[jpegScan.getMaxH() * JpegConstants.BlockSize];
                System.arraycopy(sArrayArray[n4 & 0xFF], n8 * jpegScan.getMaxV() * JpegConstants.BlockSize, object[n8], 0, jpegScan.getMaxH() * JpegConstants.BlockSize);
            }
            object = this.d.getDownsampler(jpegComponentInfo.getId() & 0xFF).downsample((short[][])object);
            for (n8 = 0; n8 < jpegComponentInfo.getMCUHeight(); ++n8) {
                for (int i2 = 0; i2 < jpegComponentInfo.getMCUWidth(); ++i2) {
                    jpegMCU.getBlocks()[n6] = new DataBlock();
                    int n9 = 0;
                    for (int i3 = 0; i3 < JpegConstants.BlockSize; ++i3) {
                        for (int i4 = 0; i4 < JpegConstants.BlockSize; ++i4) {
                            jpegMCU.getBlocks()[n6].getData()[n9] = object[n8 * JpegConstants.BlockSize + i3][i2 * JpegConstants.BlockSize + i4];
                            ++n9;
                        }
                    }
                    ++n6;
                }
            }
        }
        return jpegMCU;
    }

    private JpegMCU b(int n2, int n3) {
        JpegScan jpegScan = this.h.getScans().get_Item(this.h.currentScanIdx);
        int n4 = jpegScan.Components[0];
        int n5 = 0;
        JpegMCU jpegMCU = new JpegMCU(1);
        short[] sArray = new short[JpegConstants.BlockSize2];
        for (int i2 = n3 * JpegConstants.BlockSize; i2 < (n3 + 1) * JpegConstants.BlockSize; ++i2) {
            System.arraycopy(this.a[n4], (i2 * this.h.getWidthInBlocks() + n2) * JpegConstants.BlockSize, sArray, n5, JpegConstants.BlockSize);
            n5 += JpegConstants.BlockSize;
        }
        jpegMCU.getBlocks()[0] = new DataBlock();
        jpegMCU.getBlocks()[0].setData(sArray);
        return jpegMCU;
    }

    private void d() {
    }

    private EntropyTable[] e() {
        this.c.initialize();
        this.e.startGatherEntropy();
        boolean bl2 = this.h.getCurrentScan().Components.length != 1;
        int n2 = bl2 ? this.i : JpegUtils.divRoundUp(this.h.getJpegFrame().getY() & 0xFFFF, JpegConstants.BlockSize);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < this.h.getJpegFrame().getMcusInRow(); ++i3) {
                JpegMCU jpegMCU = bl2 ? this.a(i3, i2) : this.b(i3, i2);
                DataBlock[] dataBlockArray = this.c.forwardDCT(jpegMCU);
                this.e.gatherEntropy(dataBlockArray);
            }
        }
        return this.e.createHuffmanTables();
    }

    private List<JpegScan> f() {
        List<JpegScan> list = new List<JpegScan>();
        int n2 = 0;
        while (n2 < 4) {
            JpegScan jpegScan = new JpegScan();
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        return list;
    }

    private List<JpegScan> g() {
        List<JpegScan> list = new List<JpegScan>();
        JpegScan jpegScan = new JpegScan();
        jpegScan.Components = new int[]{0, 1, 2};
        list.addItem(jpegScan);
        return list;
    }

    private List<JpegScan> h() {
        JpegScan jpegScan;
        List<JpegScan> list = new List<JpegScan>();
        int n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(0, 0, 0, 1, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(1, 5, 0, 2, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(6, 63, 0, 2, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(1, 63, 2, 1, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(0, 0, 1, 0, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 4) {
            jpegScan = new JpegScan(1, 63, 1, 0, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        return list;
    }

    private List<JpegScan> i() {
        JpegScan jpegScan;
        List<JpegScan> list = new List<JpegScan>();
        int n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(0, 0, 0, 1, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(1, 5, 0, 2, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(6, 63, 0, 2, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(1, 63, 2, 1, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(0, 0, 1, 0, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        n2 = 0;
        while (n2 < 3) {
            jpegScan = new JpegScan(1, 63, 1, 0, 1);
            jpegScan.Components = new int[]{n2++};
            list.addItem(jpegScan);
        }
        return list;
    }

    private void j() {
        this.getState().setQuantTables(new Dictionary<Byte, QTable>());
        this.getState().setEntropyTables(new Dictionary<Byte, EntropyTable>());
        this.getState().getQuantTables().set_Item((byte)0, QTable.prepareQuantizationTable((byte)0, DefaultTables.LuminanceQuantizationTable, this.g.getScaledQuality(), true));
    }

    private void k() {
        this.getState().getEntropyTables().set_Item((byte)0, new EntropyTable(0, 0, DefaultTables.DcLuminanceBits, DefaultTables.DcLuminanceValues));
        this.getState().getEntropyTables().set_Item((byte)1, new EntropyTable(1, 0, DefaultTables.AcLuminanceBits, DefaultTables.AcLuminanceValues));
        this.getState().getEntropyTables().set_Item((byte)16, new EntropyTable(0, 1, DefaultTables.DcChromianceBits, DefaultTables.DcChromianceValues));
        this.getState().getEntropyTables().set_Item((byte)17, new EntropyTable(1, 1, DefaultTables.AcChromianceBits, DefaultTables.AcChromianceValues));
    }

    private List<JpegScan> l() {
        List<JpegScan> list = new List<JpegScan>();
        JpegScan jpegScan = new JpegScan();
        jpegScan.Components = new int[]{0, 1, 2};
        list.addItem(jpegScan);
        return list;
    }

    private void m() {
        this.getState().setQuantTables(new Dictionary<Byte, QTable>());
        this.getState().setEntropyTables(new Dictionary<Byte, EntropyTable>());
        this.getState().getQuantTables().set_Item((byte)0, QTable.prepareQuantizationTable((byte)0, DefaultCMYKTables.q1Bytes, this.g.getScaledQuality(), true));
        this.getState().getQuantTables().set_Item((byte)1, QTable.prepareQuantizationTable((byte)1, DefaultCMYKTables.q2Bytes, this.g.getScaledQuality(), true));
    }

    private void n() {
        this.getState().setQuantTables(new Dictionary<Byte, QTable>());
        this.getState().setEntropyTables(new Dictionary<Byte, EntropyTable>());
        this.getState().getQuantTables().set_Item((byte)0, QTable.prepareQuantizationTable((byte)0, DefaultYcckTables.Q1Bytes, this.g.getScaledQuality(), true));
        this.getState().getQuantTables().set_Item((byte)1, QTable.prepareQuantizationTable((byte)1, DefaultYcckTables.Q2Bytes, this.g.getScaledQuality(), true));
    }

    private void o() {
        this.h.setScans(new List<JpegScan>());
        JpegScan jpegScan = new JpegScan();
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
    }

    private void p() {
        this.h.getJpegFrame().getComponentInfos()[1] = new JpegComponentInfo(1, 1, 1, 0, 0, 0);
        this.h.setScans(new List<JpegScan>());
        JpegScan jpegScan = new JpegScan(0, 0, 1, 0, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
        jpegScan = new JpegScan(1, 5, 0, 0, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
        jpegScan = new JpegScan(6, 63, 0, 0, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
        jpegScan = new JpegScan(1, 63, 0, 2, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
        jpegScan = new JpegScan(0, 0, 1, 1, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
        jpegScan = new JpegScan(1, 63, 0, 1, 1);
        jpegScan.Components = new int[]{1};
        this.h.getScans().addItem(jpegScan);
    }

    private void q() {
        this.getState().setQuantTables(new Dictionary<Byte, QTable>());
        this.getState().setEntropyTables(new Dictionary<Byte, EntropyTable>());
        this.getState().getQuantTables().set_Item((byte)0, QTable.prepareQuantizationTable((byte)0, DefaultTables.LuminanceQuantizationTable, this.g.getScaledQuality(), true));
        this.getState().getQuantTables().set_Item((byte)1, QTable.prepareQuantizationTable((byte)1, DefaultTables.ChromianceQuantizationTable, this.g.getScaledQuality(), true));
    }

    private JpegScan[] r() {
        List<JpegScan> list = new List<JpegScan>(10);
        list.addItem(new JpegScan(0, 0, 0, 1, new int[]{0, 1, 2}));
        list.addItem(new JpegScan(1, 5, 0, 2, new int[]{0}));
        list.addItem(new JpegScan(1, 63, 0, 1, new int[]{2}));
        list.addItem(new JpegScan(1, 63, 0, 1, new int[]{1}));
        list.addItem(new JpegScan(6, 63, 0, 2, new int[]{0}));
        list.addItem(new JpegScan(1, 63, 2, 1, new int[]{0}));
        list.addItem(new JpegScan(0, 0, 1, 0, new int[]{0, 1, 2}));
        list.addItem(new JpegScan(1, 63, 1, 0, new int[]{2}));
        list.addItem(new JpegScan(1, 63, 1, 0, new int[]{1}));
        list.addItem(new JpegScan(1, 63, 1, 0, new int[]{0}));
        return list.toArray(new JpegScan[0]);
    }

    private void s() {
        JpegScan jpegScan = this.h.getScans().get_Item(this.h.currentScanIdx);
        if (jpegScan.Components.length == 1) {
            this.h.getJpegFrame().setMcusInRow(JpegUtils.divRoundUp(this.h.getJpegFrame().getX() & 0xFFFF, JpegConstants.BlockSize));
            this.h.setMCURowsInScan(this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[0]].getV() & 0xFF);
            this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[0]].setMCUWidth(1);
            this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[0]].setMCUHeight(1);
            this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[0]].setLastColWidth(1);
            this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[0]].setLastRowHeight(1);
            jpegScan.setMCUMembership(new int[1]);
            jpegScan.getMCUMembership()[0] = jpegScan.Components[0];
            this.h.setBlocksInMCU(1);
            jpegScan.setMaxH(1);
            jpegScan.setMaxV(1);
        } else {
            this.h.getJpegFrame().setMcusInRow(JpegUtils.divRoundUp(this.h.getJpegFrame().getX() & 0xFFFF, this.h.getJpegFrame().getHmax() * JpegConstants.BlockSize));
            this.h.setMCURowsInScan(JpegUtils.divRoundUp(this.h.getJpegFrame().getY() & 0xFFFF, this.h.getJpegFrame().getVmax() * JpegConstants.BlockSize));
            this.h.setBlocksInMCU(0);
            jpegScan.setMaxH(0);
            jpegScan.setMaxV(0);
            for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
                JpegComponentInfo jpegComponentInfo = this.h.getJpegFrame().getComponentInfos()[jpegScan.Components[i2]];
                jpegComponentInfo.setMCUWidth(jpegComponentInfo.getH() & 0xFF);
                jpegComponentInfo.setMCUHeight(jpegComponentInfo.getV() & 0xFF);
                jpegScan.setMaxH(msMath.max(jpegScan.getMaxH(), jpegComponentInfo.getH() & 0xFF));
                jpegScan.setMaxV(msMath.max(jpegScan.getMaxV(), jpegComponentInfo.getV() & 0xFF));
                jpegComponentInfo.setMCUBlocks(jpegComponentInfo.getMCUHeight() * jpegComponentInfo.getMCUWidth());
                jpegComponentInfo.WidthInBlocks = JpegUtils.divRoundUp((this.h.getJpegFrame().getX() & 0xFFFF) * (jpegComponentInfo.getH() & 0xFF), this.h.getJpegFrame().getHmax() * JpegConstants.BlockSize);
                jpegComponentInfo.setHeightInBlocks(JpegUtils.divRoundUp((this.h.getJpegFrame().getY() & 0xFFFF) * (jpegComponentInfo.getV() & 0xFF), this.h.getJpegFrame().getVmax() * JpegConstants.BlockSize));
                int n2 = jpegComponentInfo.WidthInBlocks % jpegComponentInfo.getMCUWidth();
                if (n2 == 0) {
                    n2 = jpegComponentInfo.getMCUWidth();
                }
                jpegComponentInfo.setLastColWidth(n2);
                n2 = jpegComponentInfo.getHeightInBlocks() % jpegComponentInfo.getMCUHeight();
                if (n2 == 0) {
                    n2 = jpegComponentInfo.getMCUHeight();
                }
                jpegComponentInfo.setLastRowHeight(n2);
                int n3 = jpegComponentInfo.getMCUBlocks();
                while (n3-- > 0) {
                    int n4 = this.h.getBlocksInMCU();
                    this.h.setBlocksInMCU(n4 + 1);
                    jpegScan.getMCUMembership()[n4] = jpegScan.Components[i2];
                }
            }
        }
        JpegComponentInfo[] jpegComponentInfoArray = new JpegComponentInfo[this.h.getCurrentScan().Components.length];
        for (int i3 = 0; i3 < this.h.getCurrentScan().Components.length; ++i3) {
            jpegComponentInfoArray[i3] = this.h.getJpegFrame().getComponentInfos()[this.h.getCurrentScan().Components[i3]];
        }
        this.d = new DownSampler(jpegComponentInfoArray, this.h.getJpegFrame().getHmax(), this.h.getJpegFrame().getVmax());
        if (this.f) {
            EntropyTable[] entropyTableArray;
            for (EntropyTable entropyTable : entropyTableArray = this.e()) {
                this.h.getEntropyTables().set_Item(entropyTable.Ti, entropyTable);
            }
        }
        for (EntropyTable entropyTable : this.h.getEntropyTables().getValues()) {
            if (entropyTable.getSent()) continue;
            EntropyTable.write(this.h.getRawDataWriter().getDataStream(), new EntropyTable[]{entropyTable});
        }
    }
}

