/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifBlock;
import com.aspose.html.internal.ms.lang.Operators;

public class GifGraphicsControlBlock
extends GifBlock {
    public static final int BLOCK_HEADER_SIZE = 8;
    public static final byte EXTENSION_LABEL = -7;
    public static final byte SUB_BLOCK_SIZE = 4;
    private int a;
    private byte b;
    private byte c;

    public GifGraphicsControlBlock() {
    }

    public GifGraphicsControlBlock(byte flags, int delayTime, byte transparentColorIndex) {
        this.b = flags;
        this.a = delayTime;
        this.c = transparentColorIndex;
    }

    public GifGraphicsControlBlock(int delayTime, boolean hasTransparentColor, byte transparentColorIndex, boolean requiresUserInput, int disposalMethod) {
        this.b = GifGraphicsControlBlock.createFlags(hasTransparentColor, requiresUserInput, disposalMethod);
        this.a = delayTime;
        this.c = transparentColorIndex;
    }

    public int getDelayTime() {
        return this.a;
    }

    public void setDelayTime(int value) {
        if (Operators.castToUInt16(this.a, 8) != Operators.castToUInt16(value, 8)) {
            this.a = value;
            this.setChanged(true);
        }
    }

    public byte getFlags() {
        return this.b;
    }

    public void setFlags(byte value) {
        if (Operators.castToInt32(this.b, 6) != Operators.castToInt32(value, 6)) {
            this.b = value;
            this.setChanged(true);
        }
    }

    public byte getTransparentColorIndex() {
        return this.c;
    }

    public void setTransparentColorIndex(byte value) {
        if (Operators.castToInt32(value, 6) != Operators.castToInt32(this.c, 6)) {
            this.c = value;
            this.setChanged(true);
        }
    }

    public int getDisposalMethod() {
        return (Operators.castToInt32(this.b, 6) & 0x1C) >> 2;
    }

    public void setDisposalMethod(int value) {
        byte by2 = (byte)value;
        if (Operators.castToInt32(by2, 6) > 7) {
            throw new ArgumentOutOfRangeException("value", "The value must be between 0 and 7");
        }
        byte by3 = this.b = (byte)(Operators.castToInt32(this.b, 6) & 0xE3);
        by3 = (byte)(Operators.castToInt32(by3, 6) | Operators.castToInt32(Operators.castToByte(Operators.castToInt32(by2, 6) << 2, 9), 6));
        if (Operators.castToInt32(this.b, 6) != Operators.castToInt32(by3, 6)) {
            this.b = by3;
            this.setChanged(true);
        }
    }

    public boolean getUserInputExpected() {
        int n2 = Operators.castToInt32(this.b, 6) & 2;
        return n2 > 0;
    }

    public void setUserInputExpected(boolean value) {
        byte by2 = this.b;
        by2 = value ? (byte)(Operators.castToInt32(by2, 6) | 2) : (byte)(Operators.castToInt32(by2, 6) & 0xFD);
        if (Operators.castToInt32(this.b, 6) != Operators.castToInt32(by2, 6)) {
            this.b = by2;
            this.setChanged(true);
        }
    }

    public boolean hasTransparentColor() {
        int n2 = Operators.castToInt32(this.b, 6) & 1;
        return n2 > 0;
    }

    public void setTransparentColor(boolean value) {
        byte by2 = this.b;
        by2 = value ? (byte)(Operators.castToInt32(by2, 6) | 1) : (byte)(Operators.castToInt32(by2, 6) & 0xFE);
        if (Operators.castToInt32(this.b, 6) != Operators.castToInt32(by2, 6)) {
            this.b = by2;
            this.setChanged(true);
        }
    }

    public static byte createFlags(boolean hasTransparentColor, boolean requiresUserInput, int disposalMethod) {
        byte by2;
        byte by3 = 0;
        if (hasTransparentColor) {
            by3 = 1;
        }
        if (requiresUserInput) {
            by3 = (byte)(Operators.castToInt32(by3, 6) | 2);
        }
        if (Operators.castToInt32(by2 = (byte)disposalMethod, 6) > 7) {
            throw new ArgumentOutOfRangeException("disposalMethod", "The disposal method value is not supported.");
        }
        by3 = (byte)(Operators.castToInt32(by3, 6) | Operators.castToInt32(Operators.castToByte(Operators.castToInt32(by2, 6) << 2, 9), 6));
        return by3;
    }

    @Override
    public void save(Stream stream) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        stream.writeByte((byte)33);
        stream.writeByte((byte)-7);
        stream.writeByte((byte)4);
        stream.writeByte(this.b);
        byte[] byArray = BitConverter.getBytesUInt16(this.a);
        stream.write(byArray, 0, byArray.length);
        stream.writeByte(this.c);
        stream.writeByte((byte)0);
    }
}

