/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ValueResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.LzwVariableWidthBlockDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class GifFrameBlockDataReader
implements IRasterImageArgb32PixelLoader {
    private final StreamContainer a;
    private final IColorPalette b;
    private final int c;
    private final int d;
    private final int e;
    private final boolean f;
    private final long g;
    private GifFrameBlock h;

    public GifFrameBlockDataReader(StreamContainer loadPixelsDataStream, long dataStart, boolean interlaced, IColorPalette pixelsPalette, int width, int height, int lzwCodeStartSize) {
        if (loadPixelsDataStream == null) {
            throw new ArgumentNullException("loadPixelsDataStream");
        }
        if (pixelsPalette == null) {
            throw new ArgumentNullException("pixelsPalette");
        }
        this.g = dataStart;
        this.a = loadPixelsDataStream;
        this.b = pixelsPalette;
        this.c = width;
        this.d = height;
        this.e = lzwCodeStartSize;
        this.f = interlaced;
    }

    @Override
    public boolean isRawDataAvailable() {
        return false;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        throw new NotImplementedException();
    }

    public IColorPalette getPalette() {
        return this.b;
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader rawDataLoader) {
        throw new NotImplementedException();
    }

    public void setGifFrameBlock(GifFrameBlock block) {
        this.h = block;
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader partialPixelLoader) {
        PartialPixelLoader partialPixelLoader2 = new PartialPixelLoader(rectangle.Clone(), this, partialPixelLoader);
        this.loadRawData(rectangle.Clone(), partialPixelLoader2);
    }

    public void loadRawData(Rectangle rectangle, IPartialRawDataLoader partialRawDataLoader) {
        this.a.seek(this.g, 0);
        LzwVariableWidthBlockDecoder lzwVariableWidthBlockDecoder = new LzwVariableWidthBlockDecoder(this.a, this.e);
        lzwVariableWidthBlockDecoder.startDecoding();
        PartialRawLoader partialRawLoader = new PartialRawLoader(lzwVariableWidthBlockDecoder, partialRawDataLoader, rectangle.Clone());
        Rectangle.fromLeftTopRightBottom(0, 0, Operators.castToInt32(this.c, 8), rectangle.getBottom()).CloneTo(rectangle);
        if (this.f) {
            PartialProcessor.processInterlaced(rectangle.Clone(), Operators.castToInt32(this.c, 8), Operators.castToInt32(this.d, 8), partialRawLoader);
        } else {
            PartialProcessor.process(rectangle.Clone(), partialRawLoader);
        }
    }

    private static class PartialColorToByteConverter
    implements IPartialArgb32PixelLoader {
        private final IPartialRawDataLoader a;
        private final IColorPalette b;
        private final RgbEntriesPaletteHash c;
        private final int[] d;
        private final byte e;
        private final int f;
        private boolean g = true;

        public PartialColorToByteConverter(IPartialRawDataLoader partialRawDataLoader, IColorPalette colorPalette, int[] reducedPaletteMap, byte transparentColorIndex, int transparentColor) {
            this.a = partialRawDataLoader;
            this.b = colorPalette;
            this.c = new RgbEntriesPaletteHash(colorPalette);
            this.d = reducedPaletteMap;
            this.e = transparentColorIndex;
            this.f = transparentColor;
            if (this.d == null) {
                this.g = false;
            }
        }

        @Override
        public void process(Rectangle pixelsRectangle, int[] pixels, Point start, Point end) {
            byte[] byArray = new byte[pixels.length];
            if (this.g) {
                for (int i2 = 0; i2 < pixels.length; ++i2) {
                    byArray[i2] = pixels[i2] == this.f ? this.e : Operators.castToByte(this.d[this.c.getNearestColorIndex(pixels[i2])], 9);
                }
            } else {
                for (int i3 = 0; i3 < pixels.length; ++i3) {
                    byArray[i3] = Operators.castToByte(this.c.getNearestColorIndex(pixels[i3]), 9);
                }
            }
            this.a.process(pixelsRectangle.Clone(), byArray, start.Clone(), end.Clone());
        }
    }

    private static class PartialRawLoader
    implements IPartialProcessor {
        private final LzwVariableWidthBlockDecoder a;
        private final IPartialRawDataLoader b;
        private final IColorPalette c = null;
        private final ColorPalette d = null;
        private final int[] e = null;
        private final byte f = 0;
        private final int g = 0;
        private final int h = 0;
        private final boolean i = false;
        private final Rectangle j = new Rectangle();

        public PartialRawLoader(LzwVariableWidthBlockDecoder gifDecoder, IPartialRawDataLoader partialPixelLoader, Rectangle desiredRectangle) {
            desiredRectangle.CloneTo(this.j);
            this.a = gifDecoder;
            this.b = partialPixelLoader;
        }

        @Override
        public void process(Rectangle areaToProcess) {
            int n2 = areaToProcess.getWidth();
            int n3 = areaToProcess.getHeight();
            int n4 = n2 * n3;
            if (BufferHelper.getMaxAllowedAllocation() > 0 && n4 > BufferHelper.getMaxAllowedAllocation()) {
                throw new OutOfMemoryException();
            }
            Rectangle rectangle = Rectangle.intersect(areaToProcess.Clone(), this.j.Clone()).Clone();
            byte[] byArray = new byte[n4];
            byte[] byArray2 = null;
            if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0 && !rectangle.equals(Operators.boxing(areaToProcess))) {
                byArray2 = new byte[rectangle.getWidth() * rectangle.getHeight()];
            }
            ValueResult valueResult = this.a.decode(byArray, byArray.length).Clone();
            int n5 = valueResult.Value;
            if (byArray.length != n5 || !valueResult.Success) {
                throw new GifImageException("Found inconsistency in image data. The image data contained has incorrect pixels count.");
            }
            if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
                Rectangle rectangle2 = new Rectangle(rectangle.getLeft() - areaToProcess.getLeft(), rectangle.getTop() - areaToProcess.getTop(), rectangle.getWidth(), rectangle.getHeight());
                byte[] byArray3 = BufferHelper.fillDataSubset(byArray, n2, n3, byArray2, rectangle2.Clone(), false);
                rectangle2.offset(areaToProcess.getLocation().Clone());
                this.b.process(rectangle2.Clone(), byArray3, rectangle2.getLocation().Clone(), new Point(rectangle2.getRight(), rectangle2.getBottom()));
            }
        }
    }

    private static class PartialPixelLoader
    implements IPartialRawDataLoader {
        private final IPartialArgb32PixelLoader a;
        private final GifFrameBlockDataReader b;
        private final Rectangle c = new Rectangle();
        private LoadOptions d;

        public PartialPixelLoader(Rectangle fullRectangle, GifFrameBlockDataReader reader, IPartialArgb32PixelLoader partialPixelLoader) {
            fullRectangle.CloneTo(this.c);
            this.b = reader;
            this.a = partialPixelLoader;
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end) {
            int n2;
            Object object;
            int[] nArray = this.b.b.getArgb32Entries();
            if (this.b.h != null && (object = this.b.h.getControlBlock()) != null && ((GifGraphicsControlBlock)object).hasTransparentColor() && (n2 = Operators.castToInt32(((GifGraphicsControlBlock)object).getTransparentColorIndex(), 6)) >= 0 && n2 < nArray.length) {
                int n3 = n2;
                nArray[n3] = nArray[n3] & 0xFFFFFF;
            }
            object = new PartialConverter(data, rectangle.Clone(), nArray, this.a);
            PartialProcessor.process(this.c.Clone(), (IPartialProcessor)object);
        }

        @Override
        public void process(Rectangle rectangle, byte[] data, Point start, Point end, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }
    }

    private static class PartialConverter
    implements IPartialProcessor {
        private final byte[] a;
        private final IPartialArgb32PixelLoader b;
        private final int[] c;
        private Rectangle d = new Rectangle();

        public PartialConverter(byte[] data, Rectangle dataRect, int[] paletteEntries, IPartialArgb32PixelLoader partialPixelLoader) {
            this.c = paletteEntries;
            this.a = data;
            dataRect.CloneTo(this.d);
            this.b = partialPixelLoader;
        }

        @Override
        public void process(Rectangle areaToProcess) {
            Rectangle rectangle = Rectangle.intersect(this.d.Clone(), areaToProcess.Clone()).Clone();
            if (!rectangle.isEmpty()) {
                int[] nArray = new int[rectangle.getWidth() * rectangle.getHeight()];
                for (int i2 = rectangle.getTop(); i2 < rectangle.getBottom(); ++i2) {
                    int n2 = (i2 - this.d.getTop()) * this.d.getWidth();
                    int n3 = (i2 - rectangle.getTop()) * rectangle.getWidth();
                    for (int i3 = 0; i3 < rectangle.getWidth(); ++i3) {
                        nArray[i3 + n3] = this.c[Operators.castToInt32(this.a[i3 + n2], 6)];
                    }
                }
                this.b.process(rectangle.Clone(), nArray, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
            }
        }
    }
}

