/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

abstract class LzwVariableWidthCompressor {
    public static final int MaxBytesPerBlock = 255;
    public static final int MaxAllowedCodeSize = 12;
    private int a;
    private final int b;
    private final int c;
    private final int d;
    private final int e;
    private int f;
    private int g;

    protected LzwVariableWidthCompressor(int tableBitsSize, int encoderType) {
        if (tableBitsSize > 8) {
            throw new ArgumentOutOfRangeException("tableBitsSize", "Too big code size. The maximal allowed is 8 bits.");
        }
        if (tableBitsSize < 1) {
            throw new ArgumentOutOfRangeException("tableBitsSize", "Too small code size. The minimal allowed is 1 bit.");
        }
        this.a = tableBitsSize;
        if (this.a == 1) {
            this.a = 2;
        }
        if (tableBitsSize + 1 > 12) {
            throw new ArgumentOutOfRangeException("tableBitsSize", StringExtensions.format("Too big code size. The maximal allowed is {0} bits. LZW does not allow compression sizes to be greater than {0} bits", Operators.boxing(12)));
        }
        if (this.a < 2) {
            throw new ArgumentOutOfRangeException("tableBitsSize", "Too small code size. The minimal allowed is 2 bits.");
        }
        this.f = this.a + 1;
        this.b = 1 << this.a;
        this.c = this.b + 1;
        this.d = this.c + 1;
        this.e = encoderType;
    }

    public int getEncoderType() {
        return this.e;
    }

    public int getEoiCode() {
        return this.c;
    }

    public int getClearCode() {
        return this.b;
    }

    public int getIndexShift() {
        return this.d;
    }

    public int getTableSize() {
        return this.a;
    }

    protected int getCodeSize() {
        return this.f;
    }

    protected void setCodeSize(int value) {
        if (value > 12) {
            throw new ArgumentOutOfRangeException("value", StringExtensions.format("Too big code size. The maximal allowed is {0} bits. LZW does not allow compression sizes to be greater than {0} bits", Operators.boxing(12)));
        }
        if (value < 2) {
            throw new ArgumentOutOfRangeException("value", "Too small code size. The minimal allowed is 2 bits.");
        }
        if (this.f != value) {
            this.f = value;
            this.onCodeSizeChanged();
        }
    }

    protected int getMaxValues() {
        return this.g;
    }

    protected void initializeTable() {
        this.g = this.correctMaxValues((1 << this.getCodeSize()) - this.getIndexShift());
    }

    protected void reinitializeTable() {
        int n2 = this.a + 1;
        if (n2 > 12) {
            n2 = 12;
        }
        this.setCodeSize(n2);
        this.g = this.correctMaxValues((1 << this.getCodeSize()) - this.getIndexShift());
    }

    protected int correctMaxValues(int value) {
        return value;
    }

    protected void resizeTable() {
        int n2 = this.f + 1;
        if (n2 > 12) {
            n2 = 12;
        }
        this.setCodeSize(n2);
        this.g = this.correctMaxValues((1 << this.getCodeSize()) - this.getIndexShift());
    }

    protected void onCodeSizeChanged() {
    }
}

