/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.RgbToIndexedConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

class Rgba32PngToIndexedConverter
extends RgbToIndexedConverter {
    private byte a;

    public Rgba32PngToIndexedConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, IColorPalette destinationPalette, int fallbackIndex) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize, destinationPalette, fallbackIndex);
    }

    @Override
    protected void convertToIndexed(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destBytesCount, int lineStartShift) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destBytesCount + outputOffset;
            int n4 = lineStartShift;
            int n5 = n2;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                byte by2;
                byte by3;
                int n6;
                int n7;
                byte by4 = data[n5++];
                if ((n7 = this.DestinationPalette.getNearestColorIndex(n6 = 0xFF000000 | (by4 & 0xFF) << 16 | ((by3 = data[n5++]) & 0xFF) << 8 | (by2 = data[n5++]) & 0xFF)) > this.DestMask) {
                    n7 = this.FallbackIndex;
                }
                byte by5 = (byte)(n7 << n4);
                this.a = (byte)(this.a & 0xFF | by5 & 0xFF);
                if ((n4 -= this.DestinationPixelSize) >= 0 && i3 + 1 != samplesCount) continue;
                n4 = this.InitialBitShift;
                outputData[n3++] = this.a;
                this.a = 0;
            }
        }
    }
}

