/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public abstract class RgbToIndexedConverter
extends ColorConverter {
    protected final int DestMask;
    protected final IColorPalette DestinationPalette;
    protected final int FallbackIndex;
    protected final int InitialBitShift;
    protected final int Ratio;
    protected final int SampleSize;
    protected final int SamplesPerByte;

    protected RgbToIndexedConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, IColorPalette destinationPalette, int fallbackIndex) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
        if (this.DestinationPixelSize <= 8 && destinationPalette == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        this.DestinationPalette = destinationPalette;
        int n2 = (int)msMath.pow(2.0, this.DestinationPixelSize);
        this.DestMask = n2 - 1;
        this.FallbackIndex = fallbackIndex;
        this.SamplesPerByte = 8 / this.DestinationPixelSize;
        this.Ratio = this.SourcePixelSize / this.DestinationPixelSize;
        this.SampleSize = this.SourcePixelSize / 8;
        this.InitialBitShift = 8 - this.DestinationPixelSize;
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        int n2 = (this.SamplesPerByte - bitStart / this.SourcePixelSize % this.SamplesPerByte - 1) * this.DestinationPixelSize;
        this.convertToIndexed(data, offset, bitStart, samplesCount, linesCount, outputData, outputOffset, destinationBytesPerLine, n2);
    }

    protected abstract void convertToIndexed(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9);
}

