/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.RgbToIndexedConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public class Rgb32ToIndexedConverter
extends RgbToIndexedConverter {
    private byte a;

    public Rgb32ToIndexedConverter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize, IColorPalette destinationPalette, int fallbackIndex) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize, destinationPalette, fallbackIndex);
    }

    @Override
    protected void convertToIndexed(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destBytesCount, int lineStartShift) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destBytesCount + outputOffset;
            int n4 = lineStartShift;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                byte by2;
                byte by3;
                int n5;
                int n6;
                int n7 = i3 * this.SampleSize + n2;
                byte by4 = data[n7++];
                byte by5 = data[n7];
                if ((n6 = this.DestinationPalette.getNearestColorIndex(n5 = (by5 & 0xFF) << 24 | ((by3 = data[n7++]) & 0xFF) << 16 | ((by2 = data[n7++]) & 0xFF) << 8 | by4 & 0xFF)) > this.DestMask) {
                    n6 = this.FallbackIndex;
                }
                byte by6 = (byte)(n6 << n4);
                this.a = (byte)(this.a & 0xFF | by6 & 0xFF);
                if ((n4 -= this.DestinationPixelSize) >= 0 && i3 + 1 != samplesCount) continue;
                n4 = this.InitialBitShift;
                outputData[n3++] = this.a;
                this.a = 0;
            }
        }
    }
}

