/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;

public class Rgb24PngToRgb16Converter
extends ColorConverter {
    private static final int a = 31;
    private static final int b = 3;

    public Rgb24PngToRgb16Converter(int width, int height, int lineSize, PixelDataFormat sourceFormat, Rectangle desiredRectangle, PixelDataFormat destinationFormat, int destinationLineSize) {
        super(width, height, lineSize, sourceFormat, desiredRectangle.Clone(), destinationFormat, destinationLineSize);
    }

    @Override
    protected void convert(byte[] data, int offset, int bitStart, int samplesCount, int linesCount, byte[] outputData, int outputOffset, int destinationBytesPerLine) {
        for (int i2 = 0; i2 < linesCount; ++i2) {
            int n2 = offset + this.LineSize * i2;
            int n3 = i2 * destinationBytesPerLine + outputOffset;
            int n4 = n2;
            for (int i3 = 0; i3 < samplesCount; ++i3) {
                byte by2 = data[n4++];
                byte by3 = data[n4++];
                byte by4 = data[n4++];
                int n5 = 0x1F & (int)((double)(by4 & 0xFF) / 8.225806451612904 + 0.5) | 0x1F & (int)((double)(by3 & 0xFF) / 8.225806451612904 + 0.5) << 5 | 0x1F & (int)((double)(by2 & 0xFF) / 8.225806451612904 + 0.5) << 10;
                outputData[n3++] = (byte)(n5 & 0xFF);
                outputData[n3++] = (byte)((n5 & 0xFF00) >> 8);
            }
        }
    }
}

